/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.config;

import io.helidon.common.Prioritized;
import io.helidon.common.reactive.Flow;
import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigMappers;
import io.helidon.config.ConfigSources;
import io.helidon.config.spi.AbstractParsableConfigSource;
import io.helidon.config.spi.ConfigContext;
import io.helidon.config.spi.ConfigNode;
import io.helidon.microprofile.config.MpConfig;
import io.helidon.microprofile.config.MpcSourceEnvironmentVariables;
import io.helidon.microprofile.config.MpcSourceSystemProperties;
import io.helidon.microprofile.config.MpcSourceUrl;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.eclipse.microprofile.config.spi.Converter;

public class MpConfigBuilder
implements ConfigBuilder {
    private static final Logger LOGGER = Logger.getLogger(MpConfigBuilder.class.getName());
    private static final int DEFAULT_ORDINAL = 100;
    private static final int BUILT_IN_ORDINAL = 1;
    private static final List<OrdinalConverter<?>> BUILT_IN_CONVERTERS = MpConfigBuilder.initBuiltInConverters();
    private final List<ConfigSource> mpConfigSources = new LinkedList<ConfigSource>();
    private final List<OrdinalConverter<?>> converters = new LinkedList();
    private final List<io.helidon.config.spi.ConfigSource> helidonConfigSources = new LinkedList<io.helidon.config.spi.ConfigSource>();
    private final Config.Builder helidonConfigBuilder = Config.builder();
    private ClassLoader classLoader;
    private Config helidonConfig;

    MpConfigBuilder() {
        this.helidonConfigBuilder.disableEnvironmentVariablesSource();
        this.helidonConfigBuilder.disableSystemPropertiesSource();
        this.converters.addAll(BUILT_IN_CONVERTERS);
    }

    private static List<OrdinalConverter<?>> initBuiltInConverters() {
        LinkedList result = new LinkedList();
        result.add(new OrdinalConverter<Boolean>(Boolean.TYPE, MpConfigBuilder::toBoolean, 1));
        result.add(new OrdinalConverter<Boolean>(Boolean.class, MpConfigBuilder::toBoolean, 1));
        result.add(new OrdinalConverter<Byte>(Byte.TYPE, Byte::parseByte, 1));
        result.add(new OrdinalConverter<Byte>(Byte.class, Byte::parseByte, 1));
        result.add(new OrdinalConverter<Short>(Short.TYPE, Short::parseShort, 1));
        result.add(new OrdinalConverter<Short>(Short.class, Short::parseShort, 1));
        result.add(new OrdinalConverter<Integer>(Integer.TYPE, Integer::parseInt, 1));
        result.add(new OrdinalConverter<Integer>(Integer.class, Integer::parseInt, 1));
        result.add(new OrdinalConverter<Long>(Long.TYPE, Long::parseLong, 1));
        result.add(new OrdinalConverter<Long>(Long.class, Long::parseLong, 1));
        result.add(new OrdinalConverter<Float>(Float.TYPE, Float::parseFloat, 1));
        result.add(new OrdinalConverter<Float>(Float.class, Float::parseFloat, 1));
        result.add(new OrdinalConverter<Double>(Double.TYPE, Double::parseDouble, 1));
        result.add(new OrdinalConverter<Double>(Double.class, Double::parseDouble, 1));
        result.add(new OrdinalConverter<Character>(Character.TYPE, ConfigMappers::toChar, 1));
        result.add(new OrdinalConverter<Character>(Character.class, ConfigMappers::toChar, 1));
        result.add(new OrdinalConverter<Class>(Class.class, ConfigMappers::toClass, 1));
        return result;
    }

    private static boolean toBoolean(String value) {
        String lower;
        switch (lower = value.toLowerCase()) {
            case "true": 
            case "1": 
            case "yes": 
            case "y": 
            case "on": {
                return true;
            }
        }
        return false;
    }

    public ConfigBuilder addDefaultSources() {
        this.mpConfigSources.add(new MpcSourceSystemProperties());
        this.helidonConfigSources.add(ConfigSources.systemProperties());
        this.mpConfigSources.add(new MpcSourceEnvironmentVariables());
        this.helidonConfigSources.add(ConfigSources.environmentVariables());
        try {
            Enumeration<URL> resources = this.getClassLoader().getResources("META-INF/microprofile-config.properties");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                this.mpConfigSources.add(MpcSourceUrl.create(url));
                this.helidonConfigSources.add((io.helidon.config.spi.ConfigSource)ConfigSources.url((URL)url).build());
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to read microprofile-config.properties", e);
        }
        io.helidon.config.spi.ConfigSource cs = (io.helidon.config.spi.ConfigSource)((AbstractParsableConfigSource.Builder)ConfigSources.classpath((String)"application.yaml").optional()).build();
        this.helidonConfigSources.add(cs);
        cs = (io.helidon.config.spi.ConfigSource)((AbstractParsableConfigSource.Builder)ConfigSources.file((String)"application.yaml").optional()).build();
        this.helidonConfigSources.add(cs);
        return this;
    }

    public ConfigBuilder addDiscoveredSources() {
        ServiceLoader.load(ConfigSource.class, this.getClassLoader()).forEach(this::addConfigSource);
        ServiceLoader.load(ConfigSourceProvider.class, this.getClassLoader()).forEach(csp -> csp.getConfigSources(this.getClassLoader()).forEach(this::addConfigSource));
        return this;
    }

    public ConfigBuilder addDiscoveredConverters() {
        ServiceLoader.load(Converter.class, this.getClassLoader()).forEach(this::addConverter);
        return this;
    }

    public ConfigBuilder forClassLoader(ClassLoader loader) {
        this.classLoader = loader;
        return this;
    }

    public ConfigBuilder withSources(ConfigSource ... sources) {
        for (ConfigSource source : sources) {
            this.addConfigSource(source);
        }
        return this;
    }

    public <T> ConfigBuilder withConverter(Class<T> aClass, int ordinal, Converter<T> converter) {
        this.converters.add(new OrdinalConverter<T>(aClass, converter, ordinal));
        return this;
    }

    public MpConfigBuilder config(Config config) {
        this.helidonConfig = config;
        return this;
    }

    private void addConfigSource(ConfigSource source) {
        LOGGER.finest(() -> "Adding config source: " + source.getName() + " (" + source.getClass().getName() + "), values: " + source.getProperties());
        this.mpConfigSources.add(source);
        this.helidonConfigSources.add(this.wrapSource(source));
    }

    public ConfigBuilder withConverters(Converter<?> ... converters) {
        for (Converter<?> converter : converters) {
            this.addConverter(converter);
        }
        return this;
    }

    public org.eclipse.microprofile.config.Config build() {
        this.orderLists();
        IdentityHashMap configMappers = new IdentityHashMap();
        this.converters.forEach(oc -> {
            Class type = ((OrdinalConverter)oc).type;
            Function<Config, Object> mapper = config -> ((OrdinalConverter)oc).converter.convert((String)config.asString().get());
            configMappers.put(type, mapper);
        });
        if (null == this.helidonConfig) {
            this.helidonConfigSources.sort(Comparator.comparingInt(it -> this.findPriority((io.helidon.config.spi.ConfigSource)it)));
            this.helidonConfigBuilder.sources(this.toSupplierList(this.helidonConfigSources));
            this.helidonConfigBuilder.addMapper(() -> configMappers);
            this.helidonConfig = this.helidonConfigBuilder.build();
        }
        HashMap converterMap = new HashMap();
        for (OrdinalConverter<?> converter : this.converters) {
            converterMap.put(((OrdinalConverter)converter).type, ((OrdinalConverter)converter).converter);
        }
        return new MpConfig(this.helidonConfig, this.mpConfigSources, converterMap);
    }

    private int findPriority(io.helidon.config.spi.ConfigSource it) {
        if (it instanceof Prioritized) {
            return ((Prioritized)it).priority();
        }
        Priority prio = it.getClass().getAnnotation(Priority.class);
        if (null == prio) {
            return 100;
        }
        return prio.value();
    }

    private void orderLists() {
        this.mpConfigSources.sort(Comparator.comparingInt(ConfigSource::getOrdinal));
        this.converters.sort(Comparator.comparingInt(OrdinalConverter::getOrdinal));
        Collections.reverse(this.mpConfigSources);
    }

    private List<Supplier<io.helidon.config.spi.ConfigSource>> toSupplierList(List<io.helidon.config.spi.ConfigSource> configSources) {
        return configSources.stream().map(cs -> () -> cs).collect(Collectors.toList());
    }

    private ClassLoader getClassLoader() {
        return null == this.classLoader ? Thread.currentThread().getContextClassLoader() : this.classLoader;
    }

    private <T> void addConverter(Converter<T> converter) {
        Class type = (Class)this.getTypeOfConverter(converter.getClass());
        if (type == null) {
            throw new IllegalStateException("Converter " + converter.getClass() + " must be a ParameterizedType");
        }
        LOGGER.finest(() -> "Adding converter for type: " + type.getName() + " (" + converter.getClass().getName() + ")");
        this.converters.add(new OrdinalConverter(type, converter, this.findPriority(converter.getClass())));
    }

    private int findPriority(Class<?> aClass) {
        Priority priorityAnnot = aClass.getAnnotation(Priority.class);
        if (null != priorityAnnot) {
            return priorityAnnot.value();
        }
        return 100;
    }

    private Type getTypeOfConverter(Class clazz) {
        Type[] genericInterfaces;
        if (clazz.equals(Object.class)) {
            return null;
        }
        for (Type genericInterface : genericInterfaces = clazz.getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(genericInterface instanceof ParameterizedType) || !(pt = (ParameterizedType)genericInterface).getRawType().equals(Converter.class)) continue;
            Type[] typeArguments = pt.getActualTypeArguments();
            if (typeArguments.length != 1) {
                throw new IllegalStateException("Converter " + clazz + " must be a ParameterizedType.");
            }
            return typeArguments[0];
        }
        return this.getTypeOfConverter(clazz.getSuperclass());
    }

    private OrdinalConfigSource wrapSource(ConfigSource source) {
        io.helidon.config.spi.ConfigSource myCs = ConfigSources.create((Map)source.getProperties()).build();
        return new OrdinalConfigSource(myCs, source.getOrdinal());
    }

    private static final class OrdinalConfigSource
    implements io.helidon.config.spi.ConfigSource,
    Prioritized {
        private final io.helidon.config.spi.ConfigSource configSource;
        private final int ordinal;

        private OrdinalConfigSource(io.helidon.config.spi.ConfigSource configSource, int ordinal) {
            this.configSource = configSource;
            this.ordinal = ordinal;
        }

        public Optional<ConfigNode.ObjectNode> load() throws ConfigException {
            return this.configSource.load();
        }

        public io.helidon.config.spi.ConfigSource get() {
            return this.configSource.get();
        }

        public void init(ConfigContext context) {
            this.configSource.init(context);
        }

        public String description() {
            return this.configSource.description();
        }

        public Flow.Publisher<Optional<ConfigNode.ObjectNode>> changes() {
            return this.configSource.changes();
        }

        public int priority() {
            return 100 - this.ordinal;
        }
    }

    private static class OrdinalConverter<T> {
        private final Class<T> type;
        private final Converter converter;
        private final int ordinal;

        OrdinalConverter(Class<T> type, Converter converter, int ordinal) {
            this.type = type;
            this.converter = converter;
            this.ordinal = ordinal;
        }

        int getOrdinal() {
            return this.ordinal;
        }
    }
}

