/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.config;

import io.helidon.common.NativeImageHelper;
import io.helidon.config.Config;
import io.helidon.config.mp.MpConfig;
import io.helidon.config.mp.MpConfigImpl;
import io.helidon.config.mp.MpConfigProviderResolver;
import io.helidon.microprofile.config.ConfigPropertyLiteral;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import javax.inject.Provider;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

public class ConfigCdiExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(ConfigCdiExtension.class.getName());
    private static final Pattern SPLIT_PATTERN = Pattern.compile("(?<!\\\\),");
    private static final Pattern ESCAPED_COMMA_PATTERN = Pattern.compile("\\,", 16);
    private static final Annotation CONFIG_PROPERTY_LITERAL = new ConfigPropertyLiteral();
    private static final Map<Class<?>, Class<?>> REPLACED_TYPES = new HashMap();
    private final List<InjectionPoint> ips = new LinkedList<InjectionPoint>();

    public ConfigCdiExtension() {
        LOGGER.fine("ConfigCdiExtension instantiated");
    }

    private void harvestConfigPropertyInjectionPointsFromEnabledBean(@Observes ProcessBean<?> event) {
        Bean bean = event.getBean();
        Set beanInjectionPoints = bean.getInjectionPoints();
        if (beanInjectionPoints != null) {
            for (InjectionPoint beanInjectionPoint : beanInjectionPoints) {
                if (beanInjectionPoint == null) continue;
                Set qualifiers = beanInjectionPoint.getQualifiers();
                assert (qualifiers != null);
                for (Annotation qualifier : qualifiers) {
                    if (!(qualifier instanceof ConfigProperty)) continue;
                    this.ips.add(beanInjectionPoint);
                }
            }
        }
    }

    private <X> void harvestConfigPropertyInjectionPointsFromEnabledObserverMethod(@Observes ProcessObserverMethod<?, X> event, BeanManager beanManager) {
        AnnotatedMethod annotatedMethod = event.getAnnotatedMethod();
        List annotatedParameters = annotatedMethod.getParameters();
        if (annotatedParameters != null) {
            block0: for (AnnotatedParameter annotatedParameter : annotatedParameters) {
                if (annotatedParameter == null || annotatedParameter.isAnnotationPresent(Observes.class)) continue;
                InjectionPoint injectionPoint = beanManager.createInjectionPoint(annotatedParameter);
                Set qualifiers = injectionPoint.getQualifiers();
                assert (qualifiers != null);
                for (Annotation qualifier : qualifiers) {
                    if (!(qualifier instanceof ConfigProperty)) continue;
                    this.ips.add(injectionPoint);
                    continue block0;
                }
            }
        }
    }

    private void registerConfigProducer(@Observes AfterBeanDiscovery abd) {
        abd.addBean().addTransitiveTypeClosure(org.eclipse.microprofile.config.Config.class).beanClass(org.eclipse.microprofile.config.Config.class).scope(ApplicationScoped.class).createWith(creationalContext -> new SerializableConfig());
        abd.addBean().addTransitiveTypeClosure(Config.class).beanClass(Config.class).scope(ApplicationScoped.class).createWith(creationalContext -> {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (config instanceof Config) {
                return config;
            }
            return MpConfig.toHelidonConfig((org.eclipse.microprofile.config.Config)config);
        });
        Set<Type> types = this.ips.stream().map(InjectionPoint::getType).map(it -> {
            Class clazz;
            if (it instanceof Class && (clazz = (Class)it).isPrimitive()) {
                return REPLACED_TYPES.getOrDefault(clazz, clazz);
            }
            return it;
        }).collect(Collectors.toSet());
        types.forEach(type -> abd.addBean().addType(type).scope(Dependent.class).addQualifier(CONFIG_PROPERTY_LITERAL).produceWith(it -> this.produce((InjectionPoint)it.select(InjectionPoint.class, new Annotation[0]).get())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validate(@Observes AfterDeploymentValidation add, BeanManager beanManager) {
        CreationalContext cc = beanManager.createCreationalContext(null);
        try {
            this.ips.forEach(ip -> {
                try {
                    beanManager.getInjectableReference(ip, cc);
                }
                catch (Exception e) {
                    add.addDeploymentProblem((Throwable)e);
                }
            });
        }
        finally {
            cc.release();
        }
        this.ips.clear();
    }

    private Object produce(InjectionPoint ip) {
        String defaultValue;
        Object value;
        ConfigProperty annotation = (ConfigProperty)ip.getAnnotated().getAnnotation(ConfigProperty.class);
        String injectedName = ConfigCdiExtension.injectedName(ip);
        String fullPath = ip.getMember().getDeclaringClass().getName() + "." + injectedName;
        String configKey = this.configKey(annotation, fullPath);
        if (NativeImageHelper.isBuildTime()) {
            System.err.println("You are accessing configuration key '" + configKey + "' during container initialization. This will not work nicely with Graal native-image");
        }
        Type type = ip.getType();
        FieldTypes fieldTypes = FieldTypes.create(type);
        org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
        if (config instanceof MpConfigProviderResolver.ConfigDelegate) {
            config = ((MpConfigProviderResolver.ConfigDelegate)config).delegate();
        }
        if (null == (value = this.configValue(config, fieldTypes, configKey, defaultValue = this.defaultValue(annotation), configKey.equals(fullPath.replace('$', '.'))))) {
            throw new NoSuchElementException("Cannot find value for key: " + configKey);
        }
        return value;
    }

    private Object configValue(org.eclipse.microprofile.config.Config config, FieldTypes fieldTypes, String configKey, String defaultValue, boolean defaultConfigKey) {
        Class<?> type0 = fieldTypes.field0().rawType();
        Class<?> type1 = fieldTypes.field1().rawType();
        Class<?> type2 = fieldTypes.field2().rawType();
        if (type0.equals(type1)) {
            return ConfigCdiExtension.withDefault(config, configKey, type0, defaultValue);
        }
        return ConfigCdiExtension.parameterizedConfigValue(config, configKey, defaultConfigKey, defaultValue, type0, type1, type2);
    }

    private static <T> T withDefault(org.eclipse.microprofile.config.Config config, String key, Class<T> type, String configuredDefault) {
        if (OptionalInt.class.equals(type)) {
            return type.cast(config.getOptionalValue(key, Integer.class).map(OptionalInt::of).orElseGet(OptionalInt::empty));
        }
        if (OptionalLong.class.equals(type)) {
            return type.cast(config.getOptionalValue(key, Long.class).map(OptionalLong::of).orElseGet(OptionalLong::empty));
        }
        if (OptionalDouble.class.equals(type)) {
            return type.cast(config.getOptionalValue(key, Double.class).map(OptionalDouble::of).orElseGet(OptionalDouble::empty));
        }
        Optional stringValue = config.getOptionalValue(key, String.class);
        if (stringValue.isEmpty()) {
            return ConfigCdiExtension.convert(key, config, configuredDefault, type);
        }
        return ConfigCdiExtension.convert(key, config, (String)stringValue.get(), type);
    }

    private static <T> T convert(String key, org.eclipse.microprofile.config.Config config, String value, Class<T> type) {
        if (null == value) {
            return null;
        }
        if (String.class.equals(type)) {
            return (T)value;
        }
        if (config instanceof MpConfigImpl) {
            return (T)((Converter)((MpConfigImpl)config).getConverter(type).orElseThrow(() -> new IllegalArgumentException("Did not find converter for type " + type.getName() + ", for key " + key))).convert(value);
        }
        throw new IllegalArgumentException("Helidon CDI MP Config implementation requires Helidon config instance. Current config is " + config.getClass().getName() + ", which is not supported, as we cannot convert arbitrary String values");
    }

    private static Object parameterizedConfigValue(org.eclipse.microprofile.config.Config config, String configKey, boolean defaultConfigKey, String defaultValue, Class<?> rawType, Class<?> typeArg, Class<?> typeArg2) {
        if (Optional.class.isAssignableFrom(rawType)) {
            if (typeArg.equals(typeArg2)) {
                return Optional.ofNullable(ConfigCdiExtension.withDefault(config, configKey, typeArg, defaultValue));
            }
            return Optional.ofNullable(ConfigCdiExtension.parameterizedConfigValue(config, configKey, defaultConfigKey, defaultValue, typeArg, typeArg2, typeArg2));
        }
        if (List.class.isAssignableFrom(rawType)) {
            return ConfigCdiExtension.asList(config, configKey, typeArg, defaultValue);
        }
        if (Supplier.class.isAssignableFrom(rawType)) {
            if (typeArg.equals(typeArg2)) {
                return () -> ConfigCdiExtension.withDefault(config, configKey, typeArg, defaultValue);
            }
            return () -> ConfigCdiExtension.parameterizedConfigValue(config, configKey, defaultConfigKey, defaultValue, typeArg, typeArg2, typeArg2);
        }
        if (Map.class.isAssignableFrom(rawType)) {
            HashMap result = new HashMap();
            config.getPropertyNames().forEach(name -> {
                if (defaultConfigKey || name.startsWith(configKey)) {
                    String key = ConfigCdiExtension.removePrefix(configKey, defaultConfigKey, name);
                    config.getOptionalValue(name, String.class).ifPresent(value -> result.put(key, value));
                }
            });
            return result;
        }
        if (Set.class.isAssignableFrom(rawType)) {
            return new LinkedHashSet(ConfigCdiExtension.asList(config, configKey, typeArg, defaultValue));
        }
        throw new IllegalArgumentException("Cannot create config property for " + rawType + "<" + typeArg + ">, key: " + configKey);
    }

    private static String removePrefix(String prefix, boolean defaultConfigKey, String key) {
        if (defaultConfigKey) {
            return key;
        }
        String intermediate = key.substring(prefix.length());
        if (intermediate.startsWith(".")) {
            return intermediate.substring(1);
        }
        return intermediate;
    }

    static String[] toArray(String stringValue) {
        String[] values = SPLIT_PATTERN.split(stringValue, -1);
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            values[i] = ESCAPED_COMMA_PATTERN.matcher(value).replaceAll(Matcher.quoteReplacement(","));
        }
        return values;
    }

    private static <T> List<T> asList(org.eclipse.microprofile.config.Config config, String configKey, Class<T> typeArg, String defaultValue) {
        Optional optionalValue = config.getOptionalValue(configKey, String.class);
        if (optionalValue.isPresent()) {
            return ConfigCdiExtension.toList(configKey, config, (String)optionalValue.get(), typeArg);
        }
        String indexedConfigKey = configKey + ".0";
        optionalValue = config.getOptionalValue(indexedConfigKey, String.class);
        if (optionalValue.isPresent()) {
            LinkedList<T> result = new LinkedList<T>();
            result.add(ConfigCdiExtension.convert(indexedConfigKey, config, (String)optionalValue.get(), typeArg));
            for (int i = 1; i < 1000 && (optionalValue = config.getOptionalValue(indexedConfigKey = configKey + "." + i, String.class)).isPresent(); ++i) {
                result.add(ConfigCdiExtension.convert(indexedConfigKey, config, (String)optionalValue.get(), typeArg));
            }
            return result;
        }
        if (null == defaultValue) {
            throw new NoSuchElementException("Missing list value for key " + configKey);
        }
        return ConfigCdiExtension.toList(configKey, config, defaultValue, typeArg);
    }

    private static <T> List<T> toList(String configKey, org.eclipse.microprofile.config.Config config, String stringValue, Class<T> typeArg) {
        if (stringValue.isEmpty()) {
            return List.of();
        }
        LinkedList<T> result = new LinkedList<T>();
        for (String value : ConfigCdiExtension.toArray(stringValue)) {
            result.add(ConfigCdiExtension.convert(configKey, config, value, typeArg));
        }
        return result;
    }

    private String defaultValue(ConfigProperty annotation) {
        String defaultFromAnnotation = annotation.defaultValue();
        if (defaultFromAnnotation.equals("org.eclipse.microprofile.config.configproperty.unconfigureddvalue")) {
            return null;
        }
        return defaultFromAnnotation;
    }

    private String configKey(ConfigProperty annotation, String fullPath) {
        String keyFromAnnotation = annotation.name();
        if (keyFromAnnotation.isEmpty()) {
            return fullPath.replace('$', '.');
        }
        return keyFromAnnotation;
    }

    private Type actualType(Type type) {
        ParameterizedType paramType;
        if (type instanceof ParameterizedType && Provider.class.isAssignableFrom((Class)(paramType = (ParameterizedType)type).getRawType())) {
            return paramType.getActualTypeArguments()[0];
        }
        return type;
    }

    private static String injectedName(InjectionPoint ip) {
        Annotated annotated = ip.getAnnotated();
        if (annotated instanceof AnnotatedField) {
            AnnotatedField f = (AnnotatedField)annotated;
            return f.getJavaMember().getName();
        }
        if (annotated instanceof AnnotatedParameter) {
            AnnotatedParameter p = (AnnotatedParameter)annotated;
            Member member = ip.getMember();
            if (member instanceof Method) {
                return member.getName() + "_" + p.getPosition();
            }
            if (member instanceof Constructor) {
                return "new_" + p.getPosition();
            }
        }
        return ip.getMember().getName();
    }

    static {
        REPLACED_TYPES.put(Byte.TYPE, Byte.class);
        REPLACED_TYPES.put(Short.TYPE, Short.class);
        REPLACED_TYPES.put(Integer.TYPE, Integer.class);
        REPLACED_TYPES.put(Long.TYPE, Long.class);
        REPLACED_TYPES.put(Float.TYPE, Float.class);
        REPLACED_TYPES.put(Double.TYPE, Double.class);
        REPLACED_TYPES.put(Boolean.TYPE, Boolean.class);
        REPLACED_TYPES.put(Character.TYPE, Character.class);
    }

    private static final class SerializableConfig
    implements org.eclipse.microprofile.config.Config,
    Serializable {
        private static final long serialVersionUID = 1L;
        private transient org.eclipse.microprofile.config.Config theConfig = ConfigProvider.getConfig();

        private SerializableConfig() {
        }

        public <T> T getValue(String propertyName, Class<T> propertyType) {
            return (T)this.theConfig.getValue(propertyName, propertyType);
        }

        public <T> Optional<T> getOptionalValue(String propertyName, Class<T> propertyType) {
            return this.theConfig.getOptionalValue(propertyName, propertyType);
        }

        public Iterable<String> getPropertyNames() {
            return this.theConfig.getPropertyNames();
        }

        public Iterable<ConfigSource> getConfigSources() {
            return this.theConfig.getConfigSources();
        }

        private void readObject(ObjectInputStream ios) throws ClassNotFoundException, IOException {
            ios.defaultReadObject();
            this.theConfig = ConfigProvider.getConfig();
        }
    }

    static final class FieldTypes {
        private TypedField field0;
        private TypedField field1;
        private TypedField field2;

        FieldTypes() {
        }

        private static FieldTypes create(Type type) {
            FieldTypes ft = new FieldTypes();
            TypedField firstType = FieldTypes.getTypedField(type);
            if (Provider.class.isAssignableFrom(firstType.rawType)) {
                firstType = ft.field0 = FieldTypes.getTypedField(firstType);
            } else {
                ft.field0 = firstType;
            }
            ft.field1 = FieldTypes.getTypedField(ft.field0);
            ft.field2 = firstType.rawType == Optional.class || firstType.rawType == Supplier.class ? FieldTypes.getTypedField(ft.field1) : ft.field1;
            return ft;
        }

        private static TypedField getTypedField(Type type) {
            if (type instanceof Class) {
                return new TypedField((Class)type);
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType paramType = (ParameterizedType)type;
                return new TypedField((Class)paramType.getRawType(), paramType);
            }
            throw new UnsupportedOperationException("No idea how to handle " + type);
        }

        private static TypedField getTypedField(TypedField field) {
            if (field.isParameterized()) {
                ParameterizedType paramType = field.paramType;
                Object[] typeArgs = paramType.getActualTypeArguments();
                if (typeArgs.length == 1) {
                    Type typeArg = typeArgs[0];
                    return FieldTypes.getTypedField(typeArg);
                }
                if (typeArgs.length == 2 && field.rawType == Map.class && typeArgs[0] == typeArgs[1] && typeArgs[0] == String.class) {
                    return new TypedField(String.class);
                }
                throw new DeploymentException("Cannot create config property for " + field.rawType + ", params: " + Arrays.toString(typeArgs));
            }
            return field;
        }

        private TypedField field0() {
            return this.field0;
        }

        private TypedField field1() {
            return this.field1;
        }

        private TypedField field2() {
            return this.field2;
        }

        private static final class TypedField {
            private final Class<?> rawType;
            private ParameterizedType paramType;

            private TypedField(Class<?> rawType) {
                this.rawType = rawType;
            }

            private TypedField(Class<?> rawType, ParameterizedType paramType) {
                this.rawType = rawType;
                this.paramType = paramType;
            }

            private boolean isParameterized() {
                return this.paramType != null;
            }

            private Class<?> rawType() {
                return this.rawType;
            }

            private ParameterizedType getParamType() {
                return this.paramType;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                TypedField that = (TypedField)o;
                return Objects.equals(this.rawType, that.rawType) && Objects.equals(this.paramType, that.paramType);
            }

            public int hashCode() {
                return Objects.hash(this.rawType, this.paramType);
            }

            public String toString() {
                return "TypedField{rawType=" + this.rawType + ", paramType=" + this.paramType + "}";
            }
        }
    }
}

