/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.grpc.client;

import io.grpc.Channel;
import io.helidon.config.Config;
import io.helidon.grpc.client.GrpcChannelsProvider;
import io.helidon.microprofile.grpc.client.GrpcChannel;
import io.helidon.microprofile.grpc.core.InProcessGrpcChannel;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@ApplicationScoped
public class ChannelProducer {
    private final GrpcChannelsProvider provider;
    private final Map<String, Channel> channelMap = new ConcurrentHashMap<String, Channel>();

    @Inject
    ChannelProducer(Config config) {
        this.provider = GrpcChannelsProvider.create((Config)config.get("grpc"));
    }

    @Produces
    @GrpcChannel(name="default")
    public Channel get(InjectionPoint injectionPoint) {
        GrpcChannel qualifier = injectionPoint.getQualifiers().stream().filter(q -> q.annotationType().equals(GrpcChannel.class)).map(q -> (GrpcChannel)q).findFirst().orElse(null);
        String name = qualifier == null ? "default" : qualifier.name();
        return this.findChannel(name);
    }

    @Produces
    public Channel getDefaultChannel() {
        return this.findChannel("default");
    }

    Channel findChannel(String name) {
        return this.channelMap.computeIfAbsent(name, arg_0 -> ((GrpcChannelsProvider)this.provider).channel(arg_0));
    }

    static Channel inProcessChannel(BeanManager beanManager) {
        return ChannelProducer.inProcessChannel((Instance<Object>)beanManager.createInstance());
    }

    static Channel inProcessChannel(Instance<Object> instance) {
        return (Channel)instance.select(Channel.class, new Annotation[]{InProcessGrpcChannel.Literal.INSTANCE}).get();
    }
}

