/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.grpc.client;

import jakarta.enterprise.inject.spi.BeanAttributes;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

class DelegatingBeanAttributes<T>
implements BeanAttributes<T> {
    private final BeanAttributes<?> delegate;
    private final Set<Type> types;

    private DelegatingBeanAttributes(BeanAttributes<?> delegate, Set<Type> types) {
        Objects.requireNonNull(delegate);
        this.delegate = delegate;
        this.types = Collections.unmodifiableSet(types);
    }

    static <T> DelegatingBeanAttributes<T> create(BeanAttributes<?> delegate, Set<Type> types) {
        return new DelegatingBeanAttributes<T>(delegate, types);
    }

    public String getName() {
        return this.delegate.getName();
    }

    public Set<Annotation> getQualifiers() {
        return this.delegate.getQualifiers();
    }

    public Class<? extends Annotation> getScope() {
        return this.delegate.getScope();
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return this.delegate.getStereotypes();
    }

    public Set<Type> getTypes() {
        if (this.types == null || this.types.isEmpty()) {
            return this.delegate.getTypes();
        }
        return this.types;
    }

    public boolean isAlternative() {
        return this.delegate.isAlternative();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

