/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.grpc.client;

import io.helidon.microprofile.grpc.client.DelegatingBeanAttributes;
import io.helidon.microprofile.grpc.client.GrpcChannel;
import io.helidon.microprofile.grpc.client.GrpcProxy;
import io.helidon.microprofile.grpc.client.GrpcProxyProducer;
import io.helidon.microprofile.grpc.core.InProcessGrpcChannel;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanAttributes;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessInjectionPoint;
import jakarta.enterprise.inject.spi.ProducerFactory;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;

public class GrpcClientCdiExtension
implements Extension {
    private final Set<Type> proxyTypes = new HashSet<Type>();
    private final Set<Type> inProcessProxyTypes = new HashSet<Type>();

    public <T, X> void gatherApplications(@Observes ProcessInjectionPoint<T, X> pip) {
        Annotated annotated = pip.getInjectionPoint().getAnnotated();
        if (annotated.isAnnotationPresent(GrpcProxy.class)) {
            Type type = pip.getInjectionPoint().getType();
            if (annotated.isAnnotationPresent(InProcessGrpcChannel.class)) {
                this.inProcessProxyTypes.add(type);
            } else {
                this.proxyTypes.add(type);
            }
        }
    }

    public void afterBean(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        AnnotatedType producerType = beanManager.createAnnotatedType(GrpcProxyProducer.class);
        AnnotatedMethod producerMethod = producerType.getMethods().stream().filter(m -> m.isAnnotationPresent(GrpcProxy.class)).filter(m -> m.isAnnotationPresent(GrpcChannel.class)).findFirst().get();
        AnnotatedMethod inProcessMethod = producerType.getMethods().stream().filter(m -> m.isAnnotationPresent(GrpcProxy.class)).filter(m -> m.isAnnotationPresent(InProcessGrpcChannel.class)).findFirst().get();
        for (Type type : this.proxyTypes) {
            this.addProducerBean(event, beanManager, (AnnotatedMethod<? super GrpcProxyProducer>)producerMethod, type);
        }
        for (Type type : this.inProcessProxyTypes) {
            this.addProducerBean(event, beanManager, (AnnotatedMethod<? super GrpcProxyProducer>)inProcessMethod, type);
        }
    }

    private void addProducerBean(AfterBeanDiscovery event, BeanManager beanManager, AnnotatedMethod<? super GrpcProxyProducer> producerMethod, Type type) {
        BeanAttributes producerAttributes = beanManager.createBeanAttributes(producerMethod);
        ProducerFactory factory = beanManager.getProducerFactory(producerMethod, null);
        Set<Type> types = Set.of(Object.class, type);
        DelegatingBeanAttributes beanAttributes = DelegatingBeanAttributes.create(producerAttributes, types);
        event.addBean(beanManager.createBean(beanAttributes, GrpcProxyProducer.class, factory));
    }
}

