/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.grpc.client;

import io.grpc.Channel;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.helidon.common.Builder;
import io.helidon.grpc.client.ClientServiceDescriptor;
import io.helidon.grpc.client.GrpcServiceClient;
import io.helidon.microprofile.grpc.client.GrpcClientBuilder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GrpcProxyBuilder<T>
implements Builder<GrpcProxyBuilder<T>, T> {
    private static final Map<Class<?>, ClientServiceDescriptor> DESCRIPTORS = new ConcurrentHashMap();
    private final GrpcServiceClient client;
    private final Class<T> type;

    private GrpcProxyBuilder(GrpcServiceClient client, Class<T> type) {
        this.client = client;
        this.type = type;
    }

    public static <T> GrpcProxyBuilder<T> create(Class<T> type) {
        return GrpcProxyBuilder.create("grpc.server", type);
    }

    public static <T> GrpcProxyBuilder<T> create(String serverName, Class<T> type) {
        return GrpcProxyBuilder.create((Channel)InProcessChannelBuilder.forName((String)serverName).usePlaintext().build(), type);
    }

    public static <T> GrpcProxyBuilder<T> create(Channel channel, Class<T> type) {
        ClientServiceDescriptor descriptor = DESCRIPTORS.computeIfAbsent(type, GrpcProxyBuilder::createDescriptor);
        return new GrpcProxyBuilder<T>(GrpcServiceClient.builder((Channel)channel, (ClientServiceDescriptor)descriptor).build(), type);
    }

    public T build() {
        return (T)this.client.proxy(this.type, new Class[0]);
    }

    private static ClientServiceDescriptor createDescriptor(Class<?> type) {
        GrpcClientBuilder builder = GrpcClientBuilder.create(type);
        ClientServiceDescriptor.Builder descriptorBuilder = builder.build();
        return descriptorBuilder.build();
    }
}

