/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.grpc.client;

import io.grpc.Channel;
import io.helidon.microprofile.grpc.client.ChannelProducer;
import io.helidon.microprofile.grpc.client.GrpcChannel;
import io.helidon.microprofile.grpc.client.GrpcProxy;
import io.helidon.microprofile.grpc.client.GrpcProxyBuilder;
import io.helidon.microprofile.grpc.core.InProcessGrpcChannel;
import io.helidon.microprofile.grpc.core.ModelHelper;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.reflect.Type;

class GrpcProxyProducer {
    private GrpcProxyProducer() {
    }

    @GrpcProxy
    @GrpcChannel(name="default")
    static Object proxyUsingNamedChannel(InjectionPoint injectionPoint, ChannelProducer producer) {
        Class type = ModelHelper.getGenericType((Type)injectionPoint.getType());
        String channelName = injectionPoint.getAnnotated().isAnnotationPresent(GrpcChannel.class) ? ((GrpcChannel)injectionPoint.getAnnotated().getAnnotation(GrpcChannel.class)).name() : (type.isAnnotationPresent(GrpcChannel.class) ? type.getAnnotation(GrpcChannel.class).name() : "default");
        Channel channel = producer.findChannel(channelName);
        GrpcProxyBuilder builder = GrpcProxyBuilder.create(channel, type);
        return builder.build();
    }

    @GrpcProxy
    @InProcessGrpcChannel
    static Object proxyUsingInProcessChannel(InjectionPoint injectionPoint, BeanManager beanManager) {
        Class type = ModelHelper.getGenericType((Type)injectionPoint.getType());
        Channel channel = ChannelProducer.inProcessChannel(beanManager);
        GrpcProxyBuilder builder = GrpcProxyBuilder.create(channel, type);
        return builder.build();
    }
}

