/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.grpc.client;

import io.grpc.Channel;
import io.helidon.config.Config;
import io.helidon.grpc.api.Grpc;
import io.helidon.microprofile.grpc.client.GrpcChannelsProvider;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

@ApplicationScoped
public class ChannelProducer {
    private final GrpcChannelsProvider provider;
    private final ReentrantLock lock = new ReentrantLock();
    private final Map<String, Channel> channelMap = new HashMap<String, Channel>();

    @Inject
    ChannelProducer(Config config) {
        this.provider = GrpcChannelsProvider.create(config.get("grpc.client"));
    }

    @Produces
    public Channel get(InjectionPoint injectionPoint) {
        Grpc.GrpcChannel qualifier = injectionPoint.getAnnotated().getAnnotations().stream().filter(q -> q.annotationType().equals(Grpc.GrpcChannel.class)).map(q -> (Grpc.GrpcChannel)q).findFirst().orElse(null);
        String name = qualifier == null ? "default" : qualifier.value();
        return this.findChannel(name);
    }

    public Channel findChannel(String name) {
        try {
            this.lock.lock();
            Channel channel = this.channelMap.computeIfAbsent(name, this.provider::channel);
            return channel;
        }
        finally {
            this.lock.unlock();
        }
    }
}

