/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.grpc.client;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigBuilderSupport;
import io.helidon.common.tls.Tls;
import io.helidon.common.tls.TlsConfig;
import io.helidon.microprofile.grpc.client.GrpcChannelDescriptorBlueprint;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.microprofile.grpc.client.GrpcChannelDescriptorBlueprint")
public interface GrpcChannelDescriptor
extends GrpcChannelDescriptorBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GrpcChannelDescriptor instance) {
        return (Builder)GrpcChannelDescriptor.builder().from(instance);
    }

    public static GrpcChannelDescriptor create(Config config) {
        return ((Builder)GrpcChannelDescriptor.builder().config(config)).buildPrototype();
    }

    public static GrpcChannelDescriptor create() {
        return GrpcChannelDescriptor.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, GrpcChannelDescriptor>
    implements io.helidon.common.Builder<Builder, GrpcChannelDescriptor> {
        private Builder() {
        }

        public GrpcChannelDescriptor buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.GrpcChannelDescriptorImpl(this);
        }

        public GrpcChannelDescriptor build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends GrpcChannelDescriptor>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private Config config;
        private int port = 1408;
        private String host = "localhost";
        private String name;
        private String target;
        private Tls tls;

        protected BuilderBase() {
        }

        public BUILDER from(GrpcChannelDescriptor prototype) {
            this.name(prototype.name());
            this.host(prototype.host());
            this.port(prototype.port());
            this.target(prototype.target());
            this.tls(prototype.tls());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.name().ifPresent(this::name);
            this.host(builder.host());
            this.port(builder.port());
            builder.target().ifPresent(this::target);
            builder.tls().ifPresent(this::tls);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("name").as(String.class).ifPresent(this::name);
            config.get("host").as(String.class).ifPresent(this::host);
            config.get("port").as(Integer.class).ifPresent(this::port);
            config.get("target").as(String.class).ifPresent(this::target);
            config.get("tls").map(TlsConfig::create).ifPresent(this::tls);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER host(String host) {
            Objects.requireNonNull(host);
            this.host = host;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER port(int port) {
            this.port = port;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearTarget() {
            this.target = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER target(String target) {
            Objects.requireNonNull(target);
            this.target = target;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearTls() {
            this.tls = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER tls(Tls tls) {
            Objects.requireNonNull(tls);
            this.tls = tls;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER tls(TlsConfig tlsConfig) {
            Objects.requireNonNull(tlsConfig);
            this.tls = Tls.create((TlsConfig)tlsConfig);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER tls(Consumer<TlsConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TlsConfig.Builder builder = TlsConfig.builder();
            consumer.accept(builder);
            this.tls(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<String> name() {
            return Optional.ofNullable(this.name);
        }

        public String host() {
            return this.host;
        }

        public int port() {
            return this.port;
        }

        public Optional<String> target() {
            return Optional.ofNullable(this.target);
        }

        public Optional<Tls> tls() {
            return Optional.ofNullable(this.tls);
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "GrpcChannelDescriptorBuilder{name=" + this.name + ",host=" + this.host + ",port=" + this.port + ",target=" + this.target + ",tls=" + String.valueOf(this.tls) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.name == null) {
                collector.fatal(this.getClass(), "Property \"name\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER target(Optional<String> target) {
            Objects.requireNonNull(target);
            this.target = target.map(String.class::cast).orElse(this.target);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER tls(Optional<? extends Tls> tls) {
            Objects.requireNonNull(tls);
            this.tls = tls.map(Tls.class::cast).orElse(this.tls);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class GrpcChannelDescriptorImpl
        implements GrpcChannelDescriptor {
            private final int port;
            private final Optional<Tls> tls;
            private final Optional<String> target;
            private final String host;
            private final String name;

            protected GrpcChannelDescriptorImpl(BuilderBase<?, ?> builder) {
                this.name = builder.name().get();
                this.host = builder.host();
                this.port = builder.port();
                this.target = builder.target();
                this.tls = builder.tls();
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public String host() {
                return this.host;
            }

            @Override
            public int port() {
                return this.port;
            }

            @Override
            public Optional<String> target() {
                return this.target;
            }

            @Override
            public Optional<Tls> tls() {
                return this.tls;
            }

            public String toString() {
                return "GrpcChannelDescriptor{name=" + this.name + ",host=" + this.host + ",port=" + this.port + ",target=" + String.valueOf(this.target) + ",tls=" + String.valueOf(this.tls) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof GrpcChannelDescriptor)) {
                    return false;
                }
                GrpcChannelDescriptor other = (GrpcChannelDescriptor)o;
                return Objects.equals(this.name, other.name()) && Objects.equals(this.host, other.host()) && this.port == other.port() && Objects.equals(this.target, other.target()) && Objects.equals(this.tls, other.tls());
            }

            public int hashCode() {
                return Objects.hash(this.name, this.host, this.port, this.target, this.tls);
            }
        }
    }
}

