/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.grpc.client;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigBuilderSupport;
import io.helidon.microprofile.grpc.client.GrpcChannelDescriptor;
import io.helidon.microprofile.grpc.client.GrpcChannelsDescriptorBlueprint;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.microprofile.grpc.client.GrpcChannelsDescriptorBlueprint")
public interface GrpcChannelsDescriptor
extends GrpcChannelsDescriptorBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GrpcChannelsDescriptor instance) {
        return (Builder)GrpcChannelsDescriptor.builder().from(instance);
    }

    public static GrpcChannelsDescriptor create(Config config) {
        return ((Builder)GrpcChannelsDescriptor.builder().config(config)).buildPrototype();
    }

    public static GrpcChannelsDescriptor create() {
        return GrpcChannelsDescriptor.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, GrpcChannelsDescriptor>
    implements io.helidon.common.Builder<Builder, GrpcChannelsDescriptor> {
        private Builder() {
        }

        public GrpcChannelsDescriptor buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.GrpcChannelsDescriptorImpl(this);
        }

        public GrpcChannelsDescriptor build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends GrpcChannelsDescriptor>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final List<GrpcChannelDescriptor> channels = new ArrayList<GrpcChannelDescriptor>();
        private boolean isChannelsMutated;
        private Config config;

        protected BuilderBase() {
        }

        public BUILDER from(GrpcChannelsDescriptor prototype) {
            if (!this.isChannelsMutated) {
                this.channels.clear();
            }
            this.addChannels(prototype.channels());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            if (this.isChannelsMutated) {
                if (builder.isChannelsMutated) {
                    this.addChannels(builder.channels);
                }
            } else {
                this.channels.clear();
                this.addChannels(builder.channels);
            }
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("channels").mapList(GrpcChannelDescriptor::create).ifPresent(this::channels);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER channels(List<? extends GrpcChannelDescriptor> channels) {
            Objects.requireNonNull(channels);
            this.isChannelsMutated = true;
            this.channels.clear();
            this.channels.addAll(channels);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addChannels(List<? extends GrpcChannelDescriptor> channels) {
            Objects.requireNonNull(channels);
            this.isChannelsMutated = true;
            this.channels.addAll(channels);
            return (BUILDER)((BuilderBase)this.self());
        }

        public List<GrpcChannelDescriptor> channels() {
            return this.channels;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "GrpcChannelsDescriptorBuilder{channels=" + String.valueOf(this.channels) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        protected static class GrpcChannelsDescriptorImpl
        implements GrpcChannelsDescriptor {
            private final List<GrpcChannelDescriptor> channels;

            protected GrpcChannelsDescriptorImpl(BuilderBase<?, ?> builder) {
                this.channels = List.copyOf(builder.channels());
            }

            @Override
            public List<GrpcChannelDescriptor> channels() {
                return this.channels;
            }

            public String toString() {
                return "GrpcChannelsDescriptor{channels=" + String.valueOf(this.channels) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof GrpcChannelsDescriptor)) {
                    return false;
                }
                GrpcChannelsDescriptor other = (GrpcChannelsDescriptor)o;
                return Objects.equals(this.channels, other.channels());
            }

            public int hashCode() {
                return Objects.hash(this.channels);
            }
        }
    }
}

