/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.grpc.client;

import io.grpc.Channel;
import io.helidon.common.tls.Tls;
import io.helidon.config.Config;
import io.helidon.microprofile.grpc.client.GrpcChannelDescriptor;
import io.helidon.microprofile.grpc.client.GrpcChannelsDescriptor;
import io.helidon.webclient.grpc.GrpcClient;
import io.helidon.webclient.grpc.GrpcClientConfig;
import java.util.HashMap;
import java.util.Map;

public class GrpcChannelsProvider {
    public static final String DEFAULT_CHANNEL_NAME = "default";
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 1408;
    private final Map<String, GrpcChannelDescriptor> channelConfigs;

    private GrpcChannelsProvider(Map<String, GrpcChannelDescriptor> channelDescriptors) {
        this.channelConfigs = new HashMap<String, GrpcChannelDescriptor>(channelDescriptors);
    }

    public static GrpcChannelsProvider create() {
        return GrpcChannelsProvider.builder().build();
    }

    public static GrpcChannelsProvider create(Config config) {
        return new Builder(config).build();
    }

    public static Builder builder() {
        return GrpcChannelsProvider.builder(null);
    }

    public static Builder builder(Config config) {
        return new Builder(config);
    }

    public Channel channel(String name) {
        if (name == null) {
            throw new NullPointerException("name cannot be null.");
        }
        if (name.trim().isEmpty()) {
            throw new IllegalArgumentException("name cannot be empty or blank.");
        }
        GrpcChannelDescriptor chCfg = this.channelConfigs.computeIfAbsent(name, hostName -> ((GrpcChannelDescriptor.Builder)((GrpcChannelDescriptor.Builder)GrpcChannelDescriptor.builder().name(name)).host(name)).build());
        return this.createChannel(name, chCfg);
    }

    private Channel createChannel(String name, GrpcChannelDescriptor descriptor) {
        Tls clientTls = descriptor.tls().orElse(null);
        if (clientTls == null) {
            throw new IllegalArgumentException("Client TLS must be configured for gRPC proxy client");
        }
        int port = descriptor.port();
        GrpcClient grpcClient = ((GrpcClientConfig.Builder)((GrpcClientConfig.Builder)GrpcClient.builder().tls(clientTls)).baseUri("https://" + descriptor.host() + ":" + port)).build();
        return grpcClient.channel();
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, GrpcChannelsProvider> {
        private final Map<String, GrpcChannelDescriptor> channelConfigs = new HashMap<String, GrpcChannelDescriptor>();

        private Builder(Config config) {
            this.channel(GrpcChannelsProvider.DEFAULT_CHANNEL_NAME, ((GrpcChannelDescriptor.Builder)GrpcChannelDescriptor.builder().name(GrpcChannelsProvider.DEFAULT_CHANNEL_NAME)).build());
            if (config == null) {
                return;
            }
            GrpcChannelsDescriptor channelsDescriptor = ((GrpcChannelsDescriptor.Builder)GrpcChannelsDescriptor.builder().config((io.helidon.common.config.Config)config)).build();
            channelsDescriptor.channels().forEach(ch -> this.channelConfigs.put(ch.name(), (GrpcChannelDescriptor)ch));
        }

        public Builder channel(String name, GrpcChannelDescriptor descriptor) {
            this.channelConfigs.put(name, descriptor);
            return this;
        }

        public GrpcChannelsProvider build() {
            return new GrpcChannelsProvider(this.channelConfigs);
        }
    }
}

