/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.grpc.client;

import io.helidon.common.Builder;
import io.helidon.grpc.api.Grpc;
import io.helidon.grpc.core.MethodHandler;
import io.helidon.microprofile.grpc.client.ClientMethodDescriptor;
import io.helidon.microprofile.grpc.client.ClientServiceDescriptor;
import io.helidon.microprofile.grpc.core.AbstractServiceBuilder;
import io.helidon.microprofile.grpc.core.AnnotatedMethod;
import io.helidon.microprofile.grpc.core.AnnotatedMethodList;
import io.helidon.microprofile.grpc.core.InstanceSupplier;
import io.helidon.microprofile.grpc.core.ModelHelper;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;

class GrpcClientBuilder
extends AbstractServiceBuilder
implements Builder<GrpcClientBuilder, ClientServiceDescriptor.Builder> {
    private static final System.Logger LOGGER = System.getLogger(GrpcClientBuilder.class.getName());

    private GrpcClientBuilder(Class<?> serviceClass, Supplier<?> instance) {
        super(serviceClass, instance);
    }

    static GrpcClientBuilder create(Object service) {
        return new GrpcClientBuilder(service.getClass(), InstanceSupplier.singleton((Object)service));
    }

    static GrpcClientBuilder create(Class<?> serviceClass) {
        return new GrpcClientBuilder(Objects.requireNonNull(serviceClass), GrpcClientBuilder.createInstanceSupplier(serviceClass));
    }

    public ClientServiceDescriptor.Builder build() {
        this.checkForNonPublicMethodIssues();
        Class annotatedServiceClass = this.annotatedServiceClass();
        AnnotatedMethodList methodList = AnnotatedMethodList.create((Class)annotatedServiceClass);
        String name = this.determineServiceName(annotatedServiceClass);
        ClientServiceDescriptor.Builder builder = ClientServiceDescriptor.builder(this.serviceClass()).name(name).marshallerSupplier(this.getMarshallerSupplier());
        this.addServiceMethods(builder, methodList);
        LOGGER.log(System.Logger.Level.DEBUG, () -> String.format("A new gRPC service was created by ServiceModeller: %s", builder));
        return builder;
    }

    private void addServiceMethods(ClientServiceDescriptor.Builder builder, AnnotatedMethodList methodList) {
        for (AnnotatedMethod am : methodList.withAnnotation(Grpc.GrpcMethod.class)) {
            this.addServiceMethod(builder, am);
        }
        for (AnnotatedMethod am : methodList.withMetaAnnotation(Grpc.GrpcMethod.class)) {
            this.addServiceMethod(builder, am);
        }
    }

    private void addServiceMethod(ClientServiceDescriptor.Builder builder, AnnotatedMethod method) {
        Grpc.GrpcMethod annotation = (Grpc.GrpcMethod)method.firstAnnotationOrMetaAnnotation(Grpc.GrpcMethod.class);
        String name = GrpcClientBuilder.determineMethodName((AnnotatedMethod)method, (Grpc.GrpcMethod)annotation);
        MethodHandler handler = this.handlerSuppliers().stream().filter(supplier -> supplier.supplies(method)).findFirst().map(supplier -> supplier.get(name, method, this.instanceSupplier())).orElseThrow(() -> new IllegalArgumentException("Cannot locate a method handler supplier for method " + String.valueOf(method)));
        Class requestType = handler.getRequestType();
        Class responseType = handler.getResponseType();
        AnnotatedMethodConfigurer configurer = new AnnotatedMethodConfigurer(method, requestType, responseType, handler);
        switch (annotation.value()) {
            case UNARY: {
                builder.unary(name, (Consumer)configurer);
                break;
            }
            case CLIENT_STREAMING: {
                builder.clientStreaming(name, (Consumer)configurer);
                break;
            }
            case SERVER_STREAMING: {
                builder.serverStreaming(name, (Consumer)configurer);
                break;
            }
            case BIDI_STREAMING: {
                builder.bidirectional(name, (Consumer)configurer);
                break;
            }
            default: {
                LOGGER.log(System.Logger.Level.ERROR, () -> "Unrecognized method type " + String.valueOf(annotation.value()));
            }
        }
    }

    private static class AnnotatedMethodConfigurer
    implements Consumer<ClientMethodDescriptor.Rules> {
        private final AnnotatedMethod method;
        private final Class<?> requestType;
        private final Class<?> responseType;
        private final MethodHandler methodHandler;

        private AnnotatedMethodConfigurer(AnnotatedMethod method, Class<?> requestType, Class<?> responseType, MethodHandler methodHandler) {
            this.method = method;
            this.requestType = requestType;
            this.responseType = responseType;
            this.methodHandler = methodHandler;
        }

        @Override
        public void accept(ClientMethodDescriptor.Rules config) {
            config.requestType(this.requestType).responseType(this.responseType).methodHandler(this.methodHandler);
            if (this.method.isAnnotationPresent(Grpc.GrpcMarshaller.class)) {
                config.marshallerSupplier(ModelHelper.getMarshallerSupplier((Grpc.GrpcMarshaller)((Grpc.GrpcMarshaller)this.method.getAnnotation(Grpc.GrpcMarshaller.class))));
            }
        }
    }
}

