/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.grpc.client;

import io.helidon.grpc.api.Grpc;
import io.helidon.microprofile.grpc.client.ChannelProducer;
import io.helidon.microprofile.grpc.client.DelegatingBeanAttributes;
import io.helidon.microprofile.grpc.client.GrpcProxyProducer;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanAttributes;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessInjectionPoint;
import jakarta.enterprise.inject.spi.ProducerFactory;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;

public class GrpcClientCdiExtension
implements Extension {
    private final Set<Type> proxyTypes = new HashSet<Type>();

    public void addBeans(@Observes BeforeBeanDiscovery event) {
        event.addAnnotatedType(ChannelProducer.class, ChannelProducer.class.getName());
    }

    public <T, X> void gatherApplications(@Observes ProcessInjectionPoint<T, X> pip) {
        Annotated annotated = pip.getInjectionPoint().getAnnotated();
        if (annotated.isAnnotationPresent(Grpc.GrpcProxy.class)) {
            Type type = pip.getInjectionPoint().getType();
            this.proxyTypes.add(type);
        }
    }

    public void afterBean(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        AnnotatedType producerType = beanManager.createAnnotatedType(GrpcProxyProducer.class);
        AnnotatedMethod producerMethod = producerType.getMethods().stream().filter(m -> m.isAnnotationPresent(Grpc.GrpcProxy.class)).filter(m -> m.isAnnotationPresent(Grpc.GrpcChannel.class)).findFirst().orElse(null);
        if (producerMethod != null) {
            for (Type type : this.proxyTypes) {
                this.addProducerBean(event, beanManager, (AnnotatedMethod<? super GrpcProxyProducer>)producerMethod, type);
            }
        }
    }

    private void addProducerBean(AfterBeanDiscovery event, BeanManager beanManager, AnnotatedMethod<? super GrpcProxyProducer> producerMethod, Type type) {
        BeanAttributes producerAttributes = beanManager.createBeanAttributes(producerMethod);
        ProducerFactory factory = beanManager.getProducerFactory(producerMethod, null);
        Set<Type> types = Set.of(Object.class, type);
        DelegatingBeanAttributes beanAttributes = DelegatingBeanAttributes.create(producerAttributes, types);
        event.addBean(beanManager.createBean(beanAttributes, GrpcProxyProducer.class, factory));
    }
}

