/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.grpc.client;

import io.grpc.Channel;
import io.helidon.common.Builder;
import io.helidon.microprofile.grpc.client.ClientServiceDescriptor;
import io.helidon.microprofile.grpc.client.GrpcClientBuilder;
import io.helidon.microprofile.grpc.client.GrpcConfigurablePort;
import io.helidon.microprofile.grpc.client.GrpcServiceClient;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GrpcProxyBuilder<T>
implements Builder<GrpcProxyBuilder<T>, T> {
    private static final Map<Class<?>, ClientServiceDescriptor> DESCRIPTORS = new ConcurrentHashMap();
    private final GrpcServiceClient client;
    private final Class<T> type;

    private GrpcProxyBuilder(GrpcServiceClient client, Class<T> type) {
        this.client = client;
        this.type = type;
    }

    public static <T> GrpcProxyBuilder<T> create(Channel channel, Class<T> type) {
        ClientServiceDescriptor descriptor = DESCRIPTORS.computeIfAbsent(type, GrpcProxyBuilder::createDescriptor);
        return new GrpcProxyBuilder<T>(GrpcServiceClient.builder(channel, descriptor).build(), type);
    }

    public T build() {
        return this.client.proxy(this.type, GrpcConfigurablePort.class);
    }

    private static ClientServiceDescriptor createDescriptor(Class<?> type) {
        GrpcClientBuilder builder = GrpcClientBuilder.create(type);
        ClientServiceDescriptor.Builder descriptorBuilder = builder.build();
        return descriptorBuilder.build();
    }
}

