/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.grpc.server;

import io.grpc.BindableService;
import io.grpc.Channel;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.config.Config;
import io.helidon.config.mp.MpConfig;
import io.helidon.grpc.server.GrpcRouting;
import io.helidon.grpc.server.GrpcServer;
import io.helidon.grpc.server.GrpcServerConfiguration;
import io.helidon.grpc.server.GrpcService;
import io.helidon.microprofile.grpc.core.Grpc;
import io.helidon.microprofile.grpc.core.InProcessGrpcChannel;
import io.helidon.microprofile.grpc.server.GrpcServiceBuilder;
import io.helidon.microprofile.grpc.server.spi.GrpcMpContext;
import io.helidon.microprofile.grpc.server.spi.GrpcMpExtension;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeShutdown;
import jakarta.enterprise.inject.spi.Extension;
import java.lang.annotation.Annotation;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.ConfigProvider;

public class GrpcServerCdiExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(GrpcServerCdiExtension.class.getName());
    private static final Logger STARTUP_LOGGER = Logger.getLogger("io.helidon.microprofile.startup.server");
    private GrpcServer server;

    private void startServer(@Observes @Initialized(value=ApplicationScoped.class) Object event, BeanManager beanManager) {
        GrpcRouting.Builder routingBuilder = this.discoverGrpcRouting(beanManager);
        Config config = MpConfig.toHelidonConfig((org.eclipse.microprofile.config.Config)ConfigProvider.getConfig());
        GrpcServerConfiguration.Builder serverConfiguration = GrpcServerConfiguration.builder((Config)config.get("grpc"));
        CompletableFuture<GrpcServer> startedFuture = new CompletableFuture<GrpcServer>();
        CompletableFuture<GrpcServer> shutdownFuture = new CompletableFuture<GrpcServer>();
        this.loadExtensions(beanManager, config, routingBuilder, serverConfiguration, startedFuture, shutdownFuture);
        this.server = GrpcServer.create((GrpcServerConfiguration)serverConfiguration.build(), (GrpcRouting)routingBuilder.build());
        long beforeT = System.nanoTime();
        this.server.start().whenComplete((grpcServer, throwable) -> {
            if (null != throwable) {
                STARTUP_LOGGER.log(Level.SEVERE, (Throwable)throwable, () -> "gRPC server startup failed");
                startedFuture.completeExceptionally((Throwable)throwable);
            } else {
                long t = TimeUnit.MILLISECONDS.convert(System.nanoTime() - beforeT, TimeUnit.NANOSECONDS);
                int port = grpcServer.port();
                STARTUP_LOGGER.finest("gRPC server started up");
                LOGGER.info(() -> "gRPC server started on localhost:" + port + " (and all other host addresses) in " + t + " milliseconds.");
                grpcServer.whenShutdown().whenComplete((server, error) -> {
                    if (error == null) {
                        shutdownFuture.complete((GrpcServer)server);
                    } else {
                        shutdownFuture.completeExceptionally((Throwable)error);
                    }
                });
                startedFuture.complete((GrpcServer)grpcServer);
            }
        });
        ServerProducer serverProducer = (ServerProducer)beanManager.createInstance().select(ServerProducer.class, new Annotation[0]).get();
        serverProducer.server(this.server);
    }

    private void stopServer(@Observes BeforeShutdown event) {
        if (this.server != null) {
            LOGGER.info("Stopping gRPC server");
            long beforeT = System.nanoTime();
            this.server.shutdown().whenComplete((webServer, throwable) -> {
                if (null != throwable) {
                    LOGGER.log(Level.SEVERE, (Throwable)throwable, () -> "An error occurred stopping the gRPC server");
                } else {
                    long t = TimeUnit.MILLISECONDS.convert(System.nanoTime() - beforeT, TimeUnit.NANOSECONDS);
                    LOGGER.info(() -> "gRPC Server stopped in " + t + " milliseconds.");
                }
            });
        }
    }

    private GrpcRouting.Builder discoverGrpcRouting(BeanManager beanManager) {
        Instance instance = beanManager.createInstance();
        GrpcRouting.Builder builder = GrpcRouting.builder();
        beanManager.getBeans(Object.class, new Annotation[]{Any.Literal.INSTANCE}).stream().filter(this::hasGrpcQualifier).forEach(bean -> {
            Class beanClass = bean.getBeanClass();
            Annotation[] qualifiers = bean.getQualifiers().toArray(new Annotation[0]);
            Object service = instance.select(beanClass, qualifiers).get();
            this.register(service, builder, beanClass, beanManager);
        });
        beanManager.getBeans(GrpcService.class, new Annotation[0]).forEach(bean -> {
            Class beanClass = bean.getBeanClass();
            Annotation[] qualifiers = bean.getQualifiers().toArray(new Annotation[0]);
            Object service = instance.select(beanClass, qualifiers).get();
            builder.register((GrpcService)service);
        });
        beanManager.getBeans(BindableService.class, new Annotation[0]).forEach(bean -> {
            Class beanClass = bean.getBeanClass();
            Annotation[] qualifiers = bean.getQualifiers().toArray(new Annotation[0]);
            Object service = instance.select(beanClass, qualifiers).get();
            builder.register((BindableService)service);
        });
        return builder;
    }

    private boolean hasGrpcQualifier(Bean<?> bean) {
        return bean.getQualifiers().stream().anyMatch(q -> Grpc.class.isAssignableFrom(q.annotationType()));
    }

    private void loadExtensions(final BeanManager beanManager, final Config config, final GrpcRouting.Builder routingBuilder, final GrpcServerConfiguration.Builder serverConfiguration, final CompletionStage<GrpcServer> whenStarted, final CompletionStage<GrpcServer> whenShutdown) {
        GrpcMpContext context = new GrpcMpContext(){

            @Override
            public Config config() {
                return config;
            }

            @Override
            public GrpcServerConfiguration.Builder grpcServerConfiguration() {
                return serverConfiguration;
            }

            @Override
            public GrpcRouting.Builder routing() {
                return routingBuilder;
            }

            @Override
            public BeanManager beanManager() {
                return beanManager;
            }

            @Override
            public CompletionStage<GrpcServer> whenStarted() {
                return whenStarted;
            }

            @Override
            public CompletionStage<GrpcServer> whenShutdown() {
                return whenShutdown;
            }
        };
        HelidonServiceLoader.create(ServiceLoader.load(GrpcMpExtension.class)).forEach(ext -> ext.configure(context));
        beanManager.createInstance().select(GrpcMpExtension.class, new Annotation[0]).stream().forEach(ext -> ext.configure(context));
    }

    private void register(Object service, GrpcRouting.Builder builder, Class<?> cls, BeanManager beanManager) {
        GrpcServiceBuilder serviceBuilder = GrpcServiceBuilder.create(cls, () -> service, beanManager);
        if (serviceBuilder.isAnnotatedService()) {
            builder.register(serviceBuilder.build());
        } else {
            LOGGER.log(Level.WARNING, () -> "Discovered type is not a properly annotated gRPC service " + service.getClass());
        }
    }

    @ApplicationScoped
    public static class ServerProducer {
        private GrpcServer server;

        @Produces
        public GrpcServer server() {
            return this.server;
        }

        @Produces
        public Supplier<GrpcServer> supply() {
            return this::server;
        }

        @Produces
        @InProcessGrpcChannel
        public Channel channel() {
            String name = this.server.configuration().name();
            return InProcessChannelBuilder.forName((String)name).usePlaintext().build();
        }

        @Produces
        @InProcessGrpcChannel
        public InProcessChannelBuilder channelBuilder() {
            String name = this.server.configuration().name();
            return InProcessChannelBuilder.forName((String)name);
        }

        void server(GrpcServer server) {
            this.server = server;
        }
    }
}

