/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.grpc.server;

import io.grpc.ServerInterceptor;
import io.grpc.stub.ServerCalls;
import io.helidon.common.Builder;
import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.grpc.core.ContextKeys;
import io.helidon.grpc.core.MethodHandler;
import io.helidon.grpc.server.MethodDescriptor;
import io.helidon.grpc.server.ServiceDescriptor;
import io.helidon.microprofile.grpc.core.AbstractServiceBuilder;
import io.helidon.microprofile.grpc.core.AnnotatedMethod;
import io.helidon.microprofile.grpc.core.AnnotatedMethodList;
import io.helidon.microprofile.grpc.core.GrpcInterceptor;
import io.helidon.microprofile.grpc.core.GrpcInterceptorBinding;
import io.helidon.microprofile.grpc.core.GrpcInterceptors;
import io.helidon.microprofile.grpc.core.GrpcMarshaller;
import io.helidon.microprofile.grpc.core.GrpcMethod;
import io.helidon.microprofile.grpc.core.Instance;
import io.helidon.microprofile.grpc.core.MethodHandlerSupplier;
import io.helidon.microprofile.grpc.core.ModelHelper;
import io.helidon.microprofile.grpc.server.AnnotatedServiceConfigurer;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class GrpcServiceBuilder
extends AbstractServiceBuilder
implements Builder<GrpcServiceBuilder, ServiceDescriptor> {
    private static final Logger LOGGER = Logger.getLogger(GrpcServiceBuilder.class.getName());
    private final BeanManager beanManager;

    private GrpcServiceBuilder(Class<?> serviceClass, Supplier<?> instance, BeanManager beanManager) {
        super(serviceClass, instance);
        this.beanManager = beanManager;
    }

    public static GrpcServiceBuilder create(Object service, BeanManager beanManager) {
        return new GrpcServiceBuilder(service.getClass(), Instance.singleton((Object)service), beanManager);
    }

    public static GrpcServiceBuilder create(Class<?> serviceClass, BeanManager beanManager) {
        return new GrpcServiceBuilder(Objects.requireNonNull(serviceClass), GrpcServiceBuilder.createInstanceSupplier(serviceClass), beanManager);
    }

    public static GrpcServiceBuilder create(Class<?> serviceClass, Supplier<?> instance, BeanManager beanManager) {
        return new GrpcServiceBuilder(serviceClass, instance, beanManager);
    }

    public ServiceDescriptor build() {
        this.checkForNonPublicMethodIssues();
        Class annotatedServiceClass = this.annotatedServiceClass();
        AnnotatedMethodList methodList = AnnotatedMethodList.create((Class)annotatedServiceClass);
        String name = this.determineServiceName(annotatedServiceClass);
        ServiceDescriptor.Builder builder = ServiceDescriptor.builder((Class)this.serviceClass(), (String)name).marshallerSupplier(this.getMarshallerSupplier());
        this.addServiceMethods(builder, methodList, this.beanManager);
        this.configureServiceInterceptors(builder, this.beanManager);
        Class serviceClass = this.serviceClass();
        Class annotatedClass = this.annotatedServiceClass();
        HelidonServiceLoader.create(ServiceLoader.load(AnnotatedServiceConfigurer.class)).forEach(configurer -> configurer.accept(serviceClass, annotatedClass, builder));
        return builder.build();
    }

    private void addServiceMethods(ServiceDescriptor.Builder builder, AnnotatedMethodList methodList, BeanManager beanManager) {
        for (AnnotatedMethod am : methodList.withAnnotation(GrpcMethod.class)) {
            this.addServiceMethod(builder, am, beanManager);
        }
        for (AnnotatedMethod am : methodList.withMetaAnnotation(GrpcMethod.class)) {
            this.addServiceMethod(builder, am, beanManager);
        }
    }

    private void addServiceMethod(ServiceDescriptor.Builder builder, AnnotatedMethod method, BeanManager beanManager) {
        GrpcMethod annotation = (GrpcMethod)method.firstAnnotationOrMetaAnnotation(GrpcMethod.class);
        String name = GrpcServiceBuilder.determineMethodName((AnnotatedMethod)method, (GrpcMethod)annotation);
        Supplier instanceSupplier = this.instanceSupplier();
        MethodHandler handler = this.handlerSuppliers().stream().filter(supplier -> supplier.supplies(method)).findFirst().map(arg_0 -> GrpcServiceBuilder.lambda$addServiceMethod$2(name, method, (Supplier)instanceSupplier, arg_0)).orElseThrow(() -> new IllegalArgumentException("Cannot locate a method handler supplier for method " + method));
        Class requestType = handler.getRequestType();
        Class responseType = handler.getResponseType();
        List<ServerInterceptor> interceptors = this.lookupMethodInterceptors(beanManager, method);
        GrpcInterceptors grpcInterceptors = (GrpcInterceptors)method.getAnnotation(GrpcInterceptors.class);
        if (grpcInterceptors != null) {
            for (Class interceptorClass : grpcInterceptors.value()) {
                ServerInterceptor interceptor = this.resolveInterceptor(beanManager, interceptorClass);
                if (interceptor == null) continue;
                interceptors.add(interceptor);
            }
        }
        AnnotatedMethodConfigurer configurer = new AnnotatedMethodConfigurer(method, requestType, responseType, interceptors);
        switch (annotation.type()) {
            case UNARY: {
                builder.unary(name, (ServerCalls.UnaryMethod)handler, (MethodDescriptor.Configurer)configurer);
                break;
            }
            case CLIENT_STREAMING: {
                builder.clientStreaming(name, (ServerCalls.ClientStreamingMethod)handler, (MethodDescriptor.Configurer)configurer);
                break;
            }
            case SERVER_STREAMING: {
                builder.serverStreaming(name, (ServerCalls.ServerStreamingMethod)handler, (MethodDescriptor.Configurer)configurer);
                break;
            }
            case BIDI_STREAMING: {
                builder.bidirectional(name, (ServerCalls.BidiStreamingMethod)handler, (MethodDescriptor.Configurer)configurer);
                break;
            }
            default: {
                LOGGER.log(Level.SEVERE, () -> "Unrecognized method type " + annotation.type());
            }
        }
    }

    private void configureServiceInterceptors(ServiceDescriptor.Builder builder, BeanManager beanManager) {
        if (beanManager != null) {
            Class serviceClass = this.serviceClass();
            Class annotatedClass = this.annotatedServiceClass();
            this.configureServiceInterceptors(builder, beanManager, this.serviceClass());
            if (!serviceClass.equals(annotatedClass)) {
                this.configureServiceInterceptors(builder, beanManager, this.annotatedServiceClass());
            }
        }
    }

    private void configureServiceInterceptors(ServiceDescriptor.Builder builder, BeanManager beanManager, Class<?> cls) {
        if (beanManager != null) {
            for (Annotation annotation : cls.getAnnotations()) {
                if (!annotation.annotationType().isAnnotationPresent(GrpcInterceptorBinding.class)) continue;
                builder.intercept(new ServerInterceptor[]{this.lookupInterceptor(annotation, beanManager)});
            }
            GrpcInterceptors grpcInterceptors = cls.getAnnotation(GrpcInterceptors.class);
            if (grpcInterceptors != null) {
                for (Class interceptorClass : grpcInterceptors.value()) {
                    ServerInterceptor interceptor;
                    if (!ServerInterceptor.class.isAssignableFrom(interceptorClass) || (interceptor = this.resolveInterceptor(beanManager, interceptorClass)) == null) continue;
                    builder.intercept(new ServerInterceptor[]{interceptor});
                }
            }
        }
    }

    private List<ServerInterceptor> lookupMethodInterceptors(BeanManager beanManager, AnnotatedMethod method) {
        if (beanManager == null) {
            return Collections.emptyList();
        }
        ArrayList<ServerInterceptor> interceptors = new ArrayList<ServerInterceptor>();
        for (Annotation annotation : method.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(GrpcInterceptorBinding.class)) continue;
            interceptors.add(this.lookupInterceptor(annotation, beanManager));
        }
        return interceptors;
    }

    private ServerInterceptor lookupInterceptor(Annotation annotation, BeanManager beanManager) {
        jakarta.enterprise.inject.Instance instance = beanManager.createInstance().select(ServerInterceptor.class, new Annotation[]{GrpcInterceptor.Literal.INSTANCE});
        List interceptors = instance.stream().filter(interceptor -> this.hasAnnotation((ServerInterceptor)interceptor, annotation)).collect(Collectors.toList());
        if (interceptors.size() == 1) {
            return (ServerInterceptor)interceptors.get(0);
        }
        if (interceptors.size() > 1) {
            throw new IllegalStateException("gRPC interceptor annotationresolves to ambiguous interceptor implementations " + annotation);
        }
        throw new IllegalStateException("Cannot resolve a gRPC interceptor bean for annotation" + annotation);
    }

    private ServerInterceptor resolveInterceptor(BeanManager beanManager, Class<?> cls) {
        if (beanManager == null) {
            return null;
        }
        if (ServerInterceptor.class.isAssignableFrom(cls)) {
            jakarta.enterprise.inject.Instance instance = beanManager.createInstance().select(cls, new Annotation[]{Any.Literal.INSTANCE});
            if (instance.isResolvable()) {
                return (ServerInterceptor)instance.get();
            }
            try {
                return (ServerInterceptor)cls.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException("Cannot create gRPC interceptor", e);
            }
        }
        throw new IllegalArgumentException("Specified interceptor class " + cls + " is not a " + ServerInterceptor.class);
    }

    private boolean hasAnnotation(ServerInterceptor interceptor, Annotation annotation) {
        Annotation[] annotations = this.getClass(interceptor).getAnnotations();
        return Arrays.asList(annotations).contains(annotation);
    }

    private Class<?> getClass(Object o) {
        Class<?> cls = o.getClass();
        while (cls.isSynthetic()) {
            cls = cls.getSuperclass();
        }
        return cls;
    }

    private static /* synthetic */ MethodHandler lambda$addServiceMethod$2(String name, AnnotatedMethod method, Supplier instanceSupplier, MethodHandlerSupplier supplier) {
        return supplier.get(name, method, instanceSupplier);
    }

    private static class AnnotatedMethodConfigurer
    implements MethodDescriptor.Configurer {
        private final AnnotatedMethod method;
        private final Class<?> requestType;
        private final Class<?> responseType;
        private final List<ServerInterceptor> interceptors;

        private AnnotatedMethodConfigurer(AnnotatedMethod method, Class<?> requestType, Class<?> responseType, List<ServerInterceptor> interceptors) {
            this.method = method;
            this.requestType = requestType;
            this.responseType = responseType;
            this.interceptors = interceptors;
        }

        public void configure(MethodDescriptor.Rules rules) {
            rules.addContextValue(ContextKeys.SERVICE_METHOD, (Object)this.method.declaredMethod()).requestType(this.requestType).responseType(this.responseType);
            if (this.method.isAnnotationPresent(GrpcMarshaller.class)) {
                rules.marshallerSupplier(ModelHelper.getMarshallerSupplier((GrpcMarshaller)((GrpcMarshaller)this.method.getAnnotation(GrpcMarshaller.class))));
            }
            this.interceptors.forEach(xva$0 -> rules.intercept(new ServerInterceptor[]{xva$0}));
        }
    }
}

