/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.health;

import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.config.Config;
import io.helidon.config.mp.MpConfig;
import io.helidon.health.HealthSupport;
import io.helidon.health.common.BuiltInHealthCheck;
import io.helidon.microprofile.health.HealthCheckProvider;
import io.helidon.microprofile.health.JvmRuntimeProducers;
import io.helidon.microprofile.server.RoutingBuilders;
import io.helidon.webserver.Service;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.Extension;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.health.Health;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;

public class HealthCdiExtension
implements Extension {
    private static final Health HEALTH_LITERAL = new Health(){

        public Class<? extends Annotation> annotationType() {
            return Health.class;
        }
    };
    private static final BuiltInHealthCheck BUILT_IN_HEALTH_CHECK_LITERAL = new BuiltInHealthCheck(){

        public Class<? extends Annotation> annotationType() {
            return BuiltInHealthCheck.class;
        }
    };
    private static final Logger LOGGER = Logger.getLogger(HealthCdiExtension.class.getName());

    void registerProducers(@Observes BeforeBeanDiscovery bbd) {
        bbd.addAnnotatedType(JvmRuntimeProducers.class, "health.JvmRuntimeProducers").add((Annotation)ApplicationScoped.Literal.INSTANCE);
    }

    void registerHealth(@Observes @Priority(value=1010) @Initialized(value=ApplicationScoped.class) Object adv) {
        org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
        Config helidonConfig = MpConfig.toHelidonConfig((org.eclipse.microprofile.config.Config)config).get("health");
        if (!config.getOptionalValue("health.enabled", Boolean.class).orElse(true).booleanValue()) {
            LOGGER.finest("Health support is disabled in configuration");
            return;
        }
        HealthSupport.Builder builder = HealthSupport.builder().config(helidonConfig);
        CDI cdi = CDI.current();
        Optional disableDefaults = config.getOptionalValue("mp.health.disable-default-procedures", Boolean.class);
        List builtInHealthChecks = disableDefaults.map(b -> b != false ? cdi.select(HealthCheck.class, new Annotation[]{BUILT_IN_HEALTH_CHECK_LITERAL}).stream().collect(Collectors.toList()) : Collections.emptyList()).orElse(Collections.emptyList());
        cdi.select(HealthCheck.class, new Annotation[]{HEALTH_LITERAL}).stream().filter(hc -> !builtInHealthChecks.contains(hc)).forEach(xva$0 -> builder.add(new HealthCheck[]{xva$0}));
        cdi.select(HealthCheck.class, new Annotation[]{Liveness.Literal.INSTANCE}).stream().filter(hc -> !builtInHealthChecks.contains(hc)).forEach(xva$0 -> builder.addLiveness(new HealthCheck[]{xva$0}));
        cdi.select(HealthCheck.class, new Annotation[]{Readiness.Literal.INSTANCE}).stream().filter(hc -> !builtInHealthChecks.contains(hc)).forEach(xva$0 -> builder.addReadiness(new HealthCheck[]{xva$0}));
        HelidonServiceLoader.create(ServiceLoader.load(HealthCheckProvider.class)).forEach(healthCheckProvider -> {
            healthCheckProvider.livenessChecks().forEach(xva$0 -> builder.addLiveness(new HealthCheck[]{xva$0}));
            healthCheckProvider.readinessChecks().forEach(xva$0 -> builder.addReadiness(new HealthCheck[]{xva$0}));
        });
        RoutingBuilders.create((Config)helidonConfig).routingBuilder().register(new Service[]{builder.build()});
    }
}

