/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.health;

import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.config.Config;
import io.helidon.health.HealthSupport;
import io.helidon.health.common.BuiltInHealthCheck;
import io.helidon.microprofile.health.HealthCheckProvider;
import io.helidon.microprofile.health.JvmRuntimeProducers;
import io.helidon.microprofile.server.ServerCdiExtension;
import io.helidon.servicecommon.restcdi.HelidonRestCdiExtension;
import io.helidon.webserver.Routing;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.ProcessManagedBean;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;
import org.eclipse.microprofile.health.Startup;

public class HealthCdiExtension
extends HelidonRestCdiExtension<HealthSupport> {
    private static final BuiltInHealthCheck BUILT_IN_HEALTH_CHECK_LITERAL = new BuiltInHealthCheck(){

        public Class<? extends Annotation> annotationType() {
            return BuiltInHealthCheck.class;
        }
    };
    private static final Logger LOGGER = Logger.getLogger(HealthCdiExtension.class.getName());
    private static final Function<Config, HealthSupport> HEALTH_SUPPORT_FACTORY = helidonConfig -> {
        org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
        HealthSupport.Builder builder = HealthSupport.builder().config(helidonConfig);
        CDI cdi = CDI.current();
        Optional disableDefaults = config.getOptionalValue("mp.health.disable-default-procedures", Boolean.class);
        List builtInHealthChecks = disableDefaults.map(b -> b != false ? cdi.select(HealthCheck.class, new Annotation[]{BUILT_IN_HEALTH_CHECK_LITERAL}).stream().collect(Collectors.toList()) : Collections.emptyList()).orElse(Collections.emptyList());
        cdi.select(HealthCheck.class, new Annotation[]{Liveness.Literal.INSTANCE}).stream().filter(hc -> !builtInHealthChecks.contains(hc)).forEach(xva$0 -> builder.addLiveness(new HealthCheck[]{xva$0}));
        cdi.select(HealthCheck.class, new Annotation[]{Readiness.Literal.INSTANCE}).stream().filter(hc -> !builtInHealthChecks.contains(hc)).forEach(xva$0 -> builder.addReadiness(new HealthCheck[]{xva$0}));
        cdi.select(HealthCheck.class, new Annotation[]{Startup.Literal.INSTANCE}).stream().filter(hc -> !builtInHealthChecks.contains(hc)).forEach(xva$0 -> builder.addStartup(new HealthCheck[]{xva$0}));
        HelidonServiceLoader.create(ServiceLoader.load(HealthCheckProvider.class)).forEach(healthCheckProvider -> {
            healthCheckProvider.livenessChecks().forEach(xva$0 -> builder.addLiveness(new HealthCheck[]{xva$0}));
            healthCheckProvider.readinessChecks().forEach(xva$0 -> builder.addReadiness(new HealthCheck[]{xva$0}));
            healthCheckProvider.startupChecks().forEach(xva$0 -> builder.addStartup(new HealthCheck[]{xva$0}));
        });
        return builder.build();
    };

    public HealthCdiExtension() {
        super(LOGGER, HEALTH_SUPPORT_FACTORY, "health");
    }

    void registerProducers(@Observes BeforeBeanDiscovery bbd) {
        bbd.addAnnotatedType(JvmRuntimeProducers.class, "health.JvmRuntimeProducers").add((Annotation)ApplicationScoped.Literal.INSTANCE);
    }

    public Routing.Builder registerService(@Observes @Priority(value=1010) @Initialized(value=ApplicationScoped.class) Object adv, BeanManager bm, ServerCdiExtension server) {
        Routing.Builder defaultRouting = super.registerService(adv, bm, server);
        org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
        if (!config.getOptionalValue("health.enabled", Boolean.class).orElse(true).booleanValue()) {
            LOGGER.finest("Health support is disabled in configuration");
        }
        return defaultRouting;
    }

    protected void processManagedBean(ProcessManagedBean<?> processManagedBean) {
    }
}

