/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.health;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.config.Config;
import io.helidon.health.HealthCheck;
import io.helidon.health.HealthCheckType;
import io.helidon.microprofile.health.BuiltInHealthCheck;
import io.helidon.microprofile.health.HealthCheckProvider;
import io.helidon.microprofile.health.MpCheckWrapper;
import io.helidon.microprofile.server.ServerCdiExtension;
import io.helidon.microprofile.servicecommon.HelidonRestCdiExtension;
import io.helidon.nima.observe.health.HealthFeature;
import io.helidon.nima.webserver.http.HttpRules;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.ProcessManagedBean;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;
import org.eclipse.microprofile.health.Startup;

public class HealthCdiExtension
extends HelidonRestCdiExtension<HealthFeature> {
    private static final BuiltInHealthCheck BUILT_IN_HEALTH_CHECK_LITERAL = new BuiltInHealthCheck(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return BuiltInHealthCheck.class;
        }
    };
    private static final System.Logger LOGGER = System.getLogger(HealthCdiExtension.class.getName());
    private static final Function<Config, HealthFeature> HEALTH_SUPPORT_FACTORY = helidonConfig -> {
        org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
        HealthFeature.Builder builder = HealthFeature.builder().details(true).config(helidonConfig);
        CDI cdi = CDI.current();
        Optional disableDefaults = config.getOptionalValue("mp.health.disable-default-procedures", Boolean.class);
        if (!disableDefaults.orElse(false).booleanValue()) {
            HelidonServiceLoader.create(ServiceLoader.load(io.helidon.health.spi.HealthCheckProvider.class)).asList().stream().flatMap(it -> it.healthChecks(helidonConfig).stream()).forEach(arg_0 -> ((HealthFeature.Builder)builder).addCheck(arg_0));
        }
        List builtInHealthChecks = disableDefaults.map(b -> b != false ? cdi.select(org.eclipse.microprofile.health.HealthCheck.class, new Annotation[]{BUILT_IN_HEALTH_CHECK_LITERAL}).stream().collect(Collectors.toList()) : Collections.emptyList()).orElse(Collections.emptyList());
        cdi.select(org.eclipse.microprofile.health.HealthCheck.class, new Annotation[]{Liveness.Literal.INSTANCE}).stream().filter(hc -> !builtInHealthChecks.contains(hc)).forEach(it -> builder.addCheck((HealthCheck)MpCheckWrapper.create(HealthCheckType.LIVENESS, it)));
        cdi.select(org.eclipse.microprofile.health.HealthCheck.class, new Annotation[]{Readiness.Literal.INSTANCE}).stream().filter(hc -> !builtInHealthChecks.contains(hc)).forEach(it -> builder.addCheck((HealthCheck)MpCheckWrapper.create(HealthCheckType.READINESS, it)));
        cdi.select(org.eclipse.microprofile.health.HealthCheck.class, new Annotation[]{Startup.Literal.INSTANCE}).stream().filter(hc -> !builtInHealthChecks.contains(hc)).forEach(it -> builder.addCheck((HealthCheck)MpCheckWrapper.create(HealthCheckType.STARTUP, it)));
        HelidonServiceLoader.create(ServiceLoader.load(HealthCheckProvider.class)).forEach(healthCheckProvider -> {
            healthCheckProvider.livenessChecks().forEach(it -> builder.addCheck((HealthCheck)MpCheckWrapper.create(HealthCheckType.LIVENESS, it)));
            healthCheckProvider.readinessChecks().forEach(it -> builder.addCheck((HealthCheck)MpCheckWrapper.create(HealthCheckType.READINESS, it)));
            healthCheckProvider.startupChecks().forEach(it -> builder.addCheck((HealthCheck)MpCheckWrapper.create(HealthCheckType.STARTUP, it)));
        });
        return builder.build();
    };

    public HealthCdiExtension() {
        super(LOGGER, HEALTH_SUPPORT_FACTORY, "health");
    }

    protected void processManagedBean(ProcessManagedBean<?> processManagedBean) {
    }

    public HttpRules registerService(@Observes @Priority(value=1010) @Initialized(value=ApplicationScoped.class) Object adv, BeanManager bm, ServerCdiExtension server) {
        HttpRules defaultRouting = super.registerService(adv, bm, server);
        org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
        if (!config.getOptionalValue("health.enabled", Boolean.class).orElse(true).booleanValue()) {
            LOGGER.log(System.Logger.Level.TRACE, "Health support is disabled in configuration");
        }
        return defaultRouting;
    }
}

