/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.microprofile.faulttolerance.JavaMethodFinder;
import io.helidon.microprofile.faulttolerance.MethodAntn;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import java.lang.reflect.Method;
import org.eclipse.microprofile.faulttolerance.ExecutionContext;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

class FallbackAntn
extends MethodAntn
implements Fallback {
    FallbackAntn(AnnotatedMethod<?> annotatedMethod) {
        super(annotatedMethod);
    }

    @Override
    public void validate() {
        String methodName = this.fallbackMethod();
        Class<FallbackHandler<?>> value = this.value();
        if (value != Fallback.DEFAULT.class && !methodName.isEmpty()) {
            throw new FaultToleranceDefinitionException("Fallback annotation cannot declare a handler and a fallback method");
        }
        Method method = this.method();
        if (!methodName.isEmpty()) {
            try {
                Method fallbackMethod = JavaMethodFinder.findMethod(method.getDeclaringClass(), methodName, method.getGenericParameterTypes());
                if (!method.getReturnType().isAssignableFrom(fallbackMethod.getReturnType())) {
                    throw new FaultToleranceDefinitionException("Fallback method " + fallbackMethod.getName() + " in class " + fallbackMethod.getDeclaringClass().getSimpleName() + " incompatible return type " + fallbackMethod.getReturnType() + " with " + method.getReturnType());
                }
            }
            catch (NoSuchMethodException e) {
                throw new FaultToleranceDefinitionException((Throwable)e);
            }
        }
        if (value != Fallback.DEFAULT.class) {
            try {
                Method handleMethod = value.getMethod("handle", ExecutionContext.class);
                if (!handleMethod.getReturnType().isAssignableFrom(method.getReturnType())) {
                    throw new FaultToleranceDefinitionException("Handler method return type is invalid: " + handleMethod.getReturnType());
                }
            }
            catch (NoSuchMethodException e) {
                throw new FaultToleranceDefinitionException((Throwable)e);
            }
        }
    }

    public Class<? extends FallbackHandler<?>> value() {
        MethodAntn.LookupResult<Fallback> lookupResult = this.lookupAnnotation(Fallback.class);
        String override = this.getParamOverride("value", lookupResult.getType());
        try {
            return override != null ? Class.forName(override) : lookupResult.getAnnotation().value();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String fallbackMethod() {
        MethodAntn.LookupResult<Fallback> lookupResult = this.lookupAnnotation(Fallback.class);
        String override = this.getParamOverride("fallbackMethod", lookupResult.getType());
        return override != null ? override : lookupResult.getAnnotation().fallbackMethod();
    }

    public Class<? extends Throwable>[] applyOn() {
        MethodAntn.LookupResult<Fallback> lookupResult = this.lookupAnnotation(Fallback.class);
        String override = this.getParamOverride("applyOn", lookupResult.getType());
        return override != null ? FallbackAntn.parseThrowableArray(override) : lookupResult.getAnnotation().applyOn();
    }

    public Class<? extends Throwable>[] skipOn() {
        MethodAntn.LookupResult<Fallback> lookupResult = this.lookupAnnotation(Fallback.class);
        String override = this.getParamOverride("skipOn", lookupResult.getType());
        return override != null ? FallbackAntn.parseThrowableArray(override) : lookupResult.getAnnotation().skipOn();
    }
}

