/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.microprofile.faulttolerance.BulkheadAntn;
import io.helidon.microprofile.faulttolerance.CircuitBreakerAntn;
import io.helidon.microprofile.faulttolerance.FallbackAntn;
import io.helidon.microprofile.faulttolerance.FaultToleranceExtension;
import io.helidon.microprofile.faulttolerance.FaultToleranceMetrics;
import io.helidon.microprofile.faulttolerance.FaultToleranceParameter;
import io.helidon.microprofile.faulttolerance.FtAnnotatedMethod;
import io.helidon.microprofile.faulttolerance.MethodAntn;
import io.helidon.microprofile.faulttolerance.RetryAntn;
import io.helidon.microprofile.faulttolerance.RetryExponentialBackoff;
import io.helidon.microprofile.faulttolerance.RetryFibonacciBackoff;
import io.helidon.microprofile.faulttolerance.TimeoutAntn;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Optional;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.eclipse.microprofile.metrics.Tag;

class MethodIntrospector {
    private final AnnotatedMethod<?> annotatedMethod;
    private final Retry retry;
    private final Fallback fallback;
    private final CircuitBreaker circuitBreaker;
    private final Timeout timeout;
    private final Bulkhead bulkhead;
    private final RetryExponentialBackoff retryExponentialBackoff;
    private final RetryFibonacciBackoff retryFibonacciBackoff;
    private Tag methodNameTag;

    MethodIntrospector(Class<?> beanClass, Method method) {
        BeanManager bm = CDI.current().getBeanManager();
        AnnotatedType annotatedType = bm.createAnnotatedType(beanClass);
        Optional<AnnotatedMethod> annotatedMethodOptional = annotatedType.getMethods().stream().filter(am -> am.getJavaMember().equals(method)).findFirst();
        this.annotatedMethod = annotatedMethodOptional.orElse(new FtAnnotatedMethod(method));
        this.retry = this.isAnnotationEnabled(Retry.class) ? new RetryAntn(this.annotatedMethod) : null;
        this.circuitBreaker = this.isAnnotationEnabled(CircuitBreaker.class) ? new CircuitBreakerAntn(this.annotatedMethod) : null;
        this.timeout = this.isAnnotationEnabled(Timeout.class) ? new TimeoutAntn(this.annotatedMethod) : null;
        this.bulkhead = this.isAnnotationEnabled(Bulkhead.class) ? new BulkheadAntn(this.annotatedMethod) : null;
        this.fallback = this.isAnnotationEnabled(Fallback.class) ? new FallbackAntn(this.annotatedMethod) : null;
        this.retryFibonacciBackoff = method.getAnnotation(RetryFibonacciBackoff.class);
        this.retryExponentialBackoff = method.getAnnotation(RetryExponentialBackoff.class);
    }

    boolean hasRetry() {
        return this.retry != null;
    }

    Retry getRetry() {
        return this.retry;
    }

    boolean hasFallback() {
        return this.fallback != null;
    }

    Fallback getFallback() {
        return this.fallback;
    }

    boolean isAsynchronous() {
        return this.isAnnotationEnabled(Asynchronous.class);
    }

    boolean hasCircuitBreaker() {
        return this.circuitBreaker != null;
    }

    CircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }

    boolean hasTimeout() {
        return this.timeout != null;
    }

    Timeout getTimeout() {
        return this.timeout;
    }

    boolean hasBulkhead() {
        return this.bulkhead != null;
    }

    Bulkhead getBulkhead() {
        return this.bulkhead;
    }

    boolean hasRetryExponentialBackoff() {
        return this.retryExponentialBackoff != null;
    }

    RetryExponentialBackoff getRetryExponentialBackoff() {
        return this.retryExponentialBackoff;
    }

    boolean hasRetryFibonacciBackoff() {
        return this.retryFibonacciBackoff != null;
    }

    RetryFibonacciBackoff getRetryFibonacciBackoff() {
        return this.retryFibonacciBackoff;
    }

    Tag getMethodNameTag() {
        if (this.methodNameTag == null) {
            Method method = this.annotatedMethod.getJavaMember();
            String name = method.getDeclaringClass().getName() + "." + method.getName();
            this.methodNameTag = new Tag("method", name);
        }
        return this.methodNameTag;
    }

    Tag getFallbackTag(boolean fallbackCalled) {
        return !this.hasFallback() ? FaultToleranceMetrics.InvocationFallback.NOT_DEFINED.get() : (fallbackCalled ? FaultToleranceMetrics.InvocationFallback.APPLIED.get() : FaultToleranceMetrics.InvocationFallback.NOT_APPLIED.get());
    }

    private boolean isAnnotationEnabled(Class<? extends Annotation> clazz) {
        BeanManager bm = CDI.current().getBeanManager();
        MethodAntn.LookupResult<? extends Annotation> lookupResult = MethodAntn.lookupAnnotation(this.annotatedMethod, clazz, bm);
        if (lookupResult == null) {
            return false;
        }
        String annotationType = clazz.getSimpleName();
        Method method = this.annotatedMethod.getJavaMember();
        String value = FaultToleranceParameter.getParameter(method.getDeclaringClass().getName(), method.getName(), annotationType, "enabled");
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        value = FaultToleranceParameter.getParameter(method.getDeclaringClass().getName(), annotationType, "enabled");
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        value = FaultToleranceParameter.getParameter(annotationType, "enabled");
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return clazz == Fallback.class || FaultToleranceExtension.isFaultToleranceEnabled();
    }
}

