/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.nima.faulttolerance.BulkheadException;
import io.helidon.nima.faulttolerance.RetryTimeoutException;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException;

class ThrowableMapper {
    private ThrowableMapper() {
    }

    static Throwable map(Throwable t) {
        if (t instanceof ExecutionException) {
            t = t.getCause();
        }
        if (t instanceof io.helidon.nima.faulttolerance.CircuitBreakerOpenException) {
            return new CircuitBreakerOpenException(t.getMessage(), t.getCause());
        }
        if (t instanceof BulkheadException) {
            return new org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException(t.getMessage(), t.getCause());
        }
        if (t instanceof RetryTimeoutException) {
            return t;
        }
        if (t instanceof io.helidon.nima.faulttolerance.TimeoutException || t instanceof InterruptedException) {
            return new TimeoutException(t.getMessage(), t.getCause());
        }
        return t;
    }

    static Class<? extends Throwable>[] mapTypes(Class<? extends Throwable>[] types) {
        if (types.length == 0) {
            return types;
        }
        Class<? extends Throwable>[] result = Arrays.copyOf(types, types.length);
        for (int i = 0; i < types.length; ++i) {
            Class<? extends Throwable> t = types[i];
            result[i] = t == org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException.class ? BulkheadException.class : (t == CircuitBreakerOpenException.class ? io.helidon.nima.faulttolerance.CircuitBreakerOpenException.class : (t == TimeoutException.class ? io.helidon.nima.faulttolerance.TimeoutException.class : t));
        }
        return result;
    }
}

