/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.jwt.auth;

import io.helidon.microprofile.jwt.auth.JsonWebTokenImpl;
import io.helidon.security.jwt.Jwt;
import io.helidon.security.jwt.JwtException;
import io.helidon.security.jwt.JwtUtil;
import io.helidon.security.jwt.SignedJwt;
import io.helidon.security.util.AbacSupport;
import jakarta.json.Json;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.jwt.Claims;

final class BackedJsonWebToken
extends JsonWebTokenImpl {
    private final Jwt jwt;
    private final SignedJwt signed;
    private final String id;
    private final AbacSupport properties;
    private final String name;

    BackedJsonWebToken(SignedJwt signed) {
        this.jwt = signed.getJwt();
        this.signed = signed;
        AbacSupport.BasicAttributes container = AbacSupport.BasicAttributes.create();
        this.jwt.payloadClaims().forEach((key, jsonValue) -> container.put(key, JwtUtil.toObject((JsonValue)jsonValue)));
        this.jwt.email().ifPresent(value -> container.put("email", value));
        this.jwt.emailVerified().ifPresent(value -> container.put("email_verified", value));
        this.jwt.locale().ifPresent(value -> container.put("locale", value));
        this.jwt.familyName().ifPresent(value -> container.put("family_name", value));
        this.jwt.givenName().ifPresent(value -> container.put("given_name", value));
        this.jwt.fullName().ifPresent(value -> container.put("full_name", value));
        this.properties = container;
        String subject = (String)this.jwt.subject().orElseThrow(() -> new JwtException("JWT does not contain subject claim, cannot create principal."));
        this.name = this.jwt.userPrincipal().or(() -> ((Jwt)this.jwt).preferredUsername()).orElse(subject);
        this.id = subject;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<String> getClaimNames() {
        return this.jwt.payloadClaims().keySet();
    }

    @Override
    public <T> T getClaim(String claimName) {
        try {
            return this.getClaim(Claims.valueOf((String)claimName));
        }
        catch (IllegalArgumentException e) {
            return this.getJsonValue(claimName).orElse(null);
        }
    }

    @Override
    public <T> T getClaim(String claimName, Class<T> clazz) {
        try {
            Claims claims = Claims.valueOf((String)claimName);
            return (T)(JsonValue.class.isAssignableFrom(clazz) ? this.getJsonValue(claimName).orElse(null) : this.getClaim(claims));
        }
        catch (IllegalArgumentException ignored) {
            return this.getJsonValue(claimName).map(val -> this.convertClass(clazz, (JsonValue)val)).orElse(null);
        }
    }

    public <T> T getClaim(Claims claims) {
        switch (claims) {
            case raw_token: {
                return (T)this.signed.tokenContent();
            }
            case groups: {
                return this.jwt.userGroups().map(HashSet::new).orElse(null);
            }
            case aud: {
                return this.jwt.audience().map(HashSet::new).orElse(null);
            }
            case email_verified: {
                return this.jwt.emailVerified().orElse(null);
            }
            case phone_number_verified: {
                return this.jwt.phoneNumberVerified().orElse(null);
            }
            case upn: {
                return this.jwt.userPrincipal().orElse(null);
            }
        }
        String claimName = claims.name();
        Optional<JsonValue> json = this.getJsonValue(claimName);
        return json.map(value -> this.convert(claims, (JsonValue)value)).orElse(null);
    }

    private Optional<JsonValue> getJsonValue(String claimName) {
        if (Claims.raw_token.name().equals(claimName)) {
            return Optional.of(Json.createValue((String)this.signed.tokenContent()));
        }
        return this.jwt.payloadClaim(claimName).or(() -> this.jwt.headerClaim(claimName));
    }

    private Object convert(Claims claims, JsonValue value) {
        Class claimClass = claims.getType();
        return this.convertClass(claimClass, value);
    }

    private Object convertClass(Class<?> claimClass, JsonValue value) {
        if (claimClass.equals(String.class) && value instanceof JsonString) {
            return ((JsonString)value).getString();
        }
        if (claimClass.equals(Long.class)) {
            if (value instanceof JsonNumber) {
                return ((JsonNumber)value).longValue();
            }
            if (value instanceof JsonString) {
                return Long.parseLong(((JsonString)value).getString());
            }
            return Long.parseLong(value.toString());
        }
        if (claimClass.equals(JsonObject.class)) {
            return value;
        }
        if (Boolean.TYPE.equals(claimClass) || Boolean.class.equals(claimClass)) {
            if (JsonValue.TRUE.equals(value)) {
                return true;
            }
            if (JsonValue.FALSE.equals(value)) {
                return false;
            }
        }
        return value;
    }

    @Override
    public Object abacAttributeRaw(String key) {
        return this.properties.abacAttributeRaw(key);
    }

    @Override
    public Collection<String> abacAttributeNames() {
        return this.properties.abacAttributeNames();
    }

    @Override
    public String id() {
        return this.id;
    }
}

