/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.jwt.auth;

import io.helidon.config.Config;
import io.helidon.security.providers.common.spi.AnnotationAnalyzer;
import jakarta.annotation.Priority;
import jakarta.annotation.security.RolesAllowed;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.eclipse.microprofile.auth.LoginConfig;

@Priority(value=4900)
public class JwtAuthAnnotationAnalyzer
implements AnnotationAnalyzer {
    static final String LOGIN_CONFIG_METHOD = "MP-JWT";
    private String authenticator = "mp-jwt-auth";
    private boolean secureByDefault;

    static boolean isMpJwt(LoginConfig config) {
        return LOGIN_CONFIG_METHOD.equals(config.authMethod());
    }

    public void init(Config config) {
        config.get("mp-jwt-auth.auth-method-mapping").asNodeList().ifPresent(nl -> nl.forEach(conf -> conf.get("key").asString().ifPresent(key -> {
            if (LOGIN_CONFIG_METHOD.equals(key)) {
                this.authenticator = (String)conf.get("provider").asString().orElse((Object)this.authenticator);
            }
        })));
        this.secureByDefault = (Boolean)config.get("jwt.secure-by-default").asBoolean().orElse((Object)true);
    }

    public AnnotationAnalyzer.AnalyzerResponse analyze(Class<?> maybeAnnotated) {
        AnnotationAnalyzer.AnalyzerResponse.Builder builder = AnnotationAnalyzer.AnalyzerResponse.builder();
        LoginConfig annotation = maybeAnnotated.getAnnotation(LoginConfig.class);
        if (null == annotation) {
            builder.register((Object)new RegisterMpJwt(false));
            return AnnotationAnalyzer.AnalyzerResponse.abstain();
        }
        if (JwtAuthAnnotationAnalyzer.isMpJwt(annotation)) {
            AnnotationAnalyzer.Flag atnFlag;
            builder.register((Object)new RegisterMpJwt(true));
            AnnotationAnalyzer.Flag flag = atnFlag = this.secureByDefault ? AnnotationAnalyzer.Flag.REQUIRED : AnnotationAnalyzer.Flag.OPTIONAL;
            if (this.isRolesAllowed(maybeAnnotated)) {
                atnFlag = AnnotationAnalyzer.Flag.REQUIRED;
            }
            return builder.authenticationResponse(atnFlag).authenticator(this.authenticator).build();
        }
        builder.register((Object)new RegisterMpJwt(false));
        return builder.build();
    }

    public AnnotationAnalyzer.AnalyzerResponse analyze(Class<?> maybeAnnotated, AnnotationAnalyzer.AnalyzerResponse previousResponse) {
        return AnnotationAnalyzer.AnalyzerResponse.builder((AnnotationAnalyzer.AnalyzerResponse)previousResponse).build();
    }

    public AnnotationAnalyzer.AnalyzerResponse analyze(Method maybeAnnotated, AnnotationAnalyzer.AnalyzerResponse previousResponse) {
        if (this.isRolesAllowed(maybeAnnotated)) {
            return AnnotationAnalyzer.AnalyzerResponse.builder((AnnotationAnalyzer.AnalyzerResponse)previousResponse).authenticationResponse(AnnotationAnalyzer.Flag.REQUIRED).build();
        }
        return AnnotationAnalyzer.AnalyzerResponse.builder((AnnotationAnalyzer.AnalyzerResponse)previousResponse).build();
    }

    private boolean isRolesAllowed(AnnotatedElement maybeAnnotated) {
        RolesAllowed ra = maybeAnnotated.getAnnotation(RolesAllowed.class);
        return null != ra;
    }

    private static final class RegisterMpJwt {
        private final boolean isMpJwt;

        private RegisterMpJwt(boolean isMpJwt) {
            this.isMpJwt = isMpJwt;
        }

        public boolean isMpJwt() {
            return this.isMpJwt;
        }
    }
}

