/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.jwt.auth;

import io.helidon.microprofile.jwt.auth.ClaimValueWrapper;
import io.helidon.microprofile.jwt.auth.Impl;
import io.helidon.microprofile.jwt.auth.JsonWebTokenImpl;
import io.helidon.microprofile.jwt.auth.JwtAuthCdiExtension;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.Claims;

class ClaimProducer
implements Bean<Object> {
    private static final Annotation QUALIFIER = new Claim(){

        public String value() {
            return "";
        }

        public Claims standard() {
            return Claims.UNKNOWN;
        }

        public Class<? extends Annotation> annotationType() {
            return Claim.class;
        }
    };
    private final JwtAuthCdiExtension.MpClaimQualifier qualifier;
    private final Type type;
    private final Class<? extends Annotation> scope;

    ClaimProducer(JwtAuthCdiExtension.MpClaimQualifier q, Type type, Class<? extends Annotation> scope) {
        ParameterizedType paramType;
        this.qualifier = q;
        this.scope = scope;
        Type actualType = type;
        if (type instanceof ParameterizedType && (Provider.class.equals((Object)(paramType = (ParameterizedType)type).getRawType()) || Instance.class.equals((Object)paramType.getRawType()))) {
            actualType = paramType.getActualTypeArguments()[0];
        }
        this.type = actualType;
    }

    static Object getClaimValue(String claimName, JsonWebTokenImpl webToken, JwtAuthCdiExtension.MpClaimQualifier q) {
        return ClaimProducer.getParametrizedClaimValue(claimName, webToken, q);
    }

    static Object getParametrizedClaimValue(String claimName, JsonWebTokenImpl webToken, JwtAuthCdiExtension.MpClaimQualifier claimLiteral) {
        if (null == webToken) {
            return null;
        }
        Object result = claimLiteral.claimValue() ? (claimLiteral.optional() ? webToken.getClaim(claimName, claimLiteral.typeArg2()) : webToken.getClaim(claimName, claimLiteral.typeArg())) : (claimLiteral.optional() ? webToken.getClaim(claimName, claimLiteral.typeArg()) : webToken.getClaim(claimName, claimLiteral.rawType()));
        if (claimLiteral.optional()) {
            result = Optional.ofNullable(result);
        }
        if (claimLiteral.claimValue()) {
            result = new ClaimValueWrapper(claimName, result);
        }
        return result;
    }

    public Object create(CreationalContext<Object> context) {
        return this.getClaimValue(context);
    }

    private Object getClaimValue(CreationalContext<Object> context) {
        JsonWebTokenImpl token = (JsonWebTokenImpl)CDI.current().select(JsonWebTokenImpl.class, new Annotation[]{new Impl(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return Impl.class;
            }
        }}).get();
        return ClaimProducer.getClaimValue(this.qualifier.name(), token, this.qualifier);
    }

    public Class<?> getBeanClass() {
        return ClaimProducer.class;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Set.of();
    }

    public boolean isNullable() {
        return false;
    }

    public void destroy(Object instance, CreationalContext<Object> creationalContext) {
    }

    public Set<Type> getTypes() {
        return Set.of(this.type);
    }

    public Set<Annotation> getQualifiers() {
        return Set.of(this.qualifier, QUALIFIER);
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public String getName() {
        return this.qualifier.id();
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Set.of();
    }

    public boolean isAlternative() {
        return false;
    }

    public String toString() {
        return "ClaimProducer{qualifier=" + this.qualifier + "}";
    }
}

