/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.jwt.auth;

import io.helidon.common.Errors;
import io.helidon.common.LazyValue;
import io.helidon.common.configurable.Resource;
import io.helidon.common.pki.Keys;
import io.helidon.http.HeaderNames;
import io.helidon.microprofile.jwt.auth.JsonWebTokenImpl;
import io.helidon.microprofile.jwt.auth.JwtAuthAnnotationAnalyzer;
import io.helidon.security.AuthenticationResponse;
import io.helidon.security.EndpointConfig;
import io.helidon.security.Grant;
import io.helidon.security.OutboundSecurityResponse;
import io.helidon.security.Principal;
import io.helidon.security.ProviderRequest;
import io.helidon.security.Role;
import io.helidon.security.Security;
import io.helidon.security.SecurityEnvironment;
import io.helidon.security.SecurityException;
import io.helidon.security.SecurityLevel;
import io.helidon.security.SecurityResponse;
import io.helidon.security.Subject;
import io.helidon.security.SubjectType;
import io.helidon.security.jwt.EncryptedJwt;
import io.helidon.security.jwt.Jwt;
import io.helidon.security.jwt.JwtException;
import io.helidon.security.jwt.JwtHeaders;
import io.helidon.security.jwt.SignedJwt;
import io.helidon.security.jwt.jwk.Jwk;
import io.helidon.security.jwt.jwk.JwkEC;
import io.helidon.security.jwt.jwk.JwkKeys;
import io.helidon.security.jwt.jwk.JwkRSA;
import io.helidon.security.providers.common.OutboundConfig;
import io.helidon.security.providers.common.OutboundTarget;
import io.helidon.security.providers.common.TokenCredential;
import io.helidon.security.spi.AuthenticationProvider;
import io.helidon.security.spi.OutboundSecurityProvider;
import io.helidon.security.util.TokenHandler;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReaderFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.microprofile.auth.LoginConfig;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.jwt.JsonWebToken;

public class JwtAuthProvider
implements AuthenticationProvider,
OutboundSecurityProvider {
    public static final String CONFIG_EXPECTED_ISSUER = "mp.jwt.verify.issuer";
    public static final String CONFIG_EXPECTED_AUDIENCES = "mp.jwt.verify.audiences";
    private static final String CONFIG_EXPECTED_MAX_TOKEN_AGE = "mp.jwt.verify.token.age";
    private static final String CONFIG_CLOCK_SKEW = "mp.jwt.verify.clock.skew";
    private static final String CONFIG_COOKIE_PROPERTY_NAME = "mp.jwt.token.cookie";
    private static final String CONFIG_JWT_HEADER = "mp.jwt.token.header";
    private static final System.Logger LOGGER = System.getLogger(JwtAuthProvider.class.getName());
    private static final JsonReaderFactory JSON = Json.createReaderFactory(Collections.emptyMap());
    private final boolean optional;
    private final boolean authenticate;
    private final boolean propagate;
    private final boolean allowImpersonation;
    private final SubjectType subjectType;
    private final TokenHandler atnTokenHandler;
    private final TokenHandler defaultTokenHandler;
    private final LazyValue<JwkKeys> verifyKeys;
    private final Set<String> expectedAudiences;
    private final JwkKeys signKeys;
    private final LazyValue<JwkKeys> decryptionKeys;
    private final OutboundConfig outboundConfig;
    private final String issuer;
    private final LazyValue<Jwk> defaultJwk;
    private final LazyValue<Jwk> defaultDecryptionJwk;
    private final Map<OutboundTarget, JwtOutboundTarget> targetToJwtConfig = new IdentityHashMap<OutboundTarget, JwtOutboundTarget>();
    private final String expectedIssuer;
    private final String cookiePrefix;
    private final String decryptionKeyAlgorithm;
    private final boolean useCookie;
    private final Duration expectedMaxTokenAge;
    private final Duration clockSkew;

    private JwtAuthProvider(Builder builder) {
        this.optional = builder.optional;
        this.authenticate = builder.authenticate;
        this.propagate = builder.propagate && builder.outboundConfig.targets().size() > 0;
        this.allowImpersonation = builder.allowImpersonation;
        this.subjectType = builder.subjectType;
        this.atnTokenHandler = builder.atnTokenHandler;
        this.outboundConfig = builder.outboundConfig;
        this.verifyKeys = builder.verifyKeys;
        this.signKeys = builder.signKeys;
        this.issuer = builder.issuer;
        this.expectedAudiences = builder.expectedAudiences;
        this.defaultJwk = builder.defaultJwk;
        this.expectedIssuer = builder.expectedIssuer;
        this.cookiePrefix = builder.cookieProperty + "=";
        this.useCookie = builder.useCookie;
        this.decryptionKeys = builder.decryptionKeys;
        this.defaultDecryptionJwk = builder.defaultDecryptionJwk;
        this.decryptionKeyAlgorithm = builder.decryptionKeyAlgorithm;
        this.expectedMaxTokenAge = builder.expectedMaxTokenAge;
        this.clockSkew = builder.clockSkew;
        this.defaultTokenHandler = null == this.atnTokenHandler ? TokenHandler.builder().tokenHeader("Authorization").tokenPrefix("bearer ").build() : this.atnTokenHandler;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static JwtAuthProvider create(io.helidon.common.config.Config config) {
        return JwtAuthProvider.builder().config(config).build();
    }

    public Collection<Class<? extends Annotation>> supportedAnnotations() {
        return Set.of(LoginConfig.class);
    }

    public AuthenticationResponse authenticate(ProviderRequest providerRequest) {
        if (!this.authenticate) {
            return AuthenticationResponse.abstain();
        }
        List loginConfigs = ((SecurityLevel)providerRequest.endpointConfig().securityLevels().get(0)).filterAnnotations(LoginConfig.class, EndpointConfig.AnnotationScope.CLASS);
        try {
            return loginConfigs.stream().filter(JwtAuthAnnotationAnalyzer::isMpJwt).findFirst().map(loginConfig -> this.authenticate(providerRequest, (LoginConfig)loginConfig)).orElseGet(AuthenticationResponse::abstain);
        }
        catch (java.lang.SecurityException e) {
            return AuthenticationResponse.failed((String)"Failed to process authentication header", (Throwable)e);
        }
    }

    AuthenticationResponse authenticate(ProviderRequest providerRequest, LoginConfig loginConfig) {
        Optional maybeToken;
        try {
            Map headers = providerRequest.env().headers();
            maybeToken = this.useCookie ? this.findCookie(headers) : this.atnTokenHandler.extractToken(headers);
        }
        catch (Exception e) {
            if (this.optional) {
                return AuthenticationResponse.abstain();
            }
            return AuthenticationResponse.failed((String)"Header not available or in a wrong format", (Throwable)e);
        }
        return maybeToken.map(token -> {
            Errors validate;
            SignedJwt signedJwt;
            try {
                JwtHeaders headers = JwtHeaders.parseToken((String)token);
                if (headers.encryption().isPresent() || this.decryptionKeys.get() != null) {
                    EncryptedJwt encryptedJwt = EncryptedJwt.parseToken((JwtHeaders)headers, (String)token);
                    if (!headers.contentType().map("JWT"::equals).orElse(false).booleanValue()) {
                        throw new JwtException("Header \"cty\" (content type) must be set to \"JWT\" for encrypted tokens");
                    }
                    LinkedList validators = new LinkedList();
                    EncryptedJwt.addKekValidator(validators, (String)this.decryptionKeyAlgorithm, (boolean)true);
                    Errors errors = encryptedJwt.validate(validators);
                    if (!errors.isValid()) return AuthenticationResponse.failed((String)errors.toString());
                    signedJwt = encryptedJwt.decrypt((JwkKeys)this.decryptionKeys.get(), (Jwk)this.defaultDecryptionJwk.get());
                } else {
                    signedJwt = SignedJwt.parseToken((String)token);
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(System.Logger.Level.TRACE)) return AuthenticationResponse.failed((String)"Invalid token", (Throwable)e);
                LOGGER.log(System.Logger.Level.TRACE, "Failed to parse token String into JWT", (Throwable)e);
                return AuthenticationResponse.failed((String)"Invalid token", (Throwable)e);
            }
            Errors errors = signedJwt.verifySignature((JwkKeys)this.verifyKeys.get(), (Jwk)this.defaultJwk.get());
            if (!errors.isValid()) return AuthenticationResponse.failed((String)errors.toString());
            Jwt jwt = signedJwt.getJwt();
            LinkedList<Jwt.ExpirationValidator> validators = new LinkedList<Jwt.ExpirationValidator>();
            if (this.expectedIssuer != null) {
                Jwt.addIssuerValidator(validators, (String)this.expectedIssuer, (boolean)true);
            }
            if (this.expectedAudiences.size() > 0) {
                Jwt.addAudienceValidator(validators, this.expectedAudiences, (boolean)true);
            }
            Jwt.addUserPrincipalValidator(validators);
            validators.add(Jwt.ExpirationValidator.create((Instant)Instant.now(), (int)((int)this.clockSkew.getSeconds()), (TemporalUnit)ChronoUnit.SECONDS, (boolean)true));
            if (this.expectedMaxTokenAge != null) {
                Jwt.addMaxTokenAgeValidator(validators, (Duration)this.expectedMaxTokenAge, (Duration)this.clockSkew, (boolean)true);
            }
            if (!(validate = jwt.validate(validators)).isValid()) return AuthenticationResponse.failed((String)errors.toString());
            return AuthenticationResponse.success((Subject)this.buildSubject(jwt, signedJwt));
        }).orElseGet(AuthenticationResponse::abstain);
    }

    private Optional<String> findCookie(Map<String, List<String>> headers) {
        List<String> cookies = headers.get(HeaderNames.COOKIE.defaultCase());
        if (null == cookies || cookies.isEmpty()) {
            return Optional.empty();
        }
        for (String cookie : cookies) {
            String[] cookieValues;
            for (String cookieValue : cookieValues = cookie.split(";\\s?")) {
                String trimmed = cookieValue.trim();
                if (!trimmed.startsWith(this.cookiePrefix)) continue;
                return Optional.of(trimmed.substring(this.cookiePrefix.length()));
            }
        }
        return Optional.empty();
    }

    Subject buildSubject(Jwt jwt, SignedJwt signedJwt) {
        JsonWebTokenImpl principal = JwtAuthProvider.buildPrincipal(signedJwt);
        TokenCredential.Builder builder = TokenCredential.builder();
        jwt.issueTime().ifPresent(arg_0 -> ((TokenCredential.Builder)builder).issueTime(arg_0));
        jwt.expirationTime().ifPresent(arg_0 -> ((TokenCredential.Builder)builder).expTime(arg_0));
        jwt.issuer().ifPresent(arg_0 -> ((TokenCredential.Builder)builder).issuer(arg_0));
        builder.token(signedJwt.tokenContent());
        builder.addToken(JsonWebToken.class, (Object)principal);
        builder.addToken(Jwt.class, (Object)jwt);
        builder.addToken(SignedJwt.class, (Object)signedJwt);
        Subject.Builder subjectBuilder = Subject.builder().principal((Principal)principal).addPublicCredential(TokenCredential.class, (Object)builder.build());
        Optional userGroups = jwt.userGroups();
        userGroups.ifPresent(groups -> groups.forEach(group -> subjectBuilder.addGrant((Grant)Role.create((String)group))));
        Optional scopes = jwt.scopes();
        scopes.ifPresent(scopeList -> scopeList.forEach(scope -> subjectBuilder.addGrant(Grant.builder().name(scope).type("scope").build())));
        return subjectBuilder.build();
    }

    static JsonWebTokenImpl buildPrincipal(SignedJwt signedJwt) {
        return JsonWebTokenImpl.create(signedJwt);
    }

    public boolean isOutboundSupported(ProviderRequest providerRequest, SecurityEnvironment outboundEnv, EndpointConfig outboundConfig) {
        return this.propagate && this.outboundConfig.findTarget(outboundEnv).isPresent();
    }

    public OutboundSecurityResponse outboundSecurity(ProviderRequest providerRequest, SecurityEnvironment outboundEnv, EndpointConfig outboundEndpointConfig) {
        Optional maybeUsername = outboundEndpointConfig.abacAttribute("io.helidon.security.outbound.identity");
        return maybeUsername.map(String::valueOf).flatMap(username -> {
            if (!this.allowImpersonation) {
                return Optional.of(((OutboundSecurityResponse.Builder)((OutboundSecurityResponse.Builder)OutboundSecurityResponse.builder().description("Attempting to impersonate a user, when impersonation is not allowed for JWT provider")).status(SecurityResponse.SecurityStatus.FAILURE)).build());
            }
            Optional maybeTarget = this.outboundConfig.findTarget(outboundEnv);
            return maybeTarget.flatMap(target -> {
                JwtOutboundTarget jwtOutboundTarget = this.targetToJwtConfig.computeIfAbsent((OutboundTarget)target, this::toOutboundTarget);
                if (null == jwtOutboundTarget.jwkKid) {
                    return Optional.of(((OutboundSecurityResponse.Builder)((OutboundSecurityResponse.Builder)OutboundSecurityResponse.builder().description("Cannot do explicit user propagation if no kid is defined.")).status(SecurityResponse.SecurityStatus.FAILURE)).build());
                }
                return Optional.of(this.impersonate(jwtOutboundTarget, (String)username));
            });
        }).orElseGet(() -> {
            Optional maybeSubject = this.subjectType == SubjectType.USER ? providerRequest.securityContext().user() : providerRequest.securityContext().service();
            return maybeSubject.flatMap(subject -> {
                Optional maybeTarget = this.outboundConfig.findTarget(outboundEnv);
                return maybeTarget.flatMap(target -> {
                    JwtOutboundTarget jwtOutboundTarget = this.targetToJwtConfig.computeIfAbsent((OutboundTarget)target, this::toOutboundTarget);
                    if (null == jwtOutboundTarget.jwkKid) {
                        return subject.publicCredential(TokenCredential.class).map(tokenCredential -> this.propagate(jwtOutboundTarget, tokenCredential.token()));
                    }
                    return Optional.of(this.propagate(jwtOutboundTarget, (Subject)subject));
                });
            }).orElseGet(OutboundSecurityResponse::abstain);
        });
    }

    private OutboundSecurityResponse propagate(JwtOutboundTarget outboundTarget, String token) {
        HashMap headers = new HashMap();
        outboundTarget.outboundHandler.header(headers, token);
        return OutboundSecurityResponse.withHeaders(headers);
    }

    private OutboundSecurityResponse propagate(JwtOutboundTarget ot, Subject subject) {
        HashMap headers = new HashMap();
        Jwk jwk = (Jwk)this.signKeys.forKeyId(ot.jwkKid).orElseThrow(() -> new JwtException("Signing JWK with kid: " + ot.jwkKid + " is not defined."));
        Principal principal = subject.principal();
        Jwt.Builder builder = Jwt.builder();
        principal.abacAttributeNames().forEach(name -> principal.abacAttribute(name).ifPresent(val -> builder.addPayloadClaim(name, val)));
        principal.abacAttribute("full_name").ifPresentOrElse(name -> builder.addPayloadClaim("name", name), () -> builder.removePayloadClaim("name"));
        builder.subject(principal.id()).preferredUsername(principal.getName()).issuer(this.issuer).algorithm(jwk.algorithm());
        ot.update(builder);
        if (!principal.abacAttribute("upn").isPresent()) {
            builder.userPrincipal(principal.getName());
        }
        Security.getRoles((Subject)subject).forEach(arg_0 -> ((Jwt.Builder)builder).addUserGroup(arg_0));
        Jwt jwt = builder.build();
        SignedJwt signed = SignedJwt.sign((Jwt)jwt, (Jwk)jwk);
        ot.outboundHandler.header(headers, signed.tokenContent());
        return OutboundSecurityResponse.withHeaders(headers);
    }

    private OutboundSecurityResponse impersonate(JwtOutboundTarget ot, String username) {
        HashMap headers = new HashMap();
        Jwk jwk = (Jwk)this.signKeys.forKeyId(ot.jwkKid).orElseThrow(() -> new JwtException("Signing JWK with kid: " + ot.jwkKid + " is not defined."));
        Jwt.Builder builder = Jwt.builder();
        builder.addPayloadClaim("name", (Object)username);
        builder.subject(username).preferredUsername(username).issuer(this.issuer).algorithm(jwk.algorithm());
        ot.update(builder);
        Jwt jwt = builder.build();
        SignedJwt signed = SignedJwt.sign((Jwt)jwt, (Jwk)jwk);
        ot.outboundHandler.header(headers, signed.tokenContent());
        return OutboundSecurityResponse.withHeaders(headers);
    }

    private JwtOutboundTarget toOutboundTarget(OutboundTarget outboundTarget) {
        Optional customObject = outboundTarget.customObject(JwtOutboundTarget.class);
        if (customObject.isPresent()) {
            return (JwtOutboundTarget)customObject.get();
        }
        return JwtOutboundTarget.fromConfig(outboundTarget.getConfig().orElse(io.helidon.common.config.Config.empty()), this.defaultTokenHandler);
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, JwtAuthProvider> {
        private static final String CONFIG_PUBLIC_KEY = "mp.jwt.verify.publickey";
        private static final String CONFIG_PUBLIC_KEY_PATH = "mp.jwt.verify.publickey.location";
        private static final String CONFIG_JWT_DECRYPT_KEY_LOCATION = "mp.jwt.decrypt.key.location";
        private static final String CONFIG_JWT_DECRYPT_KEY_ALGORITHM = "mp.jwt.decrypt.key.algorithm";
        private static final String JSON_START_MARK = "{";
        private static final Pattern PUBLIC_KEY_PATTERN = Pattern.compile("-+BEGIN\\s+.*PUBLIC\\s+KEY[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n\\s]+)-+END\\s+.*PUBLIC\\s+KEY[^-]*-+", 2);
        private static final Pattern PRIVATE_KEY_PATTERN = Pattern.compile("-+BEGIN\\s+.*PRIVATE\\s+KEY[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n\\s]+)-+END\\s+.*PRIVATE\\s+KEY[^-]*-+", 2);
        private final Set<String> expectedAudiences = new HashSet<String>();
        private String expectedIssuer;
        private boolean optional = false;
        private boolean authenticate = true;
        private boolean propagate = true;
        private boolean allowImpersonation = false;
        private SubjectType subjectType = SubjectType.USER;
        private TokenHandler atnTokenHandler = TokenHandler.builder().tokenHeader("Authorization").tokenPrefix("bearer ").build();
        private OutboundConfig outboundConfig = OutboundConfig.builder().build();
        private LazyValue<JwkKeys> verifyKeys;
        private LazyValue<JwkKeys> decryptionKeys;
        private LazyValue<Jwk> defaultJwk;
        private LazyValue<Jwk> defaultDecryptionJwk;
        private JwkKeys signKeys;
        private String defaultKeyId;
        private String issuer;
        private String publicKeyPath;
        private String publicKey;
        private String cookieProperty = "Bearer";
        private String decryptKeyLocation;
        private String decryptionKeyAlgorithm;
        private boolean useCookie = false;
        private boolean loadOnStartup = false;
        private Duration expectedMaxTokenAge = null;
        private Duration clockSkew = Duration.ofSeconds(5L);

        private Builder() {
        }

        public JwtAuthProvider build() {
            if (this.verifyKeys == null) {
                if (this.publicKeyPath != null && this.publicKey != null) {
                    throw new DeploymentException("Both mp.jwt.verify.publickey and mp.jwt.verify.publickey.location are set! Only one of them should be picked.");
                }
                String publicKeyPath = this.publicKeyPath;
                String publicKey = this.publicKey;
                LazyValue<Jwk> defaultJwk = this.defaultJwk;
                this.verifyKeys = LazyValue.create(() -> this.createJwkKeys(publicKeyPath, publicKey, defaultJwk));
            }
            LazyValue<JwkKeys> verifyKeys = this.verifyKeys;
            if (null == this.defaultJwk && null != this.defaultKeyId) {
                String defaultKeyId = this.defaultKeyId;
                Supplier<Jwk> jwkSupplier = () -> (Jwk)((JwkKeys)verifyKeys.get()).forKeyId(defaultKeyId).orElseThrow(() -> new DeploymentException("Default key id defined as \"" + defaultKeyId + "\" yet the key id is not present in the JWK keys"));
                this.defaultJwk = LazyValue.create(jwkSupplier);
            }
            if (null == this.defaultJwk) {
                Supplier<Jwk> jwkSupplier = () -> {
                    List keys = ((JwkKeys)verifyKeys.get()).keys();
                    if (!keys.isEmpty()) {
                        return (Jwk)keys.get(0);
                    }
                    return null;
                };
                this.defaultJwk = LazyValue.create(jwkSupplier);
            }
            if (this.decryptKeyLocation != null) {
                String decryptKeyLocation = this.decryptKeyLocation;
                this.decryptionKeys = LazyValue.create(() -> this.createDecryptionJwkKeys(decryptKeyLocation));
                LazyValue<JwkKeys> decryptionKeys = this.decryptionKeys;
                this.defaultDecryptionJwk = LazyValue.create(() -> {
                    List keys = ((JwkKeys)decryptionKeys.get()).keys();
                    if (!keys.isEmpty() && ((Jwk)keys.get(0)).keyId() == null) {
                        return (Jwk)keys.get(0);
                    }
                    return null;
                });
            } else {
                this.decryptionKeys = LazyValue.create(() -> null);
                this.defaultDecryptionJwk = LazyValue.create(() -> null);
            }
            if (this.loadOnStartup) {
                this.defaultJwk.get();
                this.defaultDecryptionJwk.get();
            }
            return new JwtAuthProvider(this);
        }

        private JwkKeys createDecryptionJwkKeys(String decryptKeyLocation) {
            return Optional.of(decryptKeyLocation).map(this::loadDecryptionJwkKeysFromLocation).get();
        }

        private JwkKeys loadDecryptionJwkKeysFromLocation(String uri) {
            return this.locatePath(uri).map(path -> {
                try {
                    return this.loadPrivateJwkKeys("file " + String.valueOf(path), Files.readString(path, StandardCharsets.UTF_8));
                }
                catch (IOException e) {
                    throw new SecurityException("Failed to load private key(s) from path: " + String.valueOf(path.toAbsolutePath()), (Throwable)e);
                }
            }).orElseGet(() -> {
                JwkKeys jwkKeys;
                block9: {
                    InputStream is = this.locateStream(uri);
                    try {
                        if (null == is) {
                            throw new SecurityException("Could not find private key resource for MP JWT-Auth at: " + uri);
                        }
                        jwkKeys = this.getPrivateKeyFromContent(uri, is);
                        if (is == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new SecurityException("Failed to load private key(s) from : " + uri, (Throwable)e);
                        }
                    }
                    is.close();
                }
                return jwkKeys;
            });
        }

        private JwkKeys getPrivateKeyFromContent(String location, InputStream bufferedInputStream) throws IOException {
            return this.loadPrivateJwkKeys(location, new String(bufferedInputStream.readAllBytes(), StandardCharsets.UTF_8));
        }

        private JwkKeys loadPrivateJwkKeys(String location, String stringContent) {
            if (stringContent.isEmpty()) {
                throw new SecurityException("Cannot load public key from " + location + ", as its content is empty");
            }
            Matcher m = PRIVATE_KEY_PATTERN.matcher(stringContent);
            if (m.find()) {
                return this.loadPlainPrivateKey(stringContent);
            }
            if (stringContent.startsWith(JSON_START_MARK)) {
                return this.loadPrivateKeyJWK(stringContent);
            }
            return this.loadPrivateKeyJWKBase64(stringContent);
        }

        private JwkKeys loadPlainPrivateKey(String stringContent) {
            PrivateKey privateKey = (PrivateKey)((Keys.Builder)Keys.builder().pem(pem -> pem.key(Resource.create((String)"private key from PKCS8", (String)stringContent)))).build().privateKey().orElseThrow(() -> new DeploymentException("Failed to load private key from string content"));
            String algorithm = privateKey.getAlgorithm();
            Object jwk = "EC".equals(algorithm) ? JwkEC.builder().privateKey((ECPrivateKey)privateKey).build() : JwkRSA.builder().privateKey((RSAPrivateKey)privateKey).build();
            return JwkKeys.builder().addKey((Jwk)jwk).build();
        }

        private JwkKeys loadPrivateKeyJWKBase64(String base64Encoded) {
            return this.loadPrivateKeyJWK(new String(Base64.getUrlDecoder().decode(base64Encoded), StandardCharsets.UTF_8));
        }

        private JwkKeys loadPrivateKeyJWK(String jwkJson) {
            if (jwkJson.contains("keys")) {
                return JwkKeys.builder().resource(Resource.create((String)"public key from PKCS8", (String)jwkJson)).build();
            }
            JsonObject jsonObject = JSON.createReader((Reader)new StringReader(jwkJson)).readObject();
            return JwkKeys.builder().addKey(Jwk.create((JsonObject)jsonObject)).build();
        }

        private JwkKeys createJwkKeys(String publicKeyPath, String publicKey, LazyValue<Jwk> defaultJwk) {
            if (null == publicKeyPath && null == publicKey && null == defaultJwk) {
                LOGGER.log(System.Logger.Level.ERROR, "Either \"mp.jwt.verify.publickey\", or \"mp.jwt.verify.publickey.location\" must be configured; \"mp.jwt.verify.issuer\" should be configured.");
            }
            return Optional.ofNullable(publicKeyPath).map(this::loadJwkKeysFromLocation).or(() -> Optional.ofNullable(publicKey).map(pk -> this.loadJwkKeys("configuration", (String)pk))).or(() -> Optional.ofNullable(defaultJwk).map(jwk -> JwkKeys.builder().addKey((Jwk)jwk.get()).build())).orElseThrow(() -> new SecurityException("No public key or default JWK set for MP JWT-Auth Provider."));
        }

        private JwkKeys loadJwkKeysFromLocation(String uri) {
            return this.locatePath(uri).map(path -> {
                try {
                    return this.loadJwkKeys("file " + String.valueOf(path), Files.readString(path, StandardCharsets.UTF_8));
                }
                catch (IOException e) {
                    throw new SecurityException("Failed to load public key(s) from path: " + String.valueOf(path.toAbsolutePath()), (Throwable)e);
                }
            }).orElseGet(() -> {
                JwkKeys jwkKeys;
                block9: {
                    InputStream is = this.locateStream(uri);
                    try {
                        if (null == is) {
                            throw new SecurityException("Could not find public key resource for MP JWT-Auth at: " + uri);
                        }
                        jwkKeys = this.getPublicKeyFromContent(uri, is);
                        if (is == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new SecurityException("Failed to load public key(s) from : " + uri, (Throwable)e);
                        }
                    }
                    is.close();
                }
                return jwkKeys;
            });
        }

        private Optional<Path> locatePath(String uri) {
            try {
                Path path = Paths.get(uri, new String[0]);
                if (Files.exists(path, new LinkOption[0])) {
                    return Optional.of(path);
                }
            }
            catch (InvalidPathException e) {
                LOGGER.log(System.Logger.Level.TRACE, "Could not locate path: " + uri, (Throwable)e);
            }
            return Optional.empty();
        }

        private InputStream locateStream(String uri) throws IOException {
            InputStream is;
            URL url = Thread.currentThread().getContextClassLoader().getResource(uri);
            if (url == null && uri.startsWith("/")) {
                url = Thread.currentThread().getContextClassLoader().getResource(uri.substring(1));
            }
            if (url == null) {
                is = JwtAuthProvider.class.getResourceAsStream(uri);
                if (null == is) {
                    try {
                        url = new URL(uri);
                    }
                    catch (MalformedURLException ignored2) {
                        LOGGER.log(System.Logger.Level.TRACE, () -> "Configuration of public key(s) is not a valid URL: " + uri);
                        return null;
                    }
                    is = url.openStream();
                }
            } else {
                is = url.openStream();
            }
            return is;
        }

        private JwkKeys getPublicKeyFromContent(String location, InputStream bufferedInputStream) throws IOException {
            return this.loadJwkKeys(location, new String(bufferedInputStream.readAllBytes(), StandardCharsets.UTF_8));
        }

        private JwkKeys loadJwkKeys(String location, String stringContent) {
            if (stringContent.isEmpty()) {
                throw new SecurityException("Cannot load public key from " + location + ", as its content is empty");
            }
            Matcher m = PUBLIC_KEY_PATTERN.matcher(stringContent);
            if (m.find()) {
                return this.loadPlainPublicKey(stringContent);
            }
            if (stringContent.startsWith(JSON_START_MARK)) {
                return this.loadPublicKeyJWK(stringContent);
            }
            return this.loadPublicKeyJWKBase64(stringContent);
        }

        private JwkKeys loadPlainPublicKey(String stringContent) {
            PublicKey publicKey = (PublicKey)((Keys.Builder)Keys.builder().pem(pem -> pem.publicKey(Resource.create((String)"public key from PKCS8", (String)stringContent)))).build().publicKey().orElseThrow(() -> new DeploymentException("Failed to load public key from string content"));
            String algorithm = publicKey.getAlgorithm();
            Object jwk = "EC".equals(algorithm) ? JwkEC.builder().publicKey((ECPublicKey)publicKey).build() : JwkRSA.builder().publicKey((RSAPublicKey)publicKey).build();
            return JwkKeys.builder().addKey((Jwk)jwk).build();
        }

        private JwkKeys loadPublicKeyJWKBase64(String base64Encoded) {
            return this.loadPublicKeyJWK(new String(Base64.getUrlDecoder().decode(base64Encoded), StandardCharsets.UTF_8));
        }

        private JwkKeys loadPublicKeyJWK(String jwkJson) {
            if (jwkJson.contains("keys")) {
                return JwkKeys.builder().resource(Resource.create((String)"public key from PKCS8", (String)jwkJson)).build();
            }
            JsonObject jsonObject = JSON.createReader((Reader)new StringReader(jwkJson)).readObject();
            return JwkKeys.builder().addKey(Jwk.create((JsonObject)jsonObject)).build();
        }

        public Builder propagate(boolean propagate) {
            this.propagate = propagate;
            return this;
        }

        public Builder authenticate(boolean authenticate) {
            this.authenticate = authenticate;
            return this;
        }

        public Builder allowImpersonation(boolean allowImpersonation) {
            this.allowImpersonation = allowImpersonation;
            return this;
        }

        public Builder subjectType(SubjectType subjectType) {
            this.subjectType = subjectType;
            switch (subjectType) {
                case USER: 
                case SERVICE: {
                    break;
                }
                default: {
                    throw new SecurityException("Invalid configuration. Principal type not supported: " + String.valueOf(subjectType));
                }
            }
            return this;
        }

        public Builder atnTokenHandler(TokenHandler tokenHandler) {
            this.atnTokenHandler = tokenHandler;
            return this;
        }

        public Builder optional(boolean optional) {
            this.optional = optional;
            return this;
        }

        public Builder outboundConfig(OutboundConfig config) {
            this.outboundConfig = config;
            return this;
        }

        public Builder signJwk(Resource signJwkResource) {
            this.signKeys = JwkKeys.builder().resource(signJwkResource).build();
            return this;
        }

        public Builder verifyJwk(Resource verifyJwkResource) {
            this.verifyKeys = LazyValue.create((Object)JwkKeys.builder().resource(verifyJwkResource).build());
            return this;
        }

        public Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            this.publicKeyPath = null;
            return this;
        }

        public Builder publicKeyPath(String publicKeyPath) {
            this.publicKeyPath = publicKeyPath;
            return this;
        }

        public Builder defaultJwk(Jwk defaultJwk) {
            this.defaultJwk = LazyValue.create((Object)defaultJwk);
            return this;
        }

        public Builder defaultKeyId(String defaultKeyId) {
            this.defaultKeyId = defaultKeyId;
            return this;
        }

        public Builder config(io.helidon.common.config.Config config) {
            config.get("optional").asBoolean().ifPresent(this::optional);
            config.get("authenticate").asBoolean().ifPresent(this::authenticate);
            config.get("propagate").asBoolean().ifPresent(this::propagate);
            config.get("allow-impersonation").asBoolean().ifPresent(this::allowImpersonation);
            config.get("principal-type").asString().as(SubjectType::valueOf).ifPresent(this::subjectType);
            config.get("atn-token.handler").map(TokenHandler::create).ifPresent(this::atnTokenHandler);
            config.get("atn-token").asNode().ifPresent(this::verifyKeys);
            config.get("atn-token.jwt-audience").asString().ifPresent(this::expectedAudience);
            config.get("atn-token.default-key-id").asString().ifPresent(this::defaultKeyId);
            config.get("atn-token.verify-key").asString().ifPresent(this::publicKeyPath);
            config.get("sign-token").asNode().ifPresent(outbound -> this.outboundConfig(OutboundConfig.create((io.helidon.common.config.Config)outbound)));
            config.get("sign-token").asNode().ifPresent(this::outbound);
            config.get("load-on-startup").asBoolean().ifPresent(this::loadOnStartup);
            Config mpConfig = ConfigProviderResolver.instance().getConfig();
            mpConfig.getOptionalValue(CONFIG_PUBLIC_KEY, String.class).ifPresent(this::publicKey);
            mpConfig.getOptionalValue(CONFIG_PUBLIC_KEY_PATH, String.class).ifPresent(this::publicKeyPath);
            mpConfig.getOptionalValue(JwtAuthProvider.CONFIG_EXPECTED_ISSUER, String.class).ifPresent(this::expectedIssuer);
            mpConfig.getOptionalValue(JwtAuthProvider.CONFIG_EXPECTED_AUDIENCES, String[].class).map(List::of).ifPresent(this::expectedAudiences);
            mpConfig.getOptionalValue(JwtAuthProvider.CONFIG_EXPECTED_MAX_TOKEN_AGE, Integer.TYPE).ifPresent(this::expectedMaxTokenAge);
            mpConfig.getOptionalValue(JwtAuthProvider.CONFIG_COOKIE_PROPERTY_NAME, String.class).ifPresent(this::cookieProperty);
            mpConfig.getOptionalValue(JwtAuthProvider.CONFIG_JWT_HEADER, String.class).ifPresent(this::jwtHeader);
            mpConfig.getOptionalValue(CONFIG_JWT_DECRYPT_KEY_LOCATION, String.class).ifPresent(this::decryptKeyLocation);
            mpConfig.getOptionalValue(CONFIG_JWT_DECRYPT_KEY_ALGORITHM, String.class).ifPresent(this::decryptKeyAlgorithm);
            mpConfig.getOptionalValue(JwtAuthProvider.CONFIG_CLOCK_SKEW, Integer.TYPE).ifPresent(this::clockSkew);
            if (null == this.publicKey && null == this.publicKeyPath) {
                String key = "helidon.mp.jwt.verify.publickey.location";
                mpConfig.getOptionalValue(key, String.class).ifPresent(it -> {
                    this.publicKeyPath((String)it);
                    LOGGER.log(System.Logger.Level.WARNING, "You have configured public key for JWT-Auth provider using a property reserved for TCK tests (" + key + "). Please use mp.jwt.verify.publickey.location instead.");
                });
            }
            return this;
        }

        public Builder jwtHeader(String header) {
            if (HeaderNames.COOKIE.defaultCase().equalsIgnoreCase(header)) {
                this.useCookie = true;
            } else {
                this.useCookie = false;
                this.atnTokenHandler = TokenHandler.builder().tokenHeader(header).tokenPrefix("bearer ").build();
            }
            return this;
        }

        public Builder cookieProperty(String cookieProperty) {
            this.cookieProperty = cookieProperty;
            return this;
        }

        public Builder expectedIssuer(String issuer) {
            this.expectedIssuer = issuer;
            return this;
        }

        @Deprecated(forRemoval=true, since="2.4.0")
        public Builder expectedAudience(String audience) {
            return this.addExpectedAudience(audience);
        }

        public Builder addExpectedAudience(String audience) {
            this.expectedAudiences.add(audience);
            return this;
        }

        public Builder expectedAudiences(Collection<String> audiences) {
            this.expectedAudiences.clear();
            this.expectedAudiences.addAll(audiences);
            return this;
        }

        public Builder expectedMaxTokenAge(int expectedMaxTokenAge) {
            this.expectedMaxTokenAge = Duration.ofSeconds(expectedMaxTokenAge);
            return this;
        }

        public Builder decryptKeyLocation(String decryptKeyLocation) {
            this.decryptKeyLocation = decryptKeyLocation;
            return this;
        }

        public Builder decryptKeyAlgorithm(String decryptionKeyAlgorithm) {
            this.decryptionKeyAlgorithm = decryptionKeyAlgorithm;
            return this;
        }

        public Builder loadOnStartup(boolean loadOnStartup) {
            this.loadOnStartup = loadOnStartup;
            return this;
        }

        public Builder clockSkew(int clockSkew) {
            this.clockSkew = Duration.ofSeconds(clockSkew);
            return this;
        }

        private void verifyKeys(io.helidon.common.config.Config config) {
            config.get("jwk.resource").map(Resource::create).ifPresent(this::verifyJwk);
        }

        private void outbound(io.helidon.common.config.Config config) {
            config.get("jwt-issuer").asString().ifPresent(this::issuer);
            config.get("jwk.resource").map(Resource::create).ifPresent(this::signJwk);
        }
    }

    public static class JwtOutboundTarget {
        private final TokenHandler outboundHandler;
        private final String jwtKid;
        private final String jwkKid;
        private final String jwtAudience;
        private final int notBeforeSeconds;
        private final long validitySeconds;

        public JwtOutboundTarget(TokenHandler outboundHandler, String jwtKid, String jwkKid, String audience, int notBeforeSeconds, long validitySeconds) {
            this.outboundHandler = outboundHandler;
            this.jwtKid = jwtKid;
            this.jwkKid = jwkKid;
            this.jwtAudience = audience;
            this.notBeforeSeconds = notBeforeSeconds;
            this.validitySeconds = validitySeconds;
        }

        public static JwtOutboundTarget fromConfig(io.helidon.common.config.Config config, TokenHandler defaultHandler) {
            TokenHandler tokenHandler = config.get("outbound-token").asNode().map(TokenHandler::create).orElse(defaultHandler);
            return new JwtOutboundTarget(tokenHandler, (String)config.get("jwt-kid").asString().orElse(null), (String)config.get("jwk-kid").asString().orElse(null), (String)config.get("jwt-audience").asString().orElse(null), (Integer)config.get("jwt-not-before-seconds").asInt().orElse((Object)5), (Long)config.get("jwt-validity-seconds").asLong().orElse((Object)86400L));
        }

        private void update(Jwt.Builder builder) {
            Instant now = Instant.now();
            Instant exp = now.plus(this.validitySeconds, ChronoUnit.SECONDS);
            Instant notBefore = now.minus(this.notBeforeSeconds, ChronoUnit.SECONDS);
            builder.issueTime(now).expirationTime(exp).notBefore(notBefore).keyId(this.jwtKid).addAudience(this.jwtAudience);
        }
    }
}

