/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.microprofile.metrics.Gauge;

class DelegatingGauge<T>
implements Gauge<T> {
    private final Method method;
    private final Object obj;
    private final Class<T> clazz;

    private DelegatingGauge(Method method, Object obj, Class<T> clazz) {
        this.method = method;
        this.obj = obj;
        this.clazz = clazz;
    }

    public static <S> DelegatingGauge<S> newInstance(Method method, Object obj, Class<S> clazz) {
        return new DelegatingGauge<S>(method, obj, clazz);
    }

    public T getValue() {
        try {
            return (T)this.method.invoke(this.obj, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }
}

