/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import io.helidon.microprofile.metrics.InterceptionRunner;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.interceptor.InvocationContext;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.CompletionCallback;
import javax.ws.rs.container.Suspended;

class InterceptionRunnerImpl
implements InterceptionRunner {
    private static final InterceptionRunner INSTANCE = new InterceptionRunnerImpl();

    InterceptionRunnerImpl() {
    }

    static InterceptionRunner create(Executable executable) {
        if (executable instanceof Constructor) {
            return INSTANCE;
        }
        if (executable instanceof Method) {
            int asyncResponseSlot = InterceptionRunnerImpl.asyncResponseSlot((Method)executable);
            return asyncResponseSlot >= 0 ? AsyncMethodRunnerImpl.create(asyncResponseSlot) : INSTANCE;
        }
        throw new IllegalArgumentException("Executable " + executable.getName() + " is not a constructor or method");
    }

    @Override
    public <T> Object run(InvocationContext context, Iterable<T> workItems, BiConsumer<InvocationContext, T> preInvocationHandler) throws Exception {
        workItems.forEach(workItem -> preInvocationHandler.accept(context, workItem));
        return context.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Object run(InvocationContext context, Iterable<T> workItems, BiConsumer<InvocationContext, T> preInvocationHandler, BiConsumer<InvocationContext, T> postCompletionHandler) throws Exception {
        workItems.forEach(workItem -> preInvocationHandler.accept(context, workItem));
        try {
            Object object = context.proceed();
            return object;
        }
        finally {
            workItems.forEach(workItem -> postCompletionHandler.accept(context, workItem));
        }
    }

    private static int asyncResponseSlot(Method interceptedMethod) {
        int result = 0;
        for (Parameter p : interceptedMethod.getParameters()) {
            if (AsyncResponse.class.isAssignableFrom(p.getType()) && p.getAnnotation(Suspended.class) != null) {
                return result;
            }
            ++result;
        }
        return -1;
    }

    private static class FinishCallback<T>
    implements CompletionCallback {
        private static final Logger LOGGER = Logger.getLogger(FinishCallback.class.getName());
        private final InvocationContext context;
        private final BiConsumer<InvocationContext, T> postCompletionHandler;
        private final Iterable<T> workItems;

        static <T> FinishCallback<T> create(InvocationContext context, BiConsumer<InvocationContext, T> postCompletionHandler, Iterable<T> workItems) {
            return new FinishCallback<T>(context, postCompletionHandler, workItems);
        }

        private FinishCallback(InvocationContext context, BiConsumer<InvocationContext, T> postCompletionHandler, Iterable<T> workItems) {
            this.context = context;
            this.postCompletionHandler = postCompletionHandler;
            this.workItems = workItems;
        }

        public void onComplete(Throwable throwable) {
            this.workItems.forEach(workItem -> this.postCompletionHandler.accept(this.context, (InvocationContext)workItem));
            if (throwable != null) {
                LOGGER.log(Level.FINE, "Throwable detected by interceptor async callback", throwable);
            }
        }
    }

    private static class AsyncMethodRunnerImpl
    extends InterceptionRunnerImpl {
        private final int asyncResponseSlot;

        static InterceptionRunner create(int asyncResponseSlot) {
            return new AsyncMethodRunnerImpl(asyncResponseSlot);
        }

        private AsyncMethodRunnerImpl(int asyncResponseSlot) {
            this.asyncResponseSlot = asyncResponseSlot;
        }

        @Override
        public <T> Object run(InvocationContext context, Iterable<T> workItems, BiConsumer<InvocationContext, T> preInvocationHandler, BiConsumer<InvocationContext, T> postCompletionHandler) throws Exception {
            Objects.requireNonNull(postCompletionHandler, "postCompletionHandler");
            workItems.forEach(workItem -> preInvocationHandler.accept(context, workItem));
            AsyncResponse asyncResponse = (AsyncResponse)AsyncResponse.class.cast(context.getParameters()[this.asyncResponseSlot]);
            asyncResponse.register(FinishCallback.create(context, postCompletionHandler, workItems));
            return context.proceed();
        }

        public String toString() {
            return new StringJoiner(", ", AsyncMethodRunnerImpl.class.getSimpleName() + "[", "]").add("asyncResponseSlot=" + this.asyncResponseSlot).toString();
        }
    }
}

