/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import io.helidon.microprofile.metrics.VendorDefined;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.ConcurrentGauge;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Metered;
import org.eclipse.microprofile.metrics.annotation.Metric;
import org.eclipse.microprofile.metrics.annotation.SimplyTimed;
import org.eclipse.microprofile.metrics.annotation.Timed;

@ApplicationScoped
class MetricProducer {
    MetricProducer() {
    }

    private static Metadata newMetadata(InjectionPoint ip, Metric metric, MetricType metricType) {
        return metric == null ? Metadata.builder().withName(MetricProducer.getName(ip)).withDisplayName("").withDescription("").withType(metricType).withUnit(MetricProducer.chooseDefaultUnit(metricType)).build() : Metadata.builder().withName(MetricProducer.getName(metric, ip)).withDisplayName(metric.displayName()).withDescription(metric.description()).withType(metricType).withUnit(metric.unit()).build();
    }

    private static String chooseDefaultUnit(MetricType metricType) {
        String result;
        switch (metricType) {
            case METERED: {
                result = "per_second";
                break;
            }
            case TIMER: {
                result = "nanoseconds";
                break;
            }
            case SIMPLE_TIMER: {
                result = "seconds";
                break;
            }
            default: {
                result = "none";
            }
        }
        return result;
    }

    private static Tag[] tags(Metric metric) {
        if (metric == null || metric.tags() == null) {
            return null;
        }
        ArrayList<Tag> result = new ArrayList<Tag>();
        for (String tag : metric.tags()) {
            int eq;
            if (tag == null || (eq = tag.indexOf("=")) <= 0) continue;
            result.add(new Tag(tag.substring(0, eq), tag.substring(eq + 1)));
        }
        return result.toArray(new Tag[result.size()]);
    }

    private static String getName(InjectionPoint ip) {
        StringBuilder fullName = new StringBuilder();
        fullName.append(ip.getMember().getDeclaringClass().getName());
        fullName.append('.');
        fullName.append(ip.getMember().getName());
        if (ip.getMember() instanceof Constructor) {
            fullName.append("new");
        }
        return fullName.toString();
    }

    private static String getName(Metric metric, InjectionPoint ip) {
        boolean isAbsolute = metric != null && metric.absolute();
        String prefix = isAbsolute ? "" : ip.getMember().getDeclaringClass().getName() + ".";
        String shortName = metric != null && !metric.name().isEmpty() ? metric.name() : ip.getMember().getName();
        String ctorSuffix = ip.getMember() instanceof Constructor ? ".new" : "";
        String fullName = prefix + shortName + ctorSuffix;
        return fullName;
    }

    @Produces
    private Counter produceCounterDefault(MetricRegistry registry, InjectionPoint ip) {
        return this.produceCounter(registry, ip);
    }

    @Produces
    @VendorDefined
    private Counter produceCounter(MetricRegistry registry, InjectionPoint ip) {
        return this.produceMetric(registry, ip, Counted.class, () -> ((MetricRegistry)registry).getCounters(), (arg_0, arg_1) -> ((MetricRegistry)registry).counter(arg_0, arg_1), Counter.class);
    }

    @Produces
    private Meter produceMeterDefault(MetricRegistry registry, InjectionPoint ip) {
        return this.produceMeter(registry, ip);
    }

    @Produces
    @VendorDefined
    private Meter produceMeter(MetricRegistry registry, InjectionPoint ip) {
        return this.produceMetric(registry, ip, Metered.class, () -> ((MetricRegistry)registry).getMeters(), (arg_0, arg_1) -> ((MetricRegistry)registry).meter(arg_0, arg_1), Meter.class);
    }

    @Produces
    private Timer produceTimerDefault(MetricRegistry registry, InjectionPoint ip) {
        return this.produceTimer(registry, ip);
    }

    @Produces
    @VendorDefined
    private Timer produceTimer(MetricRegistry registry, InjectionPoint ip) {
        return this.produceMetric(registry, ip, Timed.class, () -> ((MetricRegistry)registry).getTimers(), (arg_0, arg_1) -> ((MetricRegistry)registry).timer(arg_0, arg_1), Timer.class);
    }

    @Produces
    @VendorDefined
    private SimpleTimer produceSimpleTimer(MetricRegistry registry, InjectionPoint ip) {
        return this.produceMetric(registry, ip, SimplyTimed.class, () -> ((MetricRegistry)registry).getSimpleTimers(), (arg_0, arg_1) -> ((MetricRegistry)registry).simpleTimer(arg_0, arg_1), SimpleTimer.class);
    }

    @Produces
    private SimpleTimer produceSimpleTimerDefault(MetricRegistry registry, InjectionPoint ip) {
        return this.produceSimpleTimer(registry, ip);
    }

    @Produces
    private Histogram produceHistogramDefault(MetricRegistry registry, InjectionPoint ip) {
        return this.produceHistogram(registry, ip);
    }

    @Produces
    @VendorDefined
    private Histogram produceHistogram(MetricRegistry registry, InjectionPoint ip) {
        return this.produceMetric(registry, ip, null, () -> ((MetricRegistry)registry).getHistograms(), (arg_0, arg_1) -> ((MetricRegistry)registry).histogram(arg_0, arg_1), Histogram.class);
    }

    @Produces
    private org.eclipse.microprofile.metrics.ConcurrentGauge produceConcurrentGaugeDefault(MetricRegistry registry, InjectionPoint ip) {
        return this.produceConcurrentGauge(registry, ip);
    }

    @Produces
    @VendorDefined
    private org.eclipse.microprofile.metrics.ConcurrentGauge produceConcurrentGauge(MetricRegistry registry, InjectionPoint ip) {
        return this.produceMetric(registry, ip, ConcurrentGauge.class, () -> ((MetricRegistry)registry).getConcurrentGauges(), (arg_0, arg_1) -> ((MetricRegistry)registry).concurrentGauge(arg_0, arg_1), org.eclipse.microprofile.metrics.ConcurrentGauge.class);
    }

    @Produces
    @VendorDefined
    private <T> Gauge<T> produceGauge(MetricRegistry registry, InjectionPoint ip) {
        Metric metric = (Metric)ip.getAnnotated().getAnnotation(Metric.class);
        return (Gauge)registry.getGauges().entrySet().stream().filter(entry -> ((MetricID)entry.getKey()).getName().equals(metric.name())).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not produce Gauge for injection point " + ip.toString())).getValue();
    }

    @Produces
    private <T> Gauge<T> produceGaugeDefault(MetricRegistry registry, InjectionPoint ip) {
        return this.produceGauge(registry, ip);
    }

    private <T extends org.eclipse.microprofile.metrics.Metric, U extends Annotation> T produceMetric(MetricRegistry registry, InjectionPoint ip, Class<U> annotationClass, Supplier<Map<MetricID, T>> getTypedMetricsFn, BiFunction<Metadata, Tag[], T> registerFn, Class<T> clazz) {
        Metric metricAnno = (Metric)ip.getAnnotated().getAnnotation(Metric.class);
        Tag[] tags = MetricProducer.tags(metricAnno);
        MetricID metricID = new MetricID(MetricProducer.getName(metricAnno, ip), tags);
        org.eclipse.microprofile.metrics.Metric result = (org.eclipse.microprofile.metrics.Metric)getTypedMetricsFn.get().get(metricID);
        Metadata newMetadata = MetricProducer.newMetadata(ip, metricAnno, MetricType.from(clazz));
        if (result != null) {
            Annotation specificMetricAnno;
            Annotation annotation = specificMetricAnno = annotationClass == null ? null : ip.getAnnotated().getAnnotation(annotationClass);
            if (specificMetricAnno == null) {
                return (T)result;
            }
            Metadata existingMetadata = (Metadata)registry.getMetadata().get(metricID.getName());
            MetricProducer.enforceReusability(metricID, existingMetadata, newMetadata, new Tag[0]);
        } else {
            result = (org.eclipse.microprofile.metrics.Metric)registerFn.apply(newMetadata, tags);
        }
        return (T)result;
    }

    private static void enforceReusability(MetricID metricID, Metadata existingMetadata, Metadata newMetadata, Tag ... tags) {
        if (existingMetadata.isReusable() != newMetadata.isReusable()) {
            throw new IllegalArgumentException("Attempt to reuse metric " + metricID + " with inconsistent isReusable setting");
        }
        if (!newMetadata.isReusable()) {
            throw new IllegalArgumentException("Attempting to reuse metric " + metricID + " that is not reusable");
        }
    }
}

