/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import io.helidon.microprofile.metrics.RegistryProducer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.annotation.ConcurrentGauge;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Metered;
import org.eclipse.microprofile.metrics.annotation.SimplyTimed;
import org.eclipse.microprofile.metrics.annotation.Timed;

public final class MetricUtil {
    private static final Logger LOGGER = Logger.getLogger(MetricUtil.class.getName());

    private MetricUtil() {
    }

    @Deprecated
    public static <E extends Member & AnnotatedElement, A extends Annotation> LookupResult<A> lookupAnnotation(E element, Class<? extends Annotation> annotClass, Class<?> clazz) {
        Annotation annotation = ((AnnotatedElement)element).getAnnotation(annotClass);
        if (annotation != null) {
            return new LookupResult<Annotation>(MatchingType.METHOD, annotation);
        }
        annotation = element.getDeclaringClass().getAnnotation(annotClass);
        if (annotation == null) {
            annotation = clazz.getAnnotation(annotClass);
        }
        return annotation == null ? null : new LookupResult<Annotation>(MatchingType.CLASS, annotation);
    }

    @Deprecated
    static <A extends Annotation> LookupResult<A> lookupAnnotation(AnnotatedType<?> annotatedType, AnnotatedMethod<?> annotatedMethod, Class<A> annotClass) {
        Annotation annotation = annotatedMethod.getAnnotation(annotClass);
        if (annotation != null) {
            return new LookupResult<Annotation>(MetricUtil.matchingType(annotatedMethod), annotation);
        }
        annotation = annotatedType.getAnnotation(annotClass);
        if (annotation == null) {
            annotation = annotatedType.getJavaClass().getAnnotation(annotClass);
        }
        return annotation == null ? null : new LookupResult<Annotation>(MatchingType.CLASS, annotation);
    }

    @Deprecated
    static <A extends Annotation> List<LookupResult<A>> lookupAnnotations(AnnotatedType<?> annotatedType, AnnotatedMember<?> annotatedMember, Class<A> annotClass) {
        List<LookupResult<A>> result = MetricUtil.lookupAnnotations(annotatedMember, annotClass);
        if (result.isEmpty()) {
            result = MetricUtil.lookupAnnotations(annotatedType, annotClass);
        }
        return result;
    }

    static <A extends Annotation> List<LookupResult<A>> lookupAnnotations(Annotated annotated, Class<A> annotClass) {
        return annotated.getAnnotations().stream().filter(annotClass::isInstance).map(annotation -> new LookupResult<Annotation>(MetricUtil.matchingType(annotated), (Annotation)annotClass.cast(annotation))).collect(Collectors.toList());
    }

    @Deprecated
    public static <E extends Member & AnnotatedElement> String getMetricName(Member element, Class<?> clazz, MatchingType matchingType, String explicitName, boolean absolute) {
        Object result;
        if (matchingType == MatchingType.METHOD) {
            Object object = result = explicitName == null || explicitName.isEmpty() ? MetricUtil.getElementName(element, clazz) : explicitName;
            if (!absolute) {
                Class<?> declaringClass = clazz;
                if (element instanceof Method) {
                    List<Method> methods = Arrays.asList(declaringClass.getDeclaredMethods());
                    while (!methods.contains(element)) {
                        declaringClass = declaringClass.getSuperclass();
                        methods = Arrays.asList(declaringClass.getDeclaredMethods());
                    }
                }
                result = declaringClass.getName() + "." + (String)result;
            }
        } else if (matchingType == MatchingType.CLASS) {
            if (explicitName == null || explicitName.isEmpty()) {
                result = MetricUtil.getElementName(element, clazz);
                if (!absolute) {
                    result = clazz.getName() + "." + (String)result;
                }
            } else {
                if (absolute) {
                    LOGGER.warning(() -> "Attribute 'absolute=true' in metric annotation ignored at class level");
                }
                result = clazz.getPackage().getName() + "." + explicitName + "." + MetricUtil.getElementName(element, clazz);
            }
        } else {
            throw new InternalError("Unknown matching type");
        }
        return result;
    }

    @Deprecated
    public static <E extends Member & AnnotatedElement> void registerMetric(MetricRegistry registry, E element, Class<?> clazz, Annotation annotation, MatchingType type) {
        if (annotation instanceof Counted) {
            Counted counted = (Counted)annotation;
            String metricName = MetricUtil.getMetricName(element, clazz, type, counted.name().trim(), counted.absolute());
            String displayName = counted.displayName().trim();
            Metadata meta = Metadata.builder().withName(metricName).withDisplayName(displayName.isEmpty() ? metricName : displayName).withDescription(counted.description().trim()).withType(MetricType.COUNTER).withUnit(counted.unit().trim()).reusable(counted.reusable()).build();
            registry.counter(meta, MetricUtil.tags(counted.tags()));
            LOGGER.fine(() -> "### Registered counter " + metricName);
        } else if (annotation instanceof Metered) {
            Metered metered = (Metered)annotation;
            String metricName = MetricUtil.getMetricName(element, clazz, type, metered.name().trim(), metered.absolute());
            String displayName = metered.displayName().trim();
            Metadata meta = Metadata.builder().withName(metricName).withDisplayName(displayName.isEmpty() ? metricName : displayName).withDescription(metered.description().trim()).withType(MetricType.METERED).withUnit(metered.unit().trim()).reusable(metered.reusable()).build();
            registry.meter(meta, MetricUtil.tags(metered.tags()));
            LOGGER.fine(() -> "### Registered meter " + metricName);
        } else if (annotation instanceof ConcurrentGauge) {
            ConcurrentGauge concurrentGauge = (ConcurrentGauge)annotation;
            String metricName = MetricUtil.getMetricName(element, clazz, type, concurrentGauge.name().trim(), concurrentGauge.absolute());
            String displayName = concurrentGauge.displayName().trim();
            Metadata meta = Metadata.builder().withName(metricName).withDisplayName(displayName.isEmpty() ? metricName : displayName).withDescription(concurrentGauge.description().trim()).withType(MetricType.METERED).withUnit(concurrentGauge.unit().trim()).build();
            registry.concurrentGauge(meta, MetricUtil.tags(concurrentGauge.tags()));
            LOGGER.fine(() -> "### Registered ConcurrentGauge " + metricName);
        } else if (annotation instanceof Timed) {
            Timed timed = (Timed)annotation;
            String metricName = MetricUtil.getMetricName(element, clazz, type, timed.name().trim(), timed.absolute());
            String displayName = timed.displayName().trim();
            Metadata meta = Metadata.builder().withName(metricName).withDisplayName(displayName.isEmpty() ? metricName : displayName).withDescription(timed.description().trim()).withType(MetricType.TIMER).withUnit(timed.unit().trim()).reusable(timed.reusable()).build();
            registry.timer(meta, MetricUtil.tags(timed.tags()));
            LOGGER.fine(() -> "### Registered timer " + metricName);
        } else if (annotation instanceof SimplyTimed) {
            SimplyTimed simplyTimed = (SimplyTimed)annotation;
            String metricName = MetricUtil.getMetricName(element, clazz, type, simplyTimed.name().trim(), simplyTimed.absolute());
            String displayName = simplyTimed.displayName().trim();
            Metadata meta = Metadata.builder().withName(metricName).withDisplayName(displayName.isEmpty() ? metricName : displayName).withDescription(simplyTimed.description().trim()).withType(MetricType.SIMPLE_TIMER).withUnit(simplyTimed.unit().trim()).reusable(simplyTimed.reusable()).build();
            registry.simpleTimer(meta, MetricUtil.tags(simplyTimed.tags()));
            LOGGER.fine(() -> "### Registered simple timer " + metricName);
        }
    }

    public static <E extends Member & AnnotatedElement> void registerMetric(E element, Class<?> clazz, LookupResult<? extends Annotation> lookupResult) {
        MetricUtil.registerMetric(element, clazz, lookupResult.getAnnotation(), lookupResult.getType());
    }

    public static <E extends Member & AnnotatedElement> void registerMetric(E element, Class<?> clazz, Annotation annotation, MatchingType type) {
        MetricRegistry registry = MetricUtil.getMetricRegistry();
        if (annotation instanceof Counted) {
            Counted counted = (Counted)annotation;
            String metricName = MetricUtil.getMetricName(element, clazz, type, counted.name().trim(), counted.absolute());
            String displayName = counted.displayName().trim();
            Metadata meta = Metadata.builder().withName(metricName).withDisplayName(displayName.isEmpty() ? metricName : displayName).withDescription(counted.description().trim()).withType(MetricType.COUNTER).withUnit(counted.unit().trim()).reusable(counted.reusable()).build();
            registry.counter(meta);
            LOGGER.fine(() -> "### Registered counter " + metricName);
        } else if (annotation instanceof Metered) {
            Metered metered = (Metered)annotation;
            String metricName = MetricUtil.getMetricName(element, clazz, type, metered.name().trim(), metered.absolute());
            String displayName = metered.displayName().trim();
            Metadata meta = Metadata.builder().withName(metricName).withDisplayName(displayName.isEmpty() ? metricName : displayName).withDescription(metered.description().trim()).withType(MetricType.METERED).withUnit(metered.unit().trim()).reusable(metered.reusable()).build();
            registry.meter(meta);
            LOGGER.fine(() -> "### Registered meter " + metricName);
        } else if (annotation instanceof ConcurrentGauge) {
            ConcurrentGauge concurrentGauge = (ConcurrentGauge)annotation;
            String metricName = MetricUtil.getMetricName(element, clazz, type, concurrentGauge.name().trim(), concurrentGauge.absolute());
            String displayName = concurrentGauge.displayName().trim();
            Metadata meta = Metadata.builder().withName(metricName).withDisplayName(displayName.isEmpty() ? metricName : displayName).withDescription(concurrentGauge.description().trim()).withType(MetricType.METERED).withUnit(concurrentGauge.unit().trim()).build();
            registry.concurrentGauge(meta);
            LOGGER.fine(() -> "### Registered ConcurrentGauge " + metricName);
        } else if (annotation instanceof Timed) {
            Timed timed = (Timed)annotation;
            String metricName = MetricUtil.getMetricName(element, clazz, type, timed.name().trim(), timed.absolute());
            String displayName = timed.displayName().trim();
            Metadata meta = Metadata.builder().withName(metricName).withDisplayName(displayName.isEmpty() ? metricName : displayName).withDescription(timed.description().trim()).withType(MetricType.TIMER).withUnit(timed.unit().trim()).reusable(timed.reusable()).build();
            registry.timer(meta);
            LOGGER.fine(() -> "### Registered timer " + metricName);
        } else if (annotation instanceof SimplyTimed) {
            SimplyTimed simplyTimed = (SimplyTimed)annotation;
            String metricName = MetricUtil.getMetricName(element, clazz, type, simplyTimed.name().trim(), simplyTimed.absolute());
            String displayName = simplyTimed.displayName().trim();
            Metadata meta = Metadata.builder().withName(metricName).withDisplayName(displayName.isEmpty() ? metricName : displayName).withDescription(simplyTimed.description().trim()).withType(MetricType.SIMPLE_TIMER).withUnit(simplyTimed.unit().trim()).reusable(simplyTimed.reusable()).build();
            registry.timer(meta);
            LOGGER.fine(() -> "### Registered simple timer " + metricName);
        }
    }

    private static MetricRegistry getMetricRegistry() {
        return RegistryProducer.getDefaultRegistry();
    }

    static String getElementName(Member element, Class<?> clazz) {
        return element instanceof Constructor ? clazz.getSimpleName() : element.getName();
    }

    static Tag[] tags(String[] tagStrings) {
        ArrayList<Tag> result = new ArrayList<Tag>();
        for (int i = 0; i < tagStrings.length; ++i) {
            int eq = tagStrings[i].indexOf("=");
            if (eq <= 0) continue;
            String tagName = tagStrings[i].substring(0, eq);
            String tagValue = tagStrings[i].substring(eq + 1);
            result.add(new Tag(tagName, tagValue));
        }
        return result.toArray(new Tag[result.size()]);
    }

    private static MatchingType matchingType(Annotated annotated) {
        return annotated instanceof AnnotatedMember ? (((AnnotatedMember)annotated).getJavaMember() instanceof Executable ? MatchingType.METHOD : MatchingType.CLASS) : MatchingType.CLASS;
    }

    @Deprecated
    public static class LookupResult<A extends Annotation> {
        private final MatchingType type;
        private final A annotation;

        LookupResult(MatchingType type, A annotation) {
            this.type = type;
            this.annotation = annotation;
        }

        public MatchingType getType() {
            return this.type;
        }

        public A getAnnotation() {
            return this.annotation;
        }
    }

    @Deprecated
    public static enum MatchingType {
        METHOD,
        CLASS;

    }
}

