/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import io.helidon.common.Errors;
import io.helidon.common.context.Contexts;
import io.helidon.config.Config;
import io.helidon.config.ConfigValue;
import io.helidon.config.mp.MpConfig;
import io.helidon.metrics.api.RegistryFactory;
import io.helidon.metrics.serviceapi.MetricsSupport;
import io.helidon.microprofile.metrics.DelegatingGauge;
import io.helidon.microprofile.metrics.InterceptorConcurrentGauge;
import io.helidon.microprofile.metrics.InterceptorCounted;
import io.helidon.microprofile.metrics.InterceptorMetered;
import io.helidon.microprofile.metrics.InterceptorSimplyTimed;
import io.helidon.microprofile.metrics.InterceptorSyntheticSimplyTimed;
import io.helidon.microprofile.metrics.InterceptorTimed;
import io.helidon.microprofile.metrics.MetricAnnotationInfo;
import io.helidon.microprofile.metrics.MetricProducer;
import io.helidon.microprofile.metrics.MetricUtil;
import io.helidon.microprofile.metrics.RegistryProducer;
import io.helidon.microprofile.metrics.SyntheticSimplyTimed;
import io.helidon.microprofile.metrics.VendorDefined;
import io.helidon.microprofile.server.ServerCdiExtension;
import io.helidon.servicecommon.restcdi.HelidonRestCdiExtension;
import io.helidon.webserver.Routing;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import javax.inject.Singleton;
import javax.interceptor.Interceptor;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.ConcurrentGauge;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Gauge;
import org.eclipse.microprofile.metrics.annotation.Metered;
import org.eclipse.microprofile.metrics.annotation.Metric;
import org.eclipse.microprofile.metrics.annotation.SimplyTimed;
import org.eclipse.microprofile.metrics.annotation.Timed;

public class MetricsCdiExtension
extends HelidonRestCdiExtension<MetricsSupport> {
    private static final Logger LOGGER = Logger.getLogger(MetricsCdiExtension.class.getName());
    private static final Set<Class<? extends Annotation>> METRIC_ANNOTATIONS = new HashSet<Class>(Arrays.asList(Counted.class, Metered.class, Timed.class, ConcurrentGauge.class, SimplyTimed.class));
    private static final List<Class<? extends Annotation>> JAX_RS_ANNOTATIONS = Arrays.asList(GET.class, PUT.class, POST.class, HEAD.class, OPTIONS.class, DELETE.class, PATCH.class);
    static final String REST_ENDPOINTS_METRIC_ENABLED_PROPERTY_NAME = "rest-request.enabled";
    private static final boolean REST_ENDPOINTS_METRIC_ENABLED_DEFAULT_VALUE = false;
    static final String SYNTHETIC_SIMPLE_TIMER_METRIC_NAME = "REST.request";
    static final Metadata SYNTHETIC_SIMPLE_TIMER_METADATA = Metadata.builder().withName("REST.request").withDisplayName("REST.request for all REST endpoints").withDescription("The number of invocations and total response time of RESTful resource methods since the start of the server.").withType(MetricType.SIMPLE_TIMER).withUnit("nanoseconds").notReusable().build();
    @Deprecated
    private static final List<MetricAnnotationInfo.RegistrationPrep> LEGACY_ANNOTATED_SITES = new ArrayList<MetricAnnotationInfo.RegistrationPrep>();
    private boolean restEndpointsMetricsEnabled = false;
    private final Map<MetricID, AnnotatedMethod<?>> annotatedGaugeSites = new HashMap();
    private final List<MetricAnnotationInfo.RegistrationPrep> annotatedSites = new ArrayList<MetricAnnotationInfo.RegistrationPrep>();
    private Errors.Collector errors = Errors.collector();
    private final Map<Class<?>, Set<Method>> methodsWithSyntheticSimpleTimer = new HashMap();
    private final Set<Class<?>> syntheticSimpleTimerClassesProcessed = new HashSet();
    private final Set<Method> syntheticSimpleTimersToRegister = new HashSet<Method>();
    private final AtomicReference<Config> config = new AtomicReference();
    private final AtomicReference<Config> metricsConfig = new AtomicReference();
    private final HelidonRestCdiExtension.WorkItemsManager<MetricWorkItem> workItemsManager = HelidonRestCdiExtension.WorkItemsManager.create();

    private static <T> T getReference(BeanManager bm, Type type, Bean<?> bean) {
        return (T)bm.getReference(bean, type, bm.createCreationalContext(bean));
    }

    public MetricsCdiExtension() {
        super(LOGGER, MetricsSupport::create, "metrics");
    }

    @Deprecated
    public static <E extends Member & AnnotatedElement> void registerMetric(E element, Class<?> clazz, MetricUtil.LookupResult<? extends Annotation> lookupResult) {
        Executable executable;
        if (element instanceof AnnotatedCallable) {
            executable = (Executable)((AnnotatedCallable)element).getJavaMember();
        } else if (element instanceof Executable) {
            executable = (Executable)element;
        } else {
            throw new IllegalArgumentException("Element must be an AnnotatedCallable or Executable but was " + element.getClass().getName());
        }
        MetricsCdiExtension.registerMetricInternal(LEGACY_ANNOTATED_SITES, element, clazz, lookupResult, executable);
    }

    static <E extends Member & AnnotatedElement> void registerMetricInternal(List<MetricAnnotationInfo.RegistrationPrep> sites, E element, Class<?> clazz, MetricUtil.LookupResult<? extends Annotation> lookupResult, Executable executable) {
        MetricsCdiExtension.recordAnnotatedSite(sites, element, clazz, lookupResult, executable);
    }

    private static <E extends Member & AnnotatedElement> void recordAnnotatedSite(List<MetricAnnotationInfo.RegistrationPrep> sites, E element, Class<?> annotatedClass, MetricUtil.LookupResult<? extends Annotation> lookupResult, Executable executable) {
        Annotation annotation = lookupResult.getAnnotation();
        MetricAnnotationInfo.RegistrationPrep registrationPrep = MetricAnnotationInfo.RegistrationPrep.create(annotation, element, annotatedClass, lookupResult.getType(), executable);
        sites.add(registrationPrep);
    }

    private void registerMetricsForAnnotatedSites() {
        MetricRegistry registry = MetricsCdiExtension.getMetricRegistry();
        List.of(this.annotatedSites, LEGACY_ANNOTATED_SITES).forEach(sites -> {
            for (MetricAnnotationInfo.RegistrationPrep registrationPrep : sites) {
                org.eclipse.microprofile.metrics.Metric metric = registrationPrep.register(registry);
                this.workItemsManager.put(registrationPrep.executable(), registrationPrep.annotationType(), (Object)MetricWorkItem.create(new MetricID(registrationPrep.metricName(), registrationPrep.tags()), metric));
            }
            sites.clear();
        });
    }

    @Deprecated
    protected static void registerMetricsForAnnotatedSitesFromGrpcTest() {
        MetricRegistry registry = MetricsCdiExtension.getMetricRegistry();
        for (MetricAnnotationInfo.RegistrationPrep registrationPrep : LEGACY_ANNOTATED_SITES) {
            registrationPrep.register(registry);
        }
        LEGACY_ANNOTATED_SITES.clear();
    }

    protected void processManagedBean(ProcessManagedBean<?> pmb) {
        AnnotatedType type = pmb.getAnnotatedBeanClass();
        Class clazz = type.getJavaClass();
        if (type.isAnnotationPresent(Interceptor.class)) {
            LOGGER.log(Level.FINE, "Ignoring objects defined on type " + clazz.getName() + " because a CDI portable extension added @Interceptor to it dynamically");
            return;
        }
        Stream.of(type.getMethods(), type.getConstructors()).flatMap(Collection::stream).filter(annotatedCallable -> !Modifier.isPrivate(annotatedCallable.getJavaMember().getModifiers())).filter(annotatedCallable -> type.equals(annotatedCallable.getDeclaringType())).forEach(annotatedCallable -> METRIC_ANNOTATIONS.forEach(annotation -> MetricUtil.lookupAnnotations(type, annotatedCallable, annotation).forEach(lookupResult -> {
            Executable executable = (Executable)Executable.class.cast(annotatedCallable.getJavaMember());
            MetricsCdiExtension.recordAnnotatedSite(this.annotatedSites, executable, clazz, lookupResult, executable);
        })));
    }

    private static Tag[] tags(String[] tagStrings) {
        ArrayList<Tag> result = new ArrayList<Tag>();
        for (int i = 0; i < tagStrings.length; ++i) {
            int eq = tagStrings[i].indexOf("=");
            if (eq <= 0) continue;
            String tagName = tagStrings[i].substring(0, eq);
            String tagValue = tagStrings[i].substring(eq + 1);
            result.add(new Tag(tagName, tagValue));
        }
        return result.toArray(new Tag[result.size()]);
    }

    Iterable<MetricWorkItem> workItems(Executable executable, Class<? extends Annotation> annotationType) {
        return this.workItemsManager.workItems(executable, annotationType);
    }

    static Class<?> getRealClass(Object object) {
        Class<?> result = object.getClass();
        while (result.isSynthetic()) {
            result = result.getSuperclass();
        }
        return result;
    }

    static MetricRegistry getMetricRegistry() {
        return RegistryProducer.getDefaultRegistry();
    }

    static MetricRegistry getRegistryForSyntheticSimpleTimers() {
        return RegistryProducer.getBaseRegistry();
    }

    void before(@Observes BeforeBeanDiscovery discovery) {
        LOGGER.log(Level.FINE, () -> "Before bean discovery " + discovery);
        discovery.addAnnotatedType(RegistryProducer.class, RegistryProducer.class.getName());
        discovery.addAnnotatedType(MetricProducer.class, MetricProducer.class.getName());
        discovery.addAnnotatedType(InterceptorCounted.class, InterceptorCounted.class.getName());
        discovery.addAnnotatedType(InterceptorMetered.class, InterceptorMetered.class.getName());
        discovery.addAnnotatedType(InterceptorTimed.class, InterceptorTimed.class.getName());
        discovery.addAnnotatedType(InterceptorConcurrentGauge.class, InterceptorConcurrentGauge.class.getName());
        discovery.addAnnotatedType(InterceptorSimplyTimed.class, InterceptorSimplyTimed.class.getName());
        discovery.addAnnotatedType(InterceptorSyntheticSimplyTimed.class, InterceptorSyntheticSimplyTimed.class.getName());
        discovery.addAnnotatedType(SyntheticSimplyTimed.class, SyntheticSimplyTimed.class.getName());
        this.restEndpointsMetricsEnabled = this.restEndpointsMetricsEnabled();
    }

    protected void clearAnnotationInfo(@Observes AfterDeploymentValidation adv) {
        super.clearAnnotationInfo(adv);
        this.methodsWithSyntheticSimpleTimer.clear();
    }

    private void recordMetricAnnotatedClass(@Observes @WithAnnotations(value={Counted.class, Metered.class, Timed.class, ConcurrentGauge.class, SimplyTimed.class}) ProcessAnnotatedType<?> pat) {
        if (this.isConcreteNonInterceptor(pat)) {
            this.recordAnnotatedType(pat);
        }
    }

    private boolean checkCandidateMetricClass(ProcessAnnotatedType<?> pat) {
        AnnotatedType annotatedType = pat.getAnnotatedType();
        Class clazz = annotatedType.getJavaClass();
        if (annotatedType.isAnnotationPresent(Interceptor.class) || Modifier.isAbstract(clazz.getModifiers())) {
            LOGGER.log(Level.FINER, () -> "Ignoring " + clazz.getName() + " with annotations " + annotatedType.getAnnotations() + " for later processing: " + (Modifier.isAbstract(clazz.getModifiers()) ? "abstract " : "") + (annotatedType.isAnnotationPresent(Interceptor.class) ? "interceptor " : ""));
            return false;
        }
        LOGGER.log(Level.FINE, () -> "Accepting annotated type " + clazz.getName() + " for later bean processing");
        return true;
    }

    private void processInjectionPoints(@Observes ProcessInjectionPoint<?, ?> pip) {
        Type type = pip.getInjectionPoint().getType();
        if (type.equals(Counter.class) || type.equals(Histogram.class) || type.equals(Meter.class) || type.equals(Timer.class) || type.equals(SimpleTimer.class) || type.equals(org.eclipse.microprofile.metrics.ConcurrentGauge.class)) {
            pip.configureInjectionPoint().addQualifier((Annotation)VendorDefined.Literal.INSTANCE);
        }
    }

    private void recordSimplyTimedForRestResources(@Observes @WithAnnotations(value={GET.class, PUT.class, POST.class, HEAD.class, OPTIONS.class, DELETE.class, PATCH.class}) ProcessAnnotatedType<?> pat) {
        if (!this.checkCandidateMetricClass(pat) || !this.restEndpointsMetricsEnabled) {
            return;
        }
        LOGGER.log(Level.FINE, () -> "Processing @SyntheticSimplyTimed annotation for " + pat.getAnnotatedType().getJavaClass().getName());
        AnnotatedTypeConfigurator configurator = pat.configureAnnotatedType();
        Class clazz = configurator.getAnnotated().getJavaClass();
        HashSet methodsToRecord = new HashSet();
        configurator.filterMethods(method -> !Modifier.isPrivate(method.getJavaMember().getModifiers())).forEach(annotatedMethodConfigurator -> JAX_RS_ANNOTATIONS.forEach(jaxRsAnnotation -> {
            Method m;
            AnnotatedMethod annotatedMethod = annotatedMethodConfigurator.getAnnotated();
            if (annotatedMethod.isAnnotationPresent(jaxRsAnnotation) && clazz.equals((m = annotatedMethod.getJavaMember()).getDeclaringClass())) {
                LOGGER.log(Level.FINE, () -> String.format("Adding @SyntheticSimplyTimed to %s", m.toString()));
                annotatedMethodConfigurator.add((Annotation)SyntheticSimplyTimed.Literal.getInstance());
                methodsToRecord.add(m);
            }
        }));
        if (!methodsToRecord.isEmpty()) {
            this.methodsWithSyntheticSimpleTimer.put(clazz, methodsToRecord);
        }
    }

    static SimpleTimer syntheticSimpleTimer(Method method) {
        LOGGER.log(Level.FINE, () -> String.format("Registering synthetic SimpleTimer for %s#%s", method.getDeclaringClass().getName(), method.getName()));
        return MetricsCdiExtension.getRegistryForSyntheticSimpleTimers().simpleTimer(SYNTHETIC_SIMPLE_TIMER_METADATA, MetricsCdiExtension.syntheticSimpleTimerMetricTags(method));
    }

    private void registerAndSaveSyntheticSimpleTimer(Method method) {
        this.workItemsManager.put((Executable)method, SyntheticSimplyTimed.class, (Object)MetricWorkItem.create(SYNTHETIC_SIMPLE_TIMER_METADATA, (org.eclipse.microprofile.metrics.Metric)MetricsCdiExtension.syntheticSimpleTimer(method), MetricsCdiExtension.syntheticSimpleTimerMetricTags(method)));
    }

    static MetricID syntheticSimpleTimerMetricID(Method method) {
        return new MetricID(SYNTHETIC_SIMPLE_TIMER_METRIC_NAME, MetricsCdiExtension.syntheticSimpleTimerMetricTags(method));
    }

    static Tag[] syntheticSimpleTimerMetricTags(Method method) {
        return new Tag[]{new Tag("class", method.getDeclaringClass().getName()), new Tag("method", MetricsCdiExtension.methodTagValueForSyntheticSimpleTimer(method))};
    }

    private static String methodTagValueForSyntheticSimpleTimer(Method method) {
        StringBuilder methodTagValue = new StringBuilder(method.getName());
        for (Parameter p : method.getParameters()) {
            methodTagValue.append("_").append(MetricsCdiExtension.prettyParamType(p));
        }
        return methodTagValue.toString();
    }

    private static String prettyParamType(Parameter parameter) {
        return parameter.getType().isArray() || parameter.isVarArgs() ? parameter.getType().getComponentType().getName() + "[]" : parameter.getType().getName();
    }

    protected void recordProducerFields(@Observes ProcessProducerField<? extends org.eclipse.microprofile.metrics.Metric, ?> ppf) {
        if (!this.isOwnProducerOrNonDefaultQualified(ppf.getBean(), MetricProducer.class)) {
            this.recordProducerField(ppf);
        }
    }

    protected void recordProducerMethods(@Observes ProcessProducerMethod<? extends org.eclipse.microprofile.metrics.Metric, ?> ppm) {
        if (!this.isOwnProducerOrNonDefaultQualified(ppm.getBean(), MetricProducer.class)) {
            this.recordProducerMethod(ppm);
        }
    }

    private <T extends org.eclipse.microprofile.metrics.Metric> void registerProducers(BeanManager bm) {
        LOGGER.log(Level.FINE, () -> "registerProducers");
        Errors problems = this.errors.collect();
        this.errors = null;
        if (problems.hasFatal()) {
            throw new DeploymentException("Metrics module found issues with deployment: " + problems.toString());
        }
        MetricRegistry registry = MetricsCdiExtension.getMetricRegistry();
        this.producers().forEach((bean, annotatedMember) -> {
            Metric metric = (Metric)annotatedMember.getAnnotation(Metric.class);
            if (metric != null) {
                String metricName = MetricUtil.getMetricName(new AnnotatedElementWrapper((AnnotatedMember<?>)annotatedMember), annotatedMember.getDeclaringType().getJavaClass(), MetricUtil.MatchingType.METHOD, metric.name(), metric.absolute());
                org.eclipse.microprofile.metrics.Metric instance = (org.eclipse.microprofile.metrics.Metric)MetricsCdiExtension.getReference(bm, annotatedMember.getBaseType(), bean);
                Metadata md = Metadata.builder().withName(metricName).withDisplayName(metric.displayName()).withDescription(metric.description()).withType(MetricsCdiExtension.getMetricType(instance)).withUnit(metric.unit()).reusable(false).build();
                registry.register(md, instance);
            }
        });
        this.producers().clear();
    }

    private void collectSyntheticSimpleTimerMetric(@Observes ProcessManagedBean<?> pmb) {
        AnnotatedType type = pmb.getAnnotatedBeanClass();
        Class clazz = type.getJavaClass();
        if (!this.methodsWithSyntheticSimpleTimer.containsKey(clazz)) {
            return;
        }
        LOGGER.log(Level.FINE, () -> "Processing synthetic SimplyTimed annotations for " + clazz.getName());
        this.syntheticSimpleTimerClassesProcessed.add(clazz);
        this.syntheticSimpleTimersToRegister.addAll((Collection<Method>)this.methodsWithSyntheticSimpleTimer.get(clazz));
    }

    private void registerSyntheticSimpleTimerMetrics() {
        this.syntheticSimpleTimersToRegister.forEach(this::registerAndSaveSyntheticSimpleTimer);
        if (LOGGER.isLoggable(Level.FINE)) {
            HashSet syntheticSimpleTimerAnnotatedClassesIgnored = new HashSet(this.methodsWithSyntheticSimpleTimer.keySet());
            syntheticSimpleTimerAnnotatedClassesIgnored.removeAll(this.syntheticSimpleTimerClassesProcessed);
            if (!syntheticSimpleTimerAnnotatedClassesIgnored.isEmpty()) {
                LOGGER.log(Level.FINE, () -> "Classes with synthetic SimplyTimer annotations added that were not processed, probably because they were vetoed:" + syntheticSimpleTimerAnnotatedClassesIgnored.toString());
            }
        }
        this.syntheticSimpleTimerClassesProcessed.clear();
        this.syntheticSimpleTimersToRegister.clear();
    }

    boolean restEndpointsMetricsEnabled() {
        try {
            return MetricsCdiExtension.chooseRestEndpointsSetting(((Config)ConfigProvider.getConfig()).get("metrics"));
        }
        catch (Throwable t) {
            LOGGER.log(Level.WARNING, "Error looking up config setting for enabling REST endpoints SimpleTimer metrics; reporting 'false'", t);
            return false;
        }
    }

    protected Routing.Builder registerService(@Observes @Priority(value=1010) @Initialized(value=ApplicationScoped.class) Object adv, BeanManager bm, ServerCdiExtension server) {
        Routing.Builder defaultRouting = super.registerService(adv, bm, server);
        MetricsSupport metricsSupport = (MetricsSupport)this.serviceSupport();
        RegistryProducer.clearApplicationRegistry();
        this.registerMetricsForAnnotatedSites();
        this.registerAnnotatedGauges(bm);
        this.registerSyntheticSimpleTimerMetrics();
        this.registerProducers(bm);
        HashSet<String> vendorMetricsAdded = new HashSet<String>();
        vendorMetricsAdded.add("@default");
        Config config = MpConfig.toHelidonConfig((org.eclipse.microprofile.config.Config)ConfigProvider.getConfig()).get("metrics");
        ((List)config.get("vendor-metrics-routings").asList(String.class).orElseGet(List::of)).forEach(routeName -> {
            if (!vendorMetricsAdded.contains(routeName)) {
                metricsSupport.configureVendorMetrics(routeName, (Routing.Rules)server.serverNamedRoutingBuilder(routeName));
                vendorMetricsAdded.add((String)routeName);
            }
        });
        Contexts.globalContext().register((Object)RegistryFactory.getInstance());
        return defaultRouting;
    }

    private static boolean chooseRestEndpointsSetting(Config metricsConfig) {
        ConfigValue explicitRestEndpointsSetting = metricsConfig.get(REST_ENDPOINTS_METRIC_ENABLED_PROPERTY_NAME).asBoolean();
        boolean result = (Boolean)explicitRestEndpointsSetting.orElse((Object)false);
        if (explicitRestEndpointsSetting.isPresent()) {
            LOGGER.log(Level.FINE, () -> String.format("Support for MP REST.request metric and annotation handling explicitly set to %b in configuration", explicitRestEndpointsSetting.get()));
        } else {
            LOGGER.log(Level.FINE, () -> String.format("Support for MP REST.request metric and annotation handling defaulted to %b", false));
        }
        return result;
    }

    private static <T extends org.eclipse.microprofile.metrics.Metric> MetricType getMetricType(T metric) {
        Class<?> clazz = metric.getClass();
        do {
            Optional<Class> optionalClass;
            if (!(optionalClass = Arrays.stream(clazz.getInterfaces()).filter(org.eclipse.microprofile.metrics.Metric.class::isAssignableFrom).findFirst()).isPresent()) continue;
            clazz = optionalClass.get();
            break;
        } while ((clazz = clazz.getSuperclass()) != null);
        return MetricType.from(clazz == null ? metric.getClass() : clazz);
    }

    private void recordAnnotatedGaugeSite(@Observes ProcessManagedBean<?> pmb) {
        AnnotatedType type = pmb.getAnnotatedBeanClass();
        Class clazz = type.getJavaClass();
        LOGGER.log(Level.FINE, () -> "recordAnnotatedGaugeSite for class " + clazz);
        LOGGER.log(Level.FINE, () -> "Processing annotations for " + clazz.getName());
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return;
        }
        for (AnnotatedMethod method : type.getMethods()) {
            Gauge gaugeAnnotation;
            String explicitGaugeName;
            Method javaMethod = method.getJavaMember();
            if (!javaMethod.getDeclaringClass().equals(clazz) || Modifier.isPrivate(javaMethod.getModifiers()) || !method.isAnnotationPresent(Gauge.class)) continue;
            Class scopeAnnotation = pmb.getBean().getScope();
            if (scopeAnnotation == RequestScoped.class) {
                this.errors.fatal((Object)clazz, "Cannot configure @Gauge on a request scoped bean");
                return;
            }
            if (scopeAnnotation != ApplicationScoped.class && type.getAnnotation(Singleton.class) == null && ConfigProvider.getConfig().getOptionalValue("metrics.warn-dependent", Boolean.class).orElse(true).booleanValue()) {
                LOGGER.warning("@Gauge is configured on a bean " + clazz.getName() + " that is neither ApplicationScoped nor Singleton. This is most likely a bug. You may set 'metrics.warn-dependent' configuration option to 'false' to remove this warning.");
            }
            String gaugeNameSuffix = (explicitGaugeName = (gaugeAnnotation = (Gauge)method.getAnnotation(Gauge.class)).name()).length() > 0 ? explicitGaugeName : javaMethod.getName();
            String gaugeName = gaugeAnnotation.absolute() ? gaugeNameSuffix : String.format("%s.%s", clazz.getName(), gaugeNameSuffix);
            this.annotatedGaugeSites.put(new MetricID(gaugeName, MetricsCdiExtension.tags(gaugeAnnotation.tags())), method);
            LOGGER.log(Level.FINE, () -> String.format("Recorded annotated gauge with name %s", gaugeName));
        }
    }

    private void registerAnnotatedGauges(BeanManager bm) {
        LOGGER.log(Level.FINE, () -> "registerGauges");
        MetricRegistry registry = MetricsCdiExtension.getMetricRegistry();
        ArrayList gaugeProblems = new ArrayList();
        this.annotatedGaugeSites.entrySet().forEach(gaugeSite -> {
            LOGGER.log(Level.FINE, () -> "gaugeSite " + gaugeSite.toString());
            MetricID gaugeID = (MetricID)gaugeSite.getKey();
            AnnotatedMethod site = (AnnotatedMethod)gaugeSite.getValue();
            try {
                DelegatingGauge<?> dg = this.buildDelegatingGauge(gaugeID.getName(), site, bm);
                Gauge gaugeAnnotation = (Gauge)site.getAnnotation(Gauge.class);
                Metadata md = Metadata.builder().withName(gaugeID.getName()).withDisplayName(gaugeAnnotation.displayName()).withDescription(gaugeAnnotation.description()).withType(MetricType.GAUGE).withUnit(gaugeAnnotation.unit()).reusable(false).build();
                LOGGER.log(Level.FINE, () -> String.format("Registering gauge with metadata %s", md.toString()));
                registry.register(md, dg, gaugeID.getTagsAsList().toArray(new Tag[0]));
            }
            catch (Throwable t) {
                gaugeProblems.add(new IllegalArgumentException(String.format("Error processing @Gauge annotation on %s#%s: %s", site.getJavaMember().getDeclaringClass().getName(), site.getJavaMember().getName(), t.getMessage()), t));
            }
        });
        if (!gaugeProblems.isEmpty()) {
            throw new RuntimeException("Could not process one or more @Gauge annotations" + gaugeProblems);
        }
        this.annotatedGaugeSites.clear();
    }

    private DelegatingGauge<?> buildDelegatingGauge(String gaugeName, AnnotatedMethod<?> site, BeanManager bm) {
        Bean bean = (Bean)bm.getBeans(site.getJavaMember().getDeclaringClass(), new Annotation[0]).stream().findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot find bean for annotated gauge " + gaugeName));
        Class<?> returnType = site.getJavaMember().getReturnType();
        return DelegatingGauge.newInstance(site.getJavaMember(), MetricsCdiExtension.getReference(bm, bean.getBeanClass(), bean), returnType);
    }

    private static Class<? extends Number> typeToNumber(Class<?> clazz) {
        Class narrowedReturnType;
        if (Byte.TYPE.isAssignableFrom(clazz)) {
            narrowedReturnType = Byte.class;
        } else if (Short.TYPE.isAssignableFrom(clazz)) {
            narrowedReturnType = Short.class;
        } else if (Integer.TYPE.isAssignableFrom(clazz)) {
            narrowedReturnType = Integer.class;
        } else if (Long.TYPE.isAssignableFrom(clazz)) {
            narrowedReturnType = Long.class;
        } else if (Float.TYPE.isAssignableFrom(clazz)) {
            narrowedReturnType = Float.class;
        } else if (Double.TYPE.isAssignableFrom(clazz)) {
            narrowedReturnType = Double.class;
        } else if (Number.class.isAssignableFrom(clazz)) {
            narrowedReturnType = clazz;
        } else {
            throw new IllegalArgumentException("Annotated gauge type must extend or be assignment-compatible with Number but is " + clazz.getName());
        }
        return narrowedReturnType;
    }

    private static class MetricInfo<T extends org.eclipse.microprofile.metrics.Metric> {
        private final MetricID metricID;
        private final T metric;

        MetricInfo(MetricID metricID, T metric) {
            this.metricID = metricID;
            this.metric = metric;
        }
    }

    static class MetricWorkItem {
        private final MetricID metricID;
        private final org.eclipse.microprofile.metrics.Metric metric;

        static <T extends org.eclipse.microprofile.metrics.Metric> MetricWorkItem create(Metadata metadata, org.eclipse.microprofile.metrics.Metric metric, Tag ... tags) {
            MetricID metricID = new MetricID(metadata.getName(), tags);
            return new MetricWorkItem(metricID, metric);
        }

        static <T extends org.eclipse.microprofile.metrics.Metric> MetricWorkItem create(MetricID metricID, org.eclipse.microprofile.metrics.Metric metric) {
            return new MetricWorkItem(metricID, metric);
        }

        private MetricWorkItem(MetricID metricID, org.eclipse.microprofile.metrics.Metric metric) {
            this.metricID = metricID;
            this.metric = metric;
        }

        MetricID metricID() {
            return this.metricID;
        }

        org.eclipse.microprofile.metrics.Metric metric() {
            return this.metric;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetricWorkItem that = (MetricWorkItem)o;
            return this.metricID.equals((Object)that.metricID) && this.metric.equals(that.metric);
        }

        public int hashCode() {
            return Objects.hash(this.metricID, this.metric);
        }

        public String toString() {
            return new StringJoiner(", " + System.lineSeparator(), MetricWorkItem.class.getSimpleName() + "[", "]").add("metricID=" + this.metricID).add("metric=" + this.metric).toString();
        }
    }

    static class AnnotatedElementWrapper
    implements AnnotatedElement,
    Member {
        private final AnnotatedMember<?> annotatedMember;

        AnnotatedElementWrapper(AnnotatedMember<?> annotatedMember) {
            this.annotatedMember = annotatedMember;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
            return this.annotatedMember.isAnnotationPresent(annotationClass);
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return (T)this.annotatedMember.getAnnotation(annotationClass);
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.annotatedMember.getAnnotations().toArray(new Annotation[0]);
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return this.getAnnotations();
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this.annotatedMember.getDeclaringType().getJavaClass();
        }

        @Override
        public String getName() {
            return this.annotatedMember.getJavaMember().getName();
        }

        @Override
        public int getModifiers() {
            return this.annotatedMember.getJavaMember().getModifiers();
        }

        @Override
        public boolean isSynthetic() {
            return this.annotatedMember.getJavaMember().isSynthetic();
        }
    }
}

