/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import io.helidon.metrics.api.HelidonMetric;
import io.helidon.microprofile.metrics.MetricsCdiExtension;
import io.helidon.servicecommon.restcdi.HelidonInterceptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;

abstract class MetricsInterceptorBase<M extends Metric>
extends HelidonInterceptor.Base<MetricsCdiExtension.MetricWorkItem> {
    static final Logger LOGGER = Logger.getLogger(MetricsInterceptorBase.class.getName());
    private final Class<? extends Annotation> annotationType;
    private final Class<M> metricType;
    @Inject
    private MetricsCdiExtension extension;
    @Inject
    private MetricRegistry registry;

    MetricsInterceptorBase(Class<? extends Annotation> annotationType, Class<M> metricType) {
        this.annotationType = annotationType;
        this.metricType = metricType;
    }

    public Iterable<MetricsCdiExtension.MetricWorkItem> workItems(Executable executable) {
        return this.extension.workItems(executable, this.annotationType);
    }

    public void preInvocation(InvocationContext context, MetricsCdiExtension.MetricWorkItem workItem) {
        this.verifyMetric(context, workItem, ActionType.PREINVOKE);
        this.preInvoke((Metric)this.metricType.cast(workItem.metric()));
    }

    void verifyMetric(InvocationContext context, MetricsCdiExtension.MetricWorkItem workItem, ActionType actionType) {
        Metric metric = workItem.metric();
        if (HelidonMetric.isMarkedAsDeleted((Metric)metric)) {
            throw new IllegalStateException("Attempt to use previously-removed metric" + workItem.metricID());
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, String.format("%s (%s) is accepting %s %s for processing on %s triggered by @%s", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), actionType, workItem.metric().getClass().getSimpleName(), workItem.metricID(), context.getMethod() != null ? context.getMethod() : context.getConstructor(), this.annotationType.getSimpleName()}));
        }
    }

    abstract void preInvoke(M var1);

    static abstract class WithPostCompletion<T extends Metric>
    extends MetricsInterceptorBase<T>
    implements HelidonInterceptor.WithPostCompletion<MetricsCdiExtension.MetricWorkItem> {
        private final Class<T> metricType;

        WithPostCompletion(Class<? extends Annotation> annotationType, Class<T> metricType) {
            super(annotationType, metricType);
            this.metricType = metricType;
        }

        public void postCompletion(InvocationContext context, Throwable throwable, MetricsCdiExtension.MetricWorkItem workItem) {
            this.verifyMetric(context, workItem, ActionType.COMPLETE);
            this.postComplete((Metric)this.metricType.cast(workItem.metric()));
        }

        abstract void postComplete(T var1);
    }

    static enum ActionType {
        PREINVOKE("preinvoke"),
        COMPLETE("complete");

        private final String label;

        private ActionType(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

