/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import io.helidon.microprofile.metrics.MetricUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetadataBuilder;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.ConcurrentGauge;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Metered;
import org.eclipse.microprofile.metrics.annotation.SimplyTimed;
import org.eclipse.microprofile.metrics.annotation.Timed;

class MetricAnnotationInfo<A extends Annotation, T extends Metric> {
    static final Map<Class<? extends Annotation>, MetricType> ANNOTATION_TYPE_TO_METRIC_TYPE = Map.of(ConcurrentGauge.class, MetricType.CONCURRENT_GAUGE, Counted.class, MetricType.COUNTER, Metered.class, MetricType.METERED, SimplyTimed.class, MetricType.SIMPLE_TIMER, Timed.class, MetricType.TIMER);
    static final Map<Class<? extends Annotation>, MetricAnnotationInfo<?, ?>> ANNOTATION_TYPE_TO_INFO = Map.of(Counted.class, new MetricAnnotationInfo<Counted, Counter>(Counted.class, Counted::name, Counted::absolute, Counted::description, Counted::displayName, Counted::unit, Counted::tags, MetricRegistry::counter, MetricType.COUNTER), Metered.class, new MetricAnnotationInfo<Metered, Meter>(Metered.class, Metered::name, Metered::absolute, Metered::description, Metered::displayName, Metered::unit, Metered::tags, MetricRegistry::meter, MetricType.METERED), Timed.class, new MetricAnnotationInfo<Timed, Timer>(Timed.class, Timed::name, Timed::absolute, Timed::description, Timed::displayName, Timed::unit, Timed::tags, MetricRegistry::timer, MetricType.TIMER), ConcurrentGauge.class, new MetricAnnotationInfo<ConcurrentGauge, org.eclipse.microprofile.metrics.ConcurrentGauge>(ConcurrentGauge.class, ConcurrentGauge::name, ConcurrentGauge::absolute, ConcurrentGauge::description, ConcurrentGauge::displayName, ConcurrentGauge::unit, ConcurrentGauge::tags, MetricRegistry::concurrentGauge, MetricType.CONCURRENT_GAUGE), SimplyTimed.class, new MetricAnnotationInfo<SimplyTimed, SimpleTimer>(SimplyTimed.class, SimplyTimed::name, SimplyTimed::absolute, SimplyTimed::description, SimplyTimed::displayName, SimplyTimed::unit, SimplyTimed::tags, MetricRegistry::simpleTimer, MetricType.SIMPLE_TIMER));
    private final Class<A> annotationClass;
    private final Function<A, String> annotationNameFunction;
    private final Function<A, Boolean> annotationAbsoluteFunction;
    private final Function<A, String> annotationDescriptorFunction;
    private final Function<A, String> annotationDisplayNameFunction;
    private final Function<A, String> annotationUnitsFunction;
    private final Function<A, String[]> annotationTagsFunction;
    private final Registration<T> registerFunction;
    private final MetricType metricType;

    MetricAnnotationInfo(Class<A> annotationClass, Function<A, String> annotationNameFunction, Function<A, Boolean> annotationAbsoluteFunction, Function<A, String> annotationDescriptorFunction, Function<A, String> annotationDisplayNameFunction, Function<A, String> annotationUnitsFunction, Function<A, String[]> annotationTagsFunction, Registration<T> registerFunction, MetricType metricType) {
        this.annotationClass = annotationClass;
        this.annotationNameFunction = annotationNameFunction;
        this.annotationAbsoluteFunction = annotationAbsoluteFunction;
        this.annotationDescriptorFunction = annotationDescriptorFunction;
        this.annotationDisplayNameFunction = annotationDisplayNameFunction;
        this.annotationUnitsFunction = annotationUnitsFunction;
        this.annotationTagsFunction = annotationTagsFunction;
        this.registerFunction = registerFunction;
        this.metricType = metricType;
    }

    static Tag[] tags(String[] tagStrings) {
        ArrayList<Tag> result = new ArrayList<Tag>();
        for (String tagString : tagStrings) {
            int eq = tagString.indexOf("=");
            if (eq <= 0) continue;
            String tagName = tagString.substring(0, eq);
            String tagValue = tagString.substring(eq + 1);
            result.add(new Tag(tagName, tagValue));
        }
        return result.toArray(new Tag[0]);
    }

    Class<A> annotationClass() {
        return this.annotationClass;
    }

    A annotationOnMethod(AnnotatedElement ae) {
        return ae.getAnnotation(this.annotationClass);
    }

    String name(Annotation a) {
        return this.annotationNameFunction.apply((Annotation)this.annotationClass.cast(a));
    }

    boolean absolute(Annotation a) {
        return this.annotationAbsoluteFunction.apply((Annotation)this.annotationClass.cast(a));
    }

    String displayName(Annotation a) {
        return this.annotationDisplayNameFunction.apply((Annotation)this.annotationClass.cast(a));
    }

    String description(Annotation a) {
        return this.annotationDescriptorFunction.apply((Annotation)this.annotationClass.cast(a));
    }

    String unit(Annotation a) {
        return this.annotationUnitsFunction.apply((Annotation)this.annotationClass.cast(a));
    }

    Tag[] tags(Annotation a) {
        return MetricAnnotationInfo.tags(this.annotationTagsFunction.apply((Annotation)this.annotationClass.cast(a)));
    }

    MetricType metricType() {
        return this.metricType;
    }

    @FunctionalInterface
    static interface Registration<T extends Metric> {
        public T register(MetricRegistry var1, Metadata var2, Tag ... var3);
    }

    static class RegistrationPrep {
        private final String metricName;
        private final Metadata metadata;
        private final Tag[] tags;
        private final Registration<?> registration;
        private final Executable executable;
        private final Class<? extends Annotation> annotationType;

        static <A extends Annotation, E extends Member & AnnotatedElement, T extends Metric> RegistrationPrep create(A annotation, E annotatedElement, Class<?> clazz, MetricUtil.MatchingType matchingType, Executable executable) {
            String candidateDisplayName;
            MetricAnnotationInfo<?, ?> info = ANNOTATION_TYPE_TO_INFO.get(annotation.annotationType());
            if (info == null || !info.annotationClass().isInstance(annotation)) {
                return null;
            }
            String metricName = MetricUtil.getMetricName(annotatedElement, clazz, matchingType, info.name(annotation), info.absolute(annotation));
            MetadataBuilder metadataBuilder = Metadata.builder().withName(metricName).withType(ANNOTATION_TYPE_TO_METRIC_TYPE.get(annotation.annotationType())).withUnit(info.unit(annotation).trim());
            String candidateDescription = info.description(annotation);
            if (candidateDescription != null && !candidateDescription.trim().isEmpty()) {
                metadataBuilder.withDescription(candidateDescription.trim());
            }
            if ((candidateDisplayName = info.displayName(annotation)) != null && !candidateDisplayName.trim().isEmpty()) {
                metadataBuilder.withDisplayName(candidateDisplayName.trim());
            }
            return new RegistrationPrep(metricName, metadataBuilder.build(), info.tags(annotation), info.registerFunction, executable, annotation.annotationType());
        }

        private RegistrationPrep(String metricName, Metadata metadata, Tag[] tags, Registration<?> registration, Executable executable, Class<? extends Annotation> annotationType) {
            this.metricName = metricName;
            this.metadata = metadata;
            this.tags = tags;
            this.registration = registration;
            this.executable = executable;
            this.annotationType = annotationType;
        }

        String metricName() {
            return this.metricName;
        }

        Tag[] tags() {
            return this.tags;
        }

        Executable executable() {
            return this.executable;
        }

        Class<? extends Annotation> annotationType() {
            return this.annotationType;
        }

        Metadata metadata() {
            return this.metadata;
        }

        Metric register(MetricRegistry registry) {
            return this.registration.register(registry, this.metadata, this.tags);
        }
    }
}

