/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import io.helidon.microprofile.metrics.MetricsCdiExtension;
import io.helidon.microprofile.metrics.RegistryProducer;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedMember;
import jakarta.enterprise.inject.spi.AnnotatedType;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;

final class MetricUtil {
    private static final Logger LOGGER = Logger.getLogger(MetricUtil.class.getName());

    private MetricUtil() {
    }

    static <A extends Annotation> List<LookupResult<A>> lookupAnnotations(AnnotatedType<?> annotatedType, AnnotatedMember<?> annotatedMember, Class<A> annotClass, Map<Class<?>, MetricsCdiExtension.StereotypeMetricsInfo> stereotypeTypes) {
        List<LookupResult<A>> result = MetricUtil.lookupAnnotations(annotatedMember, annotClass, stereotypeTypes);
        if (result.isEmpty()) {
            result = MetricUtil.lookupAnnotations(annotatedType, annotClass, stereotypeTypes);
        }
        return result;
    }

    static <A extends Annotation> List<LookupResult<A>> lookupAnnotations(Annotated annotated, Class<A> annotClass, Map<Class<?>, MetricsCdiExtension.StereotypeMetricsInfo> stereotypeMetricsInfo) {
        return MetricUtil.metricsAnnotationsOnElement(annotated, stereotypeMetricsInfo).filter(annotClass::isInstance).map(annotation -> new LookupResult<Annotation>(MetricUtil.matchingType(annotated), (Annotation)annotClass.cast(annotation))).collect(Collectors.toList());
    }

    static Stream<Annotation> metricsAnnotationsOnElement(Annotated annotated, Map<Class<?>, MetricsCdiExtension.StereotypeMetricsInfo> stereotypeMetricsInfo) {
        return Stream.concat(annotated.getAnnotations().stream().filter(a -> MetricsCdiExtension.ALL_METRIC_ANNOTATIONS.contains(a.annotationType())), annotated.getAnnotations().stream().filter(a -> stereotypeMetricsInfo.containsKey(a.annotationType())).flatMap(a -> ((MetricsCdiExtension.StereotypeMetricsInfo)stereotypeMetricsInfo.get(a.annotationType())).metricsAnnotations().stream()));
    }

    static <T extends Annotation> Stream<T> metricsAnnotationsOnElement(Annotated annotated, Class<T> annotationType, Map<Class<?>, MetricsCdiExtension.StereotypeMetricsInfo> stereotypeMetricsInfo) {
        return MetricUtil.metricsAnnotationsOnElement(annotated, stereotypeMetricsInfo).filter(annotationType::isInstance).map(annotationType::cast);
    }

    static <E extends Member & AnnotatedElement> String getMetricName(Member element, Class<?> clazz, MatchingType matchingType, String explicitName, boolean absolute) {
        Object result;
        if (matchingType == MatchingType.METHOD) {
            Object object = result = explicitName == null || explicitName.isEmpty() ? MetricUtil.getElementName(element, clazz) : explicitName;
            if (!absolute) {
                Class<?> declaringClass = clazz;
                if (element instanceof Method) {
                    List<Method> methods = Arrays.asList(declaringClass.getDeclaredMethods());
                    while (!methods.contains(element)) {
                        declaringClass = declaringClass.getSuperclass();
                        methods = Arrays.asList(declaringClass.getDeclaredMethods());
                    }
                }
                result = declaringClass.getName() + "." + (String)result;
            }
        } else if (matchingType == MatchingType.CLASS) {
            if (explicitName == null || explicitName.isEmpty()) {
                result = MetricUtil.getElementName(element, clazz);
                if (!absolute) {
                    result = clazz.getName() + "." + (String)result;
                }
            } else {
                if (absolute) {
                    LOGGER.warning(() -> "Attribute 'absolute=true' in metric annotation ignored at class level");
                }
                result = clazz.getPackage().getName() + "." + explicitName + "." + MetricUtil.getElementName(element, clazz);
            }
        } else {
            throw new InternalError("Unknown matching type");
        }
        return result;
    }

    private static MetricRegistry getMetricRegistry() {
        return RegistryProducer.getDefaultRegistry();
    }

    static String getElementName(Member element, Class<?> clazz) {
        return element instanceof Constructor ? clazz.getSimpleName() : element.getName();
    }

    static Tag[] tags(String[] tagStrings) {
        ArrayList<Tag> result = new ArrayList<Tag>();
        for (int i = 0; i < tagStrings.length; ++i) {
            int eq = tagStrings[i].indexOf("=");
            if (eq <= 0) continue;
            String tagName = tagStrings[i].substring(0, eq);
            String tagValue = tagStrings[i].substring(eq + 1);
            result.add(new Tag(tagName, tagValue));
        }
        return result.toArray(new Tag[result.size()]);
    }

    private static MatchingType matchingType(Annotated annotated) {
        return annotated instanceof AnnotatedMember ? (((AnnotatedMember)annotated).getJavaMember() instanceof Executable ? MatchingType.METHOD : MatchingType.CLASS) : MatchingType.CLASS;
    }

    static enum MatchingType {
        METHOD,
        CLASS;

    }

    static class LookupResult<A extends Annotation> {
        private final MatchingType type;
        private final A annotation;

        LookupResult(MatchingType type, A annotation) {
            this.type = type;
            this.annotation = annotation;
        }

        MatchingType getType() {
            return this.type;
        }

        A getAnnotation() {
            return this.annotation;
        }
    }
}

