/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import io.helidon.common.Errors;
import io.helidon.common.context.Contexts;
import io.helidon.config.Config;
import io.helidon.config.ConfigSources;
import io.helidon.config.ConfigValue;
import io.helidon.config.mp.MpConfig;
import io.helidon.metrics.api.RegistryFactory;
import io.helidon.metrics.serviceapi.MetricsSupport;
import io.helidon.microprofile.metrics.BasicMetricWorkItem;
import io.helidon.microprofile.metrics.DelegatingGauge;
import io.helidon.microprofile.metrics.InterceptorConcurrentGauge;
import io.helidon.microprofile.metrics.InterceptorCounted;
import io.helidon.microprofile.metrics.InterceptorMetered;
import io.helidon.microprofile.metrics.InterceptorSimplyTimed;
import io.helidon.microprofile.metrics.InterceptorSyntheticRestRequest;
import io.helidon.microprofile.metrics.InterceptorTimed;
import io.helidon.microprofile.metrics.MetricAnnotationDiscovery;
import io.helidon.microprofile.metrics.MetricAnnotationDiscoveryBase;
import io.helidon.microprofile.metrics.MetricAnnotationInfo;
import io.helidon.microprofile.metrics.MetricProducer;
import io.helidon.microprofile.metrics.MetricUtil;
import io.helidon.microprofile.metrics.MetricWorkItem;
import io.helidon.microprofile.metrics.RegistryProducer;
import io.helidon.microprofile.metrics.SyntheticRestRequest;
import io.helidon.microprofile.metrics.SyntheticRestRequestWorkItem;
import io.helidon.microprofile.metrics.TypeFilteredIterable;
import io.helidon.microprofile.metrics.spi.MetricAnnotationDiscoveryObserver;
import io.helidon.microprofile.metrics.spi.MetricRegistrationObserver;
import io.helidon.microprofile.server.ServerCdiExtension;
import io.helidon.servicecommon.restcdi.HelidonRestCdiExtension;
import io.helidon.webserver.Routing;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Stereotype;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedCallable;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessManagedBean;
import jakarta.enterprise.inject.spi.WithAnnotations;
import jakarta.enterprise.inject.spi.configurator.AnnotatedConstructorConfigurator;
import jakarta.enterprise.inject.spi.configurator.AnnotatedMethodConfigurator;
import jakarta.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.inject.Singleton;
import jakarta.interceptor.Interceptor;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.annotation.ConcurrentGauge;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Gauge;
import org.eclipse.microprofile.metrics.annotation.Metered;
import org.eclipse.microprofile.metrics.annotation.SimplyTimed;
import org.eclipse.microprofile.metrics.annotation.Timed;

public class MetricsCdiExtension
extends HelidonRestCdiExtension<MetricsSupport> {
    private static final Logger LOGGER = Logger.getLogger(MetricsCdiExtension.class.getName());
    static final Set<Class<? extends Annotation>> ALL_METRIC_ANNOTATIONS = Set.of(Counted.class, Metered.class, Timed.class, ConcurrentGauge.class, SimplyTimed.class, Gauge.class);
    private static final Map<Class<? extends Annotation>, AnnotationLiteral<?>> INTERCEPTED_METRIC_ANNOTATIONS = Map.of(Counted.class, InterceptorCounted.binding(), Metered.class, InterceptorMetered.binding(), Timed.class, InterceptorTimed.binding(), ConcurrentGauge.class, InterceptorConcurrentGauge.binding(), SimplyTimed.class, InterceptorSimplyTimed.binding());
    private static final List<Class<? extends Annotation>> JAX_RS_ANNOTATIONS = Arrays.asList(GET.class, PUT.class, POST.class, HEAD.class, OPTIONS.class, DELETE.class, PATCH.class);
    private static final Set<Class<? extends Annotation>> METRIC_ANNOTATIONS_ON_ANY_ELEMENT = new HashSet<Class<? extends Annotation>>(ALL_METRIC_ANNOTATIONS){
        {
            this.remove(Gauge.class);
        }
    };
    static final String REST_ENDPOINTS_METRIC_ENABLED_PROPERTY_NAME = "rest-request.enabled";
    private static final boolean REST_ENDPOINTS_METRIC_ENABLED_DEFAULT_VALUE = false;
    static final String SYNTHETIC_SIMPLE_TIMER_METRIC_NAME = "REST.request";
    static final String SYNTHETIC_SIMPLE_TIMER_METRIC_UNMAPPED_EXCEPTION_NAME = "REST.request.unmappedException.total";
    static final Metadata SYNTHETIC_SIMPLE_TIMER_METADATA = Metadata.builder().withName("REST.request").withDisplayName("Total Requests and Response Time").withDescription("The number of invocations and total response time of this RESTful resource method since the start of the server. The metric will not record the elapsed time nor count of a REST request if it resulted in an unmapped exception. Also tracks the highest recorded time duration within the previous completed full minute and lowest recorded time duration within the previous completed full minute.").withType(MetricType.SIMPLE_TIMER).withUnit("nanoseconds").build();
    static final Metadata SYNTHETIC_SIMPLE_TIMER_UNMAPPED_EXCEPTION_METADATA = Metadata.builder().withName("REST.request.unmappedException.total").withDisplayName("Total Unmapped Exceptions count").withDescription("The total number of unmapped exceptions that occur from this RESTful resouce method since the start of the server.").withType(MetricType.COUNTER).withUnit("none").build();
    private boolean restEndpointsMetricsEnabled = false;
    private final Map<MetricID, AnnotatedMethod<?>> annotatedGaugeSites = new HashMap();
    private final List<MetricAnnotationInfo.RegistrationPrep> annotatedSites = new ArrayList<MetricAnnotationInfo.RegistrationPrep>();
    private Errors.Collector errors = Errors.collector();
    private final Map<Class<?>, Set<Method>> methodsWithRestRequestMetrics = new HashMap();
    private final Set<Class<?>> restRequestMetricsClassesProcessed = new HashSet();
    private final Set<Method> restRequestMetricsToRegister = new HashSet<Method>();
    private final HelidonRestCdiExtension.WorkItemsManager<MetricWorkItem> workItemsManager = HelidonRestCdiExtension.WorkItemsManager.create();
    private final List<MetricAnnotationDiscoveryObserver> metricAnnotationDiscoveryObservers = new ArrayList<MetricAnnotationDiscoveryObserver>();
    private final List<MetricRegistrationObserver> metricRegistrationObservers = new ArrayList<MetricRegistrationObserver>();
    private final Map<Executable, List<MetricAnnotationDiscovery>> metricAnnotationDiscoveriesByExecutable = new HashMap<Executable, List<MetricAnnotationDiscovery>>();
    private final Map<Class<?>, StereotypeMetricsInfo> stereotypeMetricsInfo = new HashMap();

    private static <T> T getReference(BeanManager bm, Type type, Bean<?> bean) {
        return (T)bm.getReference(bean, type, bm.createCreationalContext(bean));
    }

    public MetricsCdiExtension() {
        super(LOGGER, MetricsSupport::create, "metrics");
    }

    public void enroll(MetricAnnotationDiscoveryObserver metricAnnotationDiscoveryObserver) {
        this.metricAnnotationDiscoveryObservers.add(metricAnnotationDiscoveryObserver);
    }

    public void enroll(MetricRegistrationObserver metricRegistrationObserver) {
        this.metricRegistrationObservers.add(metricRegistrationObserver);
    }

    private static <E extends Member & AnnotatedElement> void recordAnnotatedSite(List<MetricAnnotationInfo.RegistrationPrep> sites, E element, Class<?> annotatedClass, MetricUtil.LookupResult<? extends Annotation> lookupResult, Executable executable) {
        Annotation annotation = lookupResult.getAnnotation();
        MetricAnnotationInfo.RegistrationPrep registrationPrep = MetricAnnotationInfo.RegistrationPrep.create(annotation, element, annotatedClass, lookupResult.getType(), executable);
        sites.add(registrationPrep);
    }

    private void registerMetricsForAnnotatedSites() {
        MetricRegistry registry = MetricsCdiExtension.getMetricRegistry();
        for (MetricAnnotationInfo.RegistrationPrep registrationPrep : this.annotatedSites) {
            this.metricAnnotationDiscoveriesByExecutable.get(registrationPrep.executable()).forEach(discovery -> {
                if (discovery.isActive()) {
                    Metric metric = registrationPrep.register(registry);
                    MetricID metricID = new MetricID(registrationPrep.metricName(), registrationPrep.tags());
                    this.metricRegistrationObservers.forEach(o -> o.onRegistration((MetricAnnotationDiscovery)discovery, registrationPrep.metadata(), metricID, metric));
                    this.workItemsManager.put(registrationPrep.executable(), registrationPrep.annotationType(), (Object)BasicMetricWorkItem.create(new MetricID(registrationPrep.metricName(), registrationPrep.tags()), metric));
                }
            });
        }
        this.annotatedSites.clear();
    }

    protected void processManagedBean(ProcessManagedBean<?> pmb) {
        AnnotatedType type = pmb.getAnnotatedBeanClass();
        Class clazz = type.getJavaClass();
        if (type.isAnnotationPresent(Interceptor.class)) {
            LOGGER.log(Level.FINE, "Ignoring objects defined on type " + clazz.getName() + " because a CDI portable extension added @Interceptor to it dynamically");
            return;
        }
        Stream.concat(type.getMethods().stream(), type.getConstructors().stream()).filter(annotatedCallable -> !Modifier.isPrivate(annotatedCallable.getJavaMember().getModifiers())).filter(annotatedCallable -> type.equals(annotatedCallable.getDeclaringType())).forEach(annotatedCallable -> METRIC_ANNOTATIONS_ON_ANY_ELEMENT.forEach(annotation -> MetricUtil.lookupAnnotations(type, annotatedCallable, annotation, this.stereotypeMetricsInfo).forEach(lookupResult -> {
            Executable executable = (Executable)annotatedCallable.getJavaMember();
            MetricsCdiExtension.recordAnnotatedSite(this.annotatedSites, executable, clazz, lookupResult, executable);
        })));
    }

    private static Tag[] tags(String[] tagStrings) {
        ArrayList<Tag> result = new ArrayList<Tag>();
        for (int i = 0; i < tagStrings.length; ++i) {
            int eq = tagStrings[i].indexOf("=");
            if (eq <= 0) continue;
            String tagName = tagStrings[i].substring(0, eq);
            String tagValue = tagStrings[i].substring(eq + 1);
            result.add(new Tag(tagName, tagValue));
        }
        return result.toArray(new Tag[0]);
    }

    Iterable<MetricWorkItem> workItems(Executable executable, Class<? extends Annotation> annotationType) {
        return this.workItemsManager.workItems(executable, annotationType);
    }

    <S extends MetricWorkItem> Iterable<S> workItems(Executable executable, Class<? extends Annotation> annotationType, Class<S> sClass) {
        return TypeFilteredIterable.create(this.workItems(executable, annotationType), sClass);
    }

    static Class<?> getRealClass(Object object) {
        Class<?> result = object.getClass();
        while (result.isSynthetic()) {
            result = result.getSuperclass();
        }
        return result;
    }

    static MetricRegistry getMetricRegistry() {
        return RegistryProducer.getDefaultRegistry();
    }

    static MetricRegistry getRegistryForSyntheticRestRequestMetrics() {
        return RegistryProducer.getBaseRegistry();
    }

    void before(@Observes BeforeBeanDiscovery discovery) {
        LOGGER.log(Level.FINE, () -> "Before bean discovery " + discovery);
        discovery.addAnnotatedType(RegistryProducer.class, RegistryProducer.class.getName());
        discovery.addAnnotatedType(MetricProducer.class, MetricProducer.class.getName());
        discovery.addAnnotatedType(InterceptorCounted.class, InterceptorCounted.class.getName());
        discovery.addAnnotatedType(InterceptorMetered.class, InterceptorMetered.class.getName());
        discovery.addAnnotatedType(InterceptorTimed.class, InterceptorTimed.class.getName());
        discovery.addAnnotatedType(InterceptorConcurrentGauge.class, InterceptorConcurrentGauge.class.getName());
        discovery.addAnnotatedType(InterceptorSimplyTimed.class, InterceptorSimplyTimed.class.getName());
        discovery.addAnnotatedType(InterceptorSyntheticRestRequest.class, InterceptorSyntheticRestRequest.class.getName());
        discovery.addAnnotatedType(SyntheticRestRequest.class, SyntheticRestRequest.class.getName());
        this.restEndpointsMetricsEnabled = this.restEndpointsMetricsEnabled();
    }

    public void clearAnnotationInfo(@Observes AfterDeploymentValidation adv) {
        super.clearAnnotationInfo(adv);
        this.methodsWithRestRequestMetrics.clear();
    }

    private void recordMetricAnnotatedClass(@Observes @Priority(value=2510) @WithAnnotations(value={Counted.class, Metered.class, Timed.class, ConcurrentGauge.class, SimplyTimed.class}) ProcessAnnotatedType<?> pat) {
        if (this.isConcreteNonInterceptor(pat)) {
            this.recordAnnotatedType(pat);
            this.recordStereotypes(pat);
            this.bindInterceptors(pat);
        }
    }

    private void bindInterceptors(ProcessAnnotatedType<?> pat) {
        AnnotatedTypeConfigurator annotatedTypeConfigurator = pat.configureAnnotatedType();
        this.bindInterceptorsAndRecordDiscoveries(annotatedTypeConfigurator, pat.configureAnnotatedType().constructors(), AnnotatedConstructorConfigurator::getAnnotated, AnnotatedConstructorConfigurator::add);
        this.bindInterceptorsAndRecordDiscoveries(annotatedTypeConfigurator, pat.configureAnnotatedType().methods(), AnnotatedMethodConfigurator::getAnnotated, AnnotatedMethodConfigurator::add);
    }

    private <T, C, A extends AnnotatedCallable<?>> void bindInterceptorsAndRecordDiscoveries(AnnotatedTypeConfigurator<T> annotatedTypeConfigurator, Iterable<? extends C> executableConfigurators, Function<C, A> configuratorAnnotatedGetter, BiFunction<C, Annotation, C> annotationAdder) {
        executableConfigurators.forEach(executableConfigurator -> {
            AnnotatedCallable annotatedCallable = (AnnotatedCallable)configuratorAnnotatedGetter.apply(executableConfigurator);
            Executable exec = annotatedCallable.getJavaMember() instanceof Executable ? (Executable)annotatedCallable.getJavaMember() : null;
            this.metricsLookupResults(annotatedTypeConfigurator.getAnnotated(), annotatedCallable).forEach(lookupResult -> {
                MetricAnnotationDiscoveryBase discoveryEvent = MetricAnnotationDiscoveryBase.create(annotatedTypeConfigurator, executableConfigurator, lookupResult.getAnnotation());
                if (exec != null) {
                    this.metricAnnotationDiscoveriesByExecutable.computeIfAbsent(exec, o -> new ArrayList()).add(discoveryEvent);
                    this.metricAnnotationDiscoveryObservers.forEach(observer -> observer.onDiscovery(discoveryEvent));
                }
                if (discoveryEvent.shouldUseDefaultInterceptor()) {
                    Class<? extends Annotation> metricAnnotationClass = lookupResult.getAnnotation().annotationType();
                    annotationAdder.apply(executableConfigurator, (Annotation)INTERCEPTED_METRIC_ANNOTATIONS.get(metricAnnotationClass));
                }
            });
        });
    }

    private void recordStereotypes(ProcessAnnotatedType<?> pat) {
        AnnotatedType annotatedType = pat.getAnnotatedType();
        Stream.concat(Stream.of(annotatedType), Stream.concat(pat.getAnnotatedType().getMethods().stream(), Stream.concat(pat.getAnnotatedType().getConstructors().stream(), pat.getAnnotatedType().getFields().stream()))).map(Annotated::getAnnotations).flatMap(Collection::stream).distinct().filter(MetricsCdiExtension::isStereotype).forEach(this::recordIfMetricsRelatedStereotype);
    }

    private static boolean isStereotype(Annotation annotation) {
        return annotation.annotationType().isAnnotationPresent(Stereotype.class);
    }

    private void recordIfMetricsRelatedStereotype(Annotation stereotypeAnnotation) {
        Class<? extends Annotation> candidateType = stereotypeAnnotation.annotationType();
        Set<Annotation> metricsRelatedAnnotations = Arrays.stream(candidateType.getAnnotations()).filter(a -> ALL_METRIC_ANNOTATIONS.contains(a.annotationType())).collect(Collectors.toSet());
        if (!metricsRelatedAnnotations.isEmpty()) {
            this.stereotypeMetricsInfo.put(candidateType, StereotypeMetricsInfo.create(metricsRelatedAnnotations));
        }
    }

    private Iterable<MetricUtil.LookupResult<?>> metricsLookupResults(AnnotatedType<?> annotatedType, AnnotatedCallable<?> annotatedMember) {
        ArrayList result = new ArrayList();
        INTERCEPTED_METRIC_ANNOTATIONS.keySet().forEach(metricAnnotationClass -> result.addAll(MetricUtil.lookupAnnotations(annotatedType, annotatedMember, metricAnnotationClass, this.stereotypeMetricsInfo)));
        return result;
    }

    private boolean checkCandidateMetricClass(ProcessAnnotatedType<?> pat) {
        AnnotatedType annotatedType = pat.getAnnotatedType();
        Class clazz = annotatedType.getJavaClass();
        if (annotatedType.isAnnotationPresent(Interceptor.class) || Modifier.isAbstract(clazz.getModifiers())) {
            LOGGER.log(Level.FINER, () -> "Ignoring " + clazz.getName() + " with annotations " + annotatedType.getAnnotations() + " for later processing: " + (Modifier.isAbstract(clazz.getModifiers()) ? "abstract " : "") + (annotatedType.isAnnotationPresent(Interceptor.class) ? "interceptor " : ""));
            return false;
        }
        LOGGER.log(Level.FINE, () -> "Accepting annotated type " + clazz.getName() + " for later bean processing");
        return true;
    }

    private void recordSimplyTimedForRestResources(@Observes @WithAnnotations(value={GET.class, PUT.class, POST.class, HEAD.class, OPTIONS.class, DELETE.class, PATCH.class}) ProcessAnnotatedType<?> pat) {
        if (!this.checkCandidateMetricClass(pat) || !this.restEndpointsMetricsEnabled) {
            return;
        }
        LOGGER.log(Level.FINE, () -> "Processing @SyntheticRestRequest annotation for " + pat.getAnnotatedType().getJavaClass().getName());
        AnnotatedTypeConfigurator configurator = pat.configureAnnotatedType();
        Class clazz = configurator.getAnnotated().getJavaClass();
        HashSet methodsToRecord = new HashSet();
        configurator.filterMethods(method -> !Modifier.isPrivate(method.getJavaMember().getModifiers())).forEach(annotatedMethodConfigurator -> JAX_RS_ANNOTATIONS.forEach(jaxRsAnnotation -> {
            Method m;
            AnnotatedMethod annotatedMethod = annotatedMethodConfigurator.getAnnotated();
            if (annotatedMethod.isAnnotationPresent(jaxRsAnnotation) && clazz.equals((m = annotatedMethod.getJavaMember()).getDeclaringClass())) {
                LOGGER.log(Level.FINE, () -> String.format("Adding @SyntheticRestRequest to %s", m.toString()));
                annotatedMethodConfigurator.add((Annotation)SyntheticRestRequest.Literal.getInstance());
                methodsToRecord.add(m);
            }
        }));
        if (!methodsToRecord.isEmpty()) {
            this.methodsWithRestRequestMetrics.put(clazz, methodsToRecord);
        }
    }

    static SimpleTimer restEndpointSimpleTimer(Method method) {
        LOGGER.log(Level.FINE, () -> String.format("Registering synthetic SimpleTimer for %s#%s", method.getDeclaringClass().getName(), method.getName()));
        return MetricsCdiExtension.getRegistryForSyntheticRestRequestMetrics().simpleTimer(SYNTHETIC_SIMPLE_TIMER_METADATA, MetricsCdiExtension.syntheticRestRequestMetricTags(method));
    }

    static Counter restEndpointCounter(Method method) {
        LOGGER.log(Level.FINE, () -> String.format("Registering synthetic Counter for %s#%s", method.getDeclaringClass().getName(), method.getName()));
        return MetricsCdiExtension.getRegistryForSyntheticRestRequestMetrics().counter(SYNTHETIC_SIMPLE_TIMER_UNMAPPED_EXCEPTION_METADATA, MetricsCdiExtension.syntheticRestRequestMetricTags(method));
    }

    private void registerAndSaveRestRequestMetrics(Method method) {
        this.workItemsManager.put((Executable)method, SyntheticRestRequest.class, (Object)SyntheticRestRequestWorkItem.create(MetricsCdiExtension.restEndpointSimpleTimerMetricID(method), MetricsCdiExtension.restEndpointSimpleTimer(method), MetricsCdiExtension.restEndpointCounterMetricID(method), MetricsCdiExtension.restEndpointCounter(method)));
    }

    static MetricID restEndpointSimpleTimerMetricID(Method method) {
        return new MetricID(SYNTHETIC_SIMPLE_TIMER_METRIC_NAME, MetricsCdiExtension.syntheticRestRequestMetricTags(method));
    }

    static MetricID restEndpointCounterMetricID(Method method) {
        return new MetricID(SYNTHETIC_SIMPLE_TIMER_METRIC_UNMAPPED_EXCEPTION_NAME, MetricsCdiExtension.syntheticRestRequestMetricTags(method));
    }

    static Tag[] syntheticRestRequestMetricTags(Method method) {
        return new Tag[]{new Tag("class", method.getDeclaringClass().getName()), new Tag("method", MetricsCdiExtension.methodTagValueForSyntheticRestRequestMetric(method))};
    }

    private static String methodTagValueForSyntheticRestRequestMetric(Method method) {
        StringBuilder methodTagValue = new StringBuilder(method.getName());
        for (Parameter p : method.getParameters()) {
            methodTagValue.append("_").append(MetricsCdiExtension.prettyParamType(p));
        }
        return methodTagValue.toString();
    }

    private static String prettyParamType(Parameter parameter) {
        return parameter.getType().isArray() || parameter.isVarArgs() ? parameter.getType().getComponentType().getName() + "[]" : parameter.getType().getName();
    }

    private void collectRestRequestMetrics(@Observes ProcessManagedBean<?> pmb) {
        AnnotatedType type = pmb.getAnnotatedBeanClass();
        Class clazz = type.getJavaClass();
        if (!this.methodsWithRestRequestMetrics.containsKey(clazz)) {
            return;
        }
        LOGGER.log(Level.FINE, () -> "Processing synthetic SimplyTimed annotations for " + clazz.getName());
        this.restRequestMetricsClassesProcessed.add(clazz);
        this.restRequestMetricsToRegister.addAll((Collection<Method>)this.methodsWithRestRequestMetrics.get(clazz));
    }

    private void registerRestRequestMetrics() {
        this.restRequestMetricsToRegister.forEach(this::registerAndSaveRestRequestMetrics);
        if (LOGGER.isLoggable(Level.FINE)) {
            HashSet syntheticSimpleTimerAnnotatedClassesIgnored = new HashSet(this.methodsWithRestRequestMetrics.keySet());
            syntheticSimpleTimerAnnotatedClassesIgnored.removeAll(this.restRequestMetricsClassesProcessed);
            if (!syntheticSimpleTimerAnnotatedClassesIgnored.isEmpty()) {
                LOGGER.log(Level.FINE, () -> "Classes with synthetic SimplyTimer annotations added that were not processed, probably because they were vetoed:" + syntheticSimpleTimerAnnotatedClassesIgnored.toString());
            }
        }
        this.restRequestMetricsClassesProcessed.clear();
        this.restRequestMetricsToRegister.clear();
    }

    boolean restEndpointsMetricsEnabled() {
        try {
            return MetricsCdiExtension.chooseRestEndpointsSetting(((Config)ConfigProvider.getConfig()).get("metrics"));
        }
        catch (Throwable t) {
            LOGGER.log(Level.WARNING, "Error looking up config setting for enabling REST endpoints SimpleTimer metrics; reporting 'false'", t);
            return false;
        }
    }

    public Routing.Builder registerService(@Observes @Priority(value=1010) @Initialized(value=ApplicationScoped.class) Object adv, BeanManager bm, ServerCdiExtension server) {
        Errors problems = this.errors.collect();
        this.errors = null;
        if (problems.hasFatal()) {
            throw new DeploymentException("Metrics module found issues with deployment: " + problems.toString());
        }
        Routing.Builder defaultRouting = super.registerService(adv, bm, server);
        MetricsSupport metricsSupport = (MetricsSupport)this.serviceSupport();
        RegistryProducer.clearApplicationRegistry();
        this.registerMetricsForAnnotatedSites();
        this.registerAnnotatedGauges(bm);
        this.registerRestRequestMetrics();
        HashSet<String> vendorMetricsAdded = new HashSet<String>();
        vendorMetricsAdded.add("@default");
        Config config = MpConfig.toHelidonConfig((org.eclipse.microprofile.config.Config)ConfigProvider.getConfig()).get("metrics");
        ((List)config.get("vendor-metrics-routings").asList(String.class).orElseGet(List::of)).forEach(routeName -> {
            if (!vendorMetricsAdded.contains(routeName)) {
                metricsSupport.configureVendorMetrics(routeName, (Routing.Rules)server.serverNamedRoutingBuilder(routeName));
                vendorMetricsAdded.add((String)routeName);
            }
        });
        Contexts.globalContext().register((Object)RegistryFactory.getInstance());
        return defaultRouting;
    }

    protected Config seComponentConfig() {
        Config mpConfig = MpConfig.toHelidonConfig((org.eclipse.microprofile.config.Config)ConfigProvider.getConfig());
        HashMap mpConfigSettings = new HashMap();
        Stream.of("tags", "appName").forEach(key -> mpConfig.get("mp.metrics." + key).asString().ifPresent(value -> mpConfigSettings.put(key, value)));
        Config metricsConfig = mpConfig.get("metrics").detach();
        Config.Builder builder = Config.builder();
        if (!mpConfigSettings.isEmpty()) {
            builder.addSource((Supplier)ConfigSources.create(mpConfigSettings));
        }
        if (metricsConfig.exists()) {
            builder.addSource(ConfigSources.create((Config)metricsConfig));
        }
        return builder.build();
    }

    private static boolean chooseRestEndpointsSetting(Config metricsConfig) {
        ConfigValue explicitRestEndpointsSetting = metricsConfig.get(REST_ENDPOINTS_METRIC_ENABLED_PROPERTY_NAME).asBoolean();
        boolean result = (Boolean)explicitRestEndpointsSetting.orElse((Object)false);
        if (explicitRestEndpointsSetting.isPresent()) {
            LOGGER.log(Level.FINE, () -> String.format("Support for MP REST.request metric and annotation handling explicitly set to %b in configuration", explicitRestEndpointsSetting.get()));
        } else {
            LOGGER.log(Level.FINE, () -> String.format("Support for MP REST.request metric and annotation handling defaulted to %b", false));
        }
        return result;
    }

    private void recordAnnotatedGaugeSite(@Observes ProcessManagedBean<?> pmb) {
        AnnotatedType type = pmb.getAnnotatedBeanClass();
        Class clazz = type.getJavaClass();
        LOGGER.log(Level.FINE, () -> "recordAnnotatedGaugeSite for class " + clazz);
        LOGGER.log(Level.FINE, () -> "Processing annotations for " + clazz.getName());
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return;
        }
        for (AnnotatedMethod method : type.getMethods()) {
            Method javaMethod = method.getJavaMember();
            if (!javaMethod.getDeclaringClass().equals(clazz) || Modifier.isPrivate(javaMethod.getModifiers())) continue;
            MetricUtil.metricsAnnotationsOnElement((Annotated)method, Gauge.class, this.stereotypeMetricsInfo).forEach(gaugeAnnotation -> {
                String explicitGaugeName;
                Class scopeAnnotation = pmb.getBean().getScope();
                if (scopeAnnotation == RequestScoped.class) {
                    this.errors.fatal((Object)clazz, "Cannot configure @Gauge on a request scoped bean");
                    return;
                }
                if (scopeAnnotation != ApplicationScoped.class && type.getAnnotation(Singleton.class) == null && ConfigProvider.getConfig().getOptionalValue("metrics.warn-dependent", Boolean.class).orElse(true).booleanValue()) {
                    LOGGER.warning(String.format("@Gauge is configured on a bean %s that is neither ApplicationScoped nor Singleton. This is most likely a bug. You may set 'metrics.warn-dependent' configuration option to 'false' to remove this warning.", clazz.getName()));
                }
                String gaugeNameSuffix = (explicitGaugeName = gaugeAnnotation.name()).length() > 0 ? explicitGaugeName : javaMethod.getName();
                String gaugeName = gaugeAnnotation.absolute() ? gaugeNameSuffix : String.format("%s.%s", clazz.getName(), gaugeNameSuffix);
                this.annotatedGaugeSites.put(new MetricID(gaugeName, MetricsCdiExtension.tags(gaugeAnnotation.tags())), method);
                LOGGER.log(Level.FINE, () -> String.format("Recorded annotated gauge with name %s", gaugeName));
            });
        }
    }

    private void registerAnnotatedGauges(BeanManager bm) {
        LOGGER.log(Level.FINE, () -> "registerGauges");
        MetricRegistry registry = MetricsCdiExtension.getMetricRegistry();
        ArrayList gaugeProblems = new ArrayList();
        this.annotatedGaugeSites.entrySet().forEach(gaugeSite -> {
            LOGGER.log(Level.FINE, () -> "gaugeSite " + gaugeSite.toString());
            MetricID gaugeID = (MetricID)gaugeSite.getKey();
            AnnotatedMethod site = (AnnotatedMethod)gaugeSite.getValue();
            try {
                DelegatingGauge<? extends Number> dg = this.buildDelegatingGauge(gaugeID.getName(), site, bm);
                Gauge gaugeAnnotation = this.siteAnnotation((Annotated)site, Gauge.class);
                if (gaugeAnnotation == null) {
                    gaugeProblems.add(new IllegalArgumentException(String.format("Unable to find expected @Gauge annotation at previously-identified site %s; ignoring site", site.getJavaMember())));
                } else {
                    Metadata md = Metadata.builder().withName(gaugeID.getName()).withDisplayName(gaugeAnnotation.displayName()).withDescription(gaugeAnnotation.description()).withType(MetricType.GAUGE).withUnit(gaugeAnnotation.unit()).build();
                    LOGGER.log(Level.FINE, () -> String.format("Registering gauge with metadata %s", md.toString()));
                    registry.register(md, dg, gaugeID.getTagsAsList().toArray(new Tag[0]));
                }
            }
            catch (Throwable t) {
                gaugeProblems.add(new IllegalArgumentException(String.format("Error processing @Gauge annotation on %s#%s: %s", site.getJavaMember().getDeclaringClass().getName(), site.getJavaMember().getName(), t.getMessage()), t));
            }
        });
        if (!gaugeProblems.isEmpty()) {
            throw new RuntimeException("Could not process one or more @Gauge annotations" + gaugeProblems);
        }
        this.annotatedGaugeSites.clear();
    }

    private <T extends Annotation> T siteAnnotation(Annotated site, Class<T> annotationType) {
        Annotation result = site.getAnnotation(annotationType);
        if (result != null) {
            return (T)((Annotation)annotationType.cast(result));
        }
        for (Annotation a : site.getAnnotations()) {
            StereotypeMetricsInfo info;
            if (!MetricsCdiExtension.isStereotype(a) || (info = this.stereotypeMetricsInfo.get(a.annotationType())) == null) continue;
            for (Annotation annotationOnStereotype : info.metricsAnnotations()) {
                if (!annotationType.isInstance(annotationOnStereotype)) continue;
                return (T)((Annotation)annotationType.cast(annotationOnStereotype));
            }
        }
        return null;
    }

    private DelegatingGauge<? extends Number> buildDelegatingGauge(String gaugeName, AnnotatedMethod<?> site, BeanManager bm) {
        Bean bean = (Bean)bm.getBeans(site.getJavaMember().getDeclaringClass(), new Annotation[0]).stream().findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot find bean for annotated gauge " + gaugeName));
        Class<?> returnType = site.getJavaMember().getReturnType();
        Class<? extends Number> narrowedReturnType = MetricsCdiExtension.typeToNumber(returnType);
        return DelegatingGauge.newInstance(site.getJavaMember(), MetricsCdiExtension.getReference(bm, bean.getBeanClass(), bean), narrowedReturnType);
    }

    private static Class<? extends Number> typeToNumber(Class<?> clazz) {
        Class narrowedReturnType;
        if (Byte.TYPE.isAssignableFrom(clazz)) {
            narrowedReturnType = Byte.class;
        } else if (Short.TYPE.isAssignableFrom(clazz)) {
            narrowedReturnType = Short.class;
        } else if (Integer.TYPE.isAssignableFrom(clazz)) {
            narrowedReturnType = Integer.class;
        } else if (Long.TYPE.isAssignableFrom(clazz)) {
            narrowedReturnType = Long.class;
        } else if (Float.TYPE.isAssignableFrom(clazz)) {
            narrowedReturnType = Float.class;
        } else if (Double.TYPE.isAssignableFrom(clazz)) {
            narrowedReturnType = Double.class;
        } else if (Number.class.isAssignableFrom(clazz)) {
            narrowedReturnType = clazz;
        } else {
            throw new IllegalArgumentException("Annotated gauge type must extend or be assignment-compatible with Number but is " + clazz.getName());
        }
        return narrowedReturnType;
    }

    record StereotypeMetricsInfo(Set<Annotation> metricsAnnotations) {
        static StereotypeMetricsInfo create(Set<Annotation> metricsAnnotations) {
            return new StereotypeMetricsInfo(metricsAnnotations);
        }
    }
}

