/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import io.helidon.metrics.api.RegistryFactory;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.RegistryType;

@ApplicationScoped
final class RegistryProducer {
    private RegistryProducer() {
    }

    @Produces
    public static MetricRegistry getDefaultRegistry() {
        return RegistryProducer.getApplicationRegistry();
    }

    @Produces
    @RegistryType(type=MetricRegistry.Type.APPLICATION)
    public static MetricRegistry getApplicationRegistry() {
        return RegistryFactory.getInstance().getRegistry(MetricRegistry.Type.APPLICATION);
    }

    @Produces
    @RegistryType(type=MetricRegistry.Type.BASE)
    public static MetricRegistry getBaseRegistry() {
        return RegistryFactory.getInstance().getRegistry(MetricRegistry.Type.BASE);
    }

    @Produces
    @RegistryType(type=MetricRegistry.Type.VENDOR)
    public static MetricRegistry getVendorRegistry() {
        return RegistryFactory.getInstance().getRegistry(MetricRegistry.Type.VENDOR);
    }

    static void clearApplicationRegistry() {
        MetricRegistry applicationRegistry = RegistryProducer.getApplicationRegistry();
        applicationRegistry.getNames().forEach(arg_0 -> ((MetricRegistry)applicationRegistry).remove(arg_0));
    }
}

