/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import io.helidon.metrics.api.FunctionalCounter;
import io.helidon.metrics.api.Gauge;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.MeterRegistry;
import io.helidon.microprofile.metrics.MetricImpl;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Tag;

abstract class HelidonGauge<N extends Number>
extends MetricImpl<Gauge<N>>
implements org.eclipse.microprofile.metrics.Gauge<N> {
    private final Gauge<N> delegate;

    protected HelidonGauge(String scope, Metadata metadata, Gauge<N> delegate) {
        super(scope, metadata);
        this.delegate = delegate;
    }

    static <N extends Number> SupplierBased<N> create(MeterRegistry meterRegistry, String scope, Metadata metadata, Supplier<N> supplier, Tag ... tags) {
        return new SupplierBased<N>(scope, metadata, supplier, (Gauge)meterRegistry.getOrCreate(((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder((String)metadata.getName(), supplier).scope(scope)).baseUnit(metadata.getUnit())).description(metadata.getDescription())).tags(HelidonGauge.allTags(scope, tags))));
    }

    static <T> DoubleFunctionBased<T> create(MeterRegistry meterRegistry, String scope, Metadata metadata, T target, ToDoubleFunction<T> fn, Tag ... tags) {
        return new DoubleFunctionBased<T>(scope, metadata, target, fn, (Gauge<Double>)((Gauge)meterRegistry.getOrCreate(((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder((String)metadata.getName(), target, fn).scope(scope)).description(metadata.getDescription())).baseUnit(metadata.getUnit())).tags(HelidonGauge.allTags(scope, tags)))));
    }

    static <N extends Number> HelidonGauge<N> create(String scope, Metadata metadata, Gauge<N> delegate) {
        return new DelegateBased<N>(scope, metadata, delegate);
    }

    static HelidonGauge<Long> create(String scope, Metadata metadata, FunctionalCounter delegate) {
        return new FunctionalCounterBased(scope, metadata, delegate);
    }

    @Override
    public Gauge<N> delegate() {
        return this.delegate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        HelidonGauge that = (HelidonGauge)o;
        return this.getValue().equals(that.getValue());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getValue());
    }

    @Override
    protected String toStringDetails() {
        return ", value='" + String.valueOf(this.getValue()) + "'";
    }

    @Override
    public Class<?> delegateType() {
        return Gauge.class;
    }

    static class SupplierBased<N extends Number>
    extends HelidonGauge<N> {
        private final Supplier<N> supplier;

        private SupplierBased(String scope, Metadata metadata, Supplier<N> supplier, Gauge<N> delegate) {
            super(scope, metadata, delegate);
            this.supplier = supplier;
        }

        public N getValue() {
            return (N)((Number)this.supplier.get());
        }
    }

    static class DoubleFunctionBased<T>
    extends HelidonGauge<Double> {
        private final T target;
        private final ToDoubleFunction<T> fn;

        protected DoubleFunctionBased(String scope, Metadata metadata, T target, ToDoubleFunction<T> fn, Gauge<Double> delegate) {
            super(scope, metadata, delegate);
            this.target = target;
            this.fn = fn;
        }

        public Double getValue() {
            return this.fn.applyAsDouble(this.target);
        }
    }

    static class DelegateBased<N extends Number>
    extends HelidonGauge<N> {
        private DelegateBased(String scope, Metadata metadata, Gauge<N> delegate) {
            super(scope, metadata, delegate);
        }

        public N getValue() {
            return (N)this.delegate().value();
        }
    }

    static class FunctionalCounterBased
    extends HelidonGauge<Long> {
        private final FunctionalCounter functionalCounter;

        private FunctionalCounterBased(String scope, Metadata metadata, FunctionalCounter delegate) {
            super(scope, metadata, null);
            this.functionalCounter = delegate;
        }

        public Long getValue() {
            return this.functionalCounter.count();
        }

        @Override
        public boolean removeViaDelegate(MeterRegistry meterRegistry) {
            return this.functionalCounter != null && meterRegistry.remove((Meter)this.functionalCounter).isPresent();
        }
    }

    static class FunctionBased<N extends Number, T>
    extends HelidonGauge<N> {
        private final T target;
        private final Function<T, N> function;

        private FunctionBased(String scope, Metadata metadata, T target, Function<T, N> function, Gauge<N> delegate) {
            super(scope, metadata, delegate);
            this.target = target;
            this.function = function;
        }

        public N getValue() {
            return (N)((Number)this.function.apply(this.target));
        }
    }
}

