/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import io.helidon.common.Errors;
import io.helidon.common.LazyValue;
import io.helidon.metrics.api.DistributionStatisticsConfig;
import io.helidon.metrics.api.DistributionSummary;
import io.helidon.metrics.api.Timer;
import java.lang.reflect.Array;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.microprofile.config.Config;

class DistributionCustomizations {
    private static final System.Logger LOGGER = System.getLogger(DistributionCustomizations.class.getName());
    private static final double DEFAULT_SUMMARY_MIN = 0.05;
    private static final double DEFAULT_SUMMARY_MAX = 10000.0;
    private static final Duration DEFAULT_TIMER_MIN = Duration.ofMillis(5L);
    private static final Duration DEFAULT_TIMER_MAX = Duration.ofSeconds(10L);
    private static DistributionCustomizations instance;
    private final List<Percentiles> percentileCustomizations;
    private final List<SummaryBuckets> summaryBucketCustomizations;
    private final List<TimerBuckets> timerBucketCustomizations;
    private final List<SingleValuedCustomization<Boolean>> summaryBucketDefaultCustomizations;

    private DistributionCustomizations(Config mpConfig) {
        this.percentileCustomizations = DistributionCustomizations.collect(mpConfig, "mp.metrics.distribution.percentiles", Percentiles::new);
        this.summaryBucketCustomizations = DistributionCustomizations.collect(mpConfig, "mp.metrics.distribution.histogram.buckets", SummaryBuckets::new);
        this.timerBucketCustomizations = DistributionCustomizations.collect(mpConfig, "mp.metrics.distribution.timer.buckets", TimerBuckets::new);
        this.summaryBucketDefaultCustomizations = DistributionCustomizations.collect(mpConfig, "mp.metrics.distribution.percentiles-histogram.enabled", expression -> new SingleValuedCustomization<Boolean>((String)expression, Boolean::parseBoolean));
    }

    static void init(Config mpConfig) {
        instance = new DistributionCustomizations(mpConfig);
    }

    static DistributionSummary.Builder apply(DistributionSummary.Builder builder) {
        DistributionStatisticsConfig.Builder statsBuilder = builder.distributionStatisticsConfig().orElseGet(() -> {
            DistributionStatisticsConfig.Builder newBuilder = DistributionStatisticsConfig.builder();
            builder.distributionStatisticsConfig(newBuilder);
            return newBuilder;
        });
        DistributionCustomizations.instance.percentileCustomizations.stream().filter(p -> p.matches(builder.name())).forEach(p -> statsBuilder.percentiles(p.percentiles()));
        AtomicBoolean matched = new AtomicBoolean();
        DistributionCustomizations.instance.summaryBucketCustomizations.stream().filter(b -> b.matches(builder.name())).forEach(b -> {
            matched.set(true);
            statsBuilder.buckets(b.buckets());
        });
        if (!matched.get()) {
            DistributionCustomizations.instance.summaryBucketDefaultCustomizations.stream().filter(def -> def.matches(builder.name())).map(SingleValuedCustomization::value).reduce((a, b) -> b).ifPresent(def -> {
                builder.publishPercentileHistogram(def.booleanValue());
                statsBuilder.minimumExpectedValue(Double.valueOf(0.05)).maximumExpectedValue(Double.valueOf(10000.0));
            });
        }
        return builder;
    }

    static Timer.Builder apply(Timer.Builder builder) {
        DistributionCustomizations.instance.percentileCustomizations.stream().filter(p -> p.matches(builder.name())).forEach(p -> builder.percentiles(p.percentiles()));
        AtomicBoolean matched = new AtomicBoolean();
        DistributionCustomizations.instance.timerBucketCustomizations.stream().filter(b -> b.matches(builder.name())).forEach(b -> {
            matched.set(true);
            builder.buckets(b.buckets());
        });
        if (!matched.get()) {
            DistributionCustomizations.instance.summaryBucketDefaultCustomizations.stream().filter(def -> def.matches(builder.name())).map(SingleValuedCustomization::value).reduce((a, b) -> b).ifPresent(def -> {
                builder.publishPercentileHistogram(def.booleanValue());
                builder.minimumExpectedValue(DEFAULT_TIMER_MIN).maximumExpectedValue(DEFAULT_TIMER_MAX);
            });
        }
        return builder;
    }

    private static <U extends Customization> List<U> collect(Config mpConfig, String configKey, Function<String, U> factory) {
        return mpConfig.getOptionalValue(configKey, String.class).stream().flatMap(s -> Arrays.stream(s.split(";"))).map(factory).toList();
    }

    private static double[] doubles(Double[] doubles) {
        double[] result = new double[doubles.length];
        for (int i = 0; i < doubles.length; ++i) {
            result[i] = doubles[i];
        }
        return result;
    }

    static class SingleValuedCustomization<T>
    extends Customization {
        private final T value;

        protected SingleValuedCustomization(String nameAndValuesExpression, Function<String, T> valueParser) {
            super(nameAndValuesExpression);
            this.value = valueParser.apply(this.valuesExpression());
        }

        protected T value() {
            return this.value;
        }
    }

    static class TimerBuckets
    extends MultiValuedCustomization<Duration> {
        private TimerBuckets(String nameExpressionAndValues) {
            super(nameExpressionAndValues, Duration.class, TimerBuckets::parseTimerBucketExpression, d -> {});
        }

        protected Duration[] buckets() {
            return (Duration[])this.values();
        }

        private static Duration parseTimerBucketExpression(String expr) {
            TimeUnit timeUnit;
            int suffixSize = 1;
            String lcExpr = expr.toLowerCase(Locale.ROOT);
            if (lcExpr.endsWith("ms")) {
                timeUnit = TimeUnit.MILLISECONDS;
                suffixSize = 2;
            } else if (lcExpr.endsWith("s")) {
                timeUnit = TimeUnit.SECONDS;
            } else if (lcExpr.endsWith("m")) {
                timeUnit = TimeUnit.MINUTES;
            } else if (lcExpr.endsWith("h")) {
                timeUnit = TimeUnit.HOURS;
            } else {
                timeUnit = TimeUnit.MILLISECONDS;
                suffixSize = 0;
            }
            int amount = Integer.parseInt(expr.substring(0, expr.length() - suffixSize));
            return Duration.of(amount, timeUnit.toChronoUnit());
        }
    }

    static class Percentiles
    extends MultiValuedCustomization<Double> {
        private final double[] values = DistributionCustomizations.doubles((Double[])this.values());

        private Percentiles(String nameExpressionAndValues) {
            super(nameExpressionAndValues, Double.class, Double::parseDouble, d -> {
                if (d < 0.0 || d > 1.0) {
                    throw new IllegalArgumentException("Value " + d + " not in required range [0.0, 1.0]");
                }
            });
        }

        double[] percentiles() {
            return this.values;
        }
    }

    static class SummaryBuckets
    extends MultiValuedCustomization<Double> {
        private final double[] values = DistributionCustomizations.doubles((Double[])this.values());

        private SummaryBuckets(String nameExpressionAndValues) {
            super(nameExpressionAndValues, Double.class, Double::parseDouble, d -> {
                if (d <= 0.0) {
                    throw new IllegalArgumentException("Value must be > 0 but " + d + " is not");
                }
            });
        }

        double[] buckets() {
            return this.values;
        }
    }

    static abstract class MultiValuedCustomization<T extends Comparable<T>>
    extends Customization {
        private final T[] values;

        protected MultiValuedCustomization(String nameExpressionAndValues, Class<T> type, Function<String, T> valueParser, Consumer<T> valueChecker) {
            super(nameExpressionAndValues);
            if (this.valuesExpression().isBlank()) {
                this.values = (Comparable[])Array.newInstance(type, 0);
                return;
            }
            this.values = this.values(this.valuesExpression(), type, valueParser, valueChecker);
        }

        protected T[] values() {
            return this.values;
        }

        private T[] values(String valuesString, Class<T> type, Function<String, T> valueParser, Consumer<T> valueChecker) {
            Object[] valueStrings = valuesString.split(",");
            Comparable[] result = (Comparable[])Array.newInstance(type, valueStrings.length);
            int next = 0;
            Comparable prev = null;
            boolean valuesInOrder = true;
            LazyValue collector = LazyValue.create(Errors::collector);
            for (String string : valueStrings) {
                Comparable value;
                if (string.isBlank()) continue;
                try {
                    value = (Comparable)((Object)valueParser.apply(string));
                }
                catch (Exception ex) {
                    ((Errors.Collector)collector.get()).warn("ignoring invalid value: " + ex.getMessage());
                    continue;
                }
                valuesInOrder &= prev != null && prev.compareTo(value) < 0;
                try {
                    valueChecker.accept(value);
                }
                catch (Exception ex) {
                    ((Errors.Collector)collector.get()).warn("ignoring value for " + this.namePrefix() + (this.hasTrailingWildcard() ? "*" : ": ") + ex.getMessage());
                    continue;
                }
                result[next++] = value;
                prev = value;
            }
            if (!valuesInOrder) {
                ((Errors.Collector)collector.get()).warn("Values for " + this.namePrefix() + (this.hasTrailingWildcard() ? "*" : "") + "should be in strictly increasing order but are not: " + Arrays.toString(valueStrings));
            }
            if (collector.isLoaded()) {
                ((Errors.Collector)collector.get()).collect().log(LOGGER);
            }
            return Arrays.copyOf(result, next);
        }
    }

    static abstract class Customization {
        private final String namePrefix;
        private final boolean hasTrailingWildcard;
        private final String valuesExpression;

        protected Customization(String nameExpressionAndValues) {
            int eq = nameExpressionAndValues.indexOf(61);
            if (eq <= 0) {
                this.valuesExpression = "";
                this.namePrefix = "";
                this.hasTrailingWildcard = false;
                return;
            }
            String namePrefixMaybeWithWildcard = nameExpressionAndValues.substring(0, eq);
            this.hasTrailingWildcard = namePrefixMaybeWithWildcard.endsWith("*");
            this.namePrefix = namePrefixMaybeWithWildcard.substring(0, this.hasTrailingWildcard ? eq - 1 : eq);
            this.valuesExpression = nameExpressionAndValues.substring(eq + 1);
        }

        protected String namePrefix() {
            return this.namePrefix;
        }

        protected boolean hasTrailingWildcard() {
            return this.hasTrailingWildcard;
        }

        protected String valuesExpression() {
            return this.valuesExpression;
        }

        protected boolean matches(String metricName) {
            return this.hasTrailingWildcard() ? metricName.startsWith(this.namePrefix()) : metricName.equals(this.namePrefix());
        }
    }
}

