/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import io.helidon.common.LazyValue;
import io.helidon.common.configurable.spi.ExecutorServiceSupplierObserver;
import io.helidon.microprofile.metrics.RegistryFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;

class ExecutorServiceMetricsObserver
implements ExecutorServiceSupplierObserver {
    private static final System.Logger LOGGER = System.getLogger(ExecutorServiceMetricsObserver.class.getName());
    private static final String METRIC_NAME_PREFIX = "executor-service.";
    private static final List<GaugeFactory<?, ThreadPoolExecutor>> THREAD_POOL_EXECUTOR_METRIC_FACTORIES = List.of(GaugeFactory.create(MetadataTemplates.ACTIVE_COUNT_METADATA, ThreadPoolExecutor::getActiveCount), GaugeFactory.create(MetadataTemplates.COMPLETED_TASK_COUNT_METADATA, ThreadPoolExecutor::getCompletedTaskCount), GaugeFactory.create(MetadataTemplates.POOL_SIZE_METADATA, ThreadPoolExecutor::getPoolSize), GaugeFactory.create(MetadataTemplates.LARGEST_POOL_SIZE_METADATA, ThreadPoolExecutor::getLargestPoolSize), GaugeFactory.create(MetadataTemplates.TASK_COUNT_METADATA, ThreadPoolExecutor::getTaskCount), GaugeFactory.create(MetadataTemplates.QUEUE_REMAINING_CAPACITY_METADATA, tpe -> tpe.getQueue().remainingCapacity()), GaugeFactory.create(MetadataTemplates.QUEUE_SIZE_METADATA, tpe -> tpe.getQueue().size()));
    private final LazyValue<MetricRegistry> registry = LazyValue.create(() -> RegistryFactory.getInstance().getRegistry("vendor"));

    ExecutorServiceMetricsObserver() {
    }

    public ExecutorServiceSupplierObserver.SupplierObserverContext registerSupplier(Supplier<? extends ExecutorService> supplier, int supplierIndex, String supplierCategory) {
        SupplierInfo supplierInfo = new SupplierInfo(this, supplierCategory, supplierIndex);
        LOGGER.log(System.Logger.Level.DEBUG, () -> String.format("Metrics thread pool supplier registration: %s", supplierInfo));
        return supplierInfo.context();
    }

    private static Tag[] tags(String supplierCategory, int supplierIndex, int index) {
        return new Tag[]{new Tag("supplierCategory", supplierCategory), new Tag("supplierIndex", Integer.toString(supplierIndex)), new Tag("poolIndex", Integer.toString(index))};
    }

    private class SupplierInfo {
        private final MetricsObserverContext context;
        private final String supplierCategory;
        private final int supplierIndex;

        private SupplierInfo(ExecutorServiceMetricsObserver executorServiceMetricsObserver, String supplierCategory, int supplierIndex) {
            this.supplierCategory = supplierCategory;
            this.supplierIndex = supplierIndex;
            this.context = executorServiceMetricsObserver.new MetricsObserverContext(this);
        }

        String supplierCategory() {
            return this.supplierCategory;
        }

        int supplierIndex() {
            return this.supplierIndex;
        }

        private MetricsObserverContext context() {
            return this.context;
        }

        public String toString() {
            return new StringJoiner(", ", SupplierInfo.class.getSimpleName() + "[", "]").add("supplierCategory='" + this.supplierCategory + "'").add("supplierIndex=" + this.supplierIndex).toString();
        }
    }

    private class MetricsObserverContext
    implements ExecutorServiceSupplierObserver.SupplierObserverContext {
        private final SupplierInfo supplierInfo;
        private final Set<MetricID> metricsIDs = new HashSet<MetricID>();

        private MetricsObserverContext(SupplierInfo supplierInfo) {
            this.supplierInfo = supplierInfo;
        }

        public void registerExecutorService(ExecutorService executorService, int index) {
            LOGGER.log(System.Logger.Level.DEBUG, String.format("Registering executor service %s:%d for supplier %s%d", executorService, index, this.supplierInfo.supplierCategory(), this.supplierInfo.supplierIndex()));
            if (executorService instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor tpe = (ThreadPoolExecutor)executorService;
                this.registerMetrics(tpe, index);
            }
        }

        private void registerMetrics(ThreadPoolExecutor threadPoolExecutor, int index) {
            THREAD_POOL_EXECUTOR_METRIC_FACTORIES.forEach(factory -> factory.registerGauge((MetricRegistry)ExecutorServiceMetricsObserver.this.registry.get(), this.supplierInfo.supplierCategory(), this.supplierInfo.supplierIndex(), threadPoolExecutor, index, this.metricsIDs));
        }

        public void unregisterExecutorService(ExecutorService executorService) {
            this.metricsIDs.forEach(metricID -> ((MetricRegistry)ExecutorServiceMetricsObserver.this.registry.get()).remove(metricID));
        }
    }

    private static class MetadataTemplates {
        private static final Metadata ACTIVE_COUNT_METADATA = Metadata.builder().withName("executor-service.active-count").withDescription("Active count").withUnit("none").build();
        private static final Metadata COMPLETED_TASK_COUNT_METADATA = Metadata.builder().withName("executor-service.completed-task-count").withDescription("Completed task count").withUnit("none").build();
        private static final Metadata POOL_SIZE_METADATA = Metadata.builder().withName("executor-service.pool-size").withDescription("Pool size").withUnit("none").build();
        private static final Metadata LARGEST_POOL_SIZE_METADATA = Metadata.builder().withName("executor-service.largest-pool-size").withDescription("Largest pool size").withUnit("none").build();
        private static final Metadata TASK_COUNT_METADATA = Metadata.builder().withName("executor-service.task-count").withDescription("Task count").withUnit("none").build();
        private static final Metadata QUEUE_REMAINING_CAPACITY_METADATA = Metadata.builder().withName("executor-service.queue.remaining-capacity").withDescription("Queue remaining capacity").withUnit("none").build();
        private static final Metadata QUEUE_SIZE_METADATA = Metadata.builder().withName("executor-service.queue.size").withDescription("Queue size").withUnit("none").build();

        private MetadataTemplates() {
        }
    }

    private static class GaugeFactory<T extends Number, E extends ExecutorService> {
        private final Metadata templateMetadata;
        private final Function<E, T> valueFunction;

        private static <T extends Number, E extends ExecutorService> GaugeFactory<T, E> create(Metadata templateMetadata, Function<E, T> valueFunction) {
            return new GaugeFactory<T, E>(templateMetadata, valueFunction);
        }

        private GaugeFactory(Metadata templateMetadata, Function<E, T> valueFunction) {
            this.templateMetadata = templateMetadata;
            this.valueFunction = valueFunction;
        }

        private Gauge<T> registerGauge(MetricRegistry registry, String supplierCategory, int supplierIndex, E executor, int index, Set<MetricID> metricIDs) {
            Tag[] tags = ExecutorServiceMetricsObserver.tags(supplierCategory, supplierIndex, index);
            metricIDs.add(new MetricID(this.templateMetadata.getName(), tags));
            return registry.gauge(this.templateMetadata, () -> (Number)this.valueFunction.apply(executor), tags);
        }
    }
}

