/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import io.helidon.metrics.api.DistributionSummary;
import io.helidon.metrics.api.LabeledSnapshot;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.MeterRegistry;
import io.helidon.metrics.api.SnapshotMetric;
import io.helidon.microprofile.metrics.DistributionCustomizations;
import io.helidon.microprofile.metrics.HelidonSnapshot;
import io.helidon.microprofile.metrics.MetricImpl;
import io.helidon.microprofile.metrics.Registry;
import io.helidon.microprofile.metrics.WrappedSnapshot;
import java.util.Objects;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Snapshot;
import org.eclipse.microprofile.metrics.Tag;

final class HelidonHistogram
extends MetricImpl<DistributionSummary>
implements Histogram,
SnapshotMetric {
    private final DistributionSummary delegate;

    private HelidonHistogram(String scope, Metadata metadata, DistributionSummary delegate) {
        super(scope, metadata);
        this.delegate = delegate;
    }

    static HelidonHistogram create(MeterRegistry meterRegistry, String scope, Metadata metadata, Tag ... tags) {
        return HelidonHistogram.create(scope, metadata, (DistributionSummary)meterRegistry.getOrCreate((Meter.Builder)DistributionCustomizations.apply((DistributionSummary.Builder)((DistributionSummary.Builder)((DistributionSummary.Builder)((DistributionSummary.Builder)DistributionSummary.builder((String)metadata.getName()).scope(scope)).description(metadata.getDescription())).baseUnit(HelidonHistogram.sanitizeUnit(metadata.getUnit()))).tags(HelidonHistogram.allTags(scope, tags)))));
    }

    static HelidonHistogram create(String scope, Metadata metadata, DistributionSummary delegate) {
        return new HelidonHistogram(scope, metadata, delegate);
    }

    static HelidonHistogram create(DistributionSummary delegate) {
        return new HelidonHistogram(HelidonHistogram.resolvedScope((Meter)delegate), Registry.metadata((Meter)delegate), delegate);
    }

    public long getSum() {
        return (long)this.delegate.totalAmount();
    }

    public void update(int value) {
        this.delegate.record((double)value);
    }

    public void update(long value) {
        this.delegate.record((double)value);
    }

    public long getCount() {
        return this.delegate.count();
    }

    public Snapshot getSnapshot() {
        return HelidonSnapshot.create(this.delegate.snapshot());
    }

    public LabeledSnapshot snapshot() {
        return WrappedSnapshot.create(this.getSnapshot());
    }

    @Override
    public DistributionSummary delegate() {
        return this.delegate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        HelidonHistogram that = (HelidonHistogram)o;
        return Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.delegate);
    }

    @Override
    protected String toStringDetails() {
        Snapshot snapshot = this.getSnapshot();
        StringBuilder sb = new StringBuilder();
        sb.append(", count='").append(this.getCount()).append('\'');
        if (null != snapshot) {
            sb.append(", max='").append(snapshot.getMax()).append('\'');
            sb.append(", mean='").append(snapshot.getMean()).append('\'');
        }
        return sb.toString();
    }

    @Override
    public Class<DistributionSummary> delegateType() {
        return DistributionSummary.class;
    }
}

