/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import io.helidon.microprofile.metrics.BasicMetricWorkItem;
import io.helidon.microprofile.metrics.HelidonMetric;
import io.helidon.microprofile.metrics.MetricsCdiExtension;
import io.helidon.microprofile.servicecommon.HelidonInterceptor;
import jakarta.inject.Inject;
import jakarta.interceptor.InvocationContext;
import java.lang.annotation.Annotation;
import java.util.function.Consumer;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;

abstract class InterceptorBase<M extends Metric>
extends HelidonInterceptor.Base<BasicMetricWorkItem> {
    private static final System.Logger LOGGER = System.getLogger(InterceptorBase.class.getName());
    private final Class<? extends Annotation> annotationType;
    private final Class<M> metricType;
    @Inject
    private MetricsCdiExtension extension;
    @Inject
    private MetricRegistry registry;

    InterceptorBase(Class<? extends Annotation> annotationType, Class<M> metricType) {
        this.annotationType = annotationType;
        this.metricType = metricType;
    }

    Class<? extends Annotation> annotationType() {
        return this.annotationType;
    }

    public void preInvocation(InvocationContext context, BasicMetricWorkItem workItem) {
        this.invokeVerifiedAction(context, workItem, this::preInvoke, ActionType.PREINVOKE);
    }

    void invokeVerifiedAction(InvocationContext context, BasicMetricWorkItem workItem, Consumer<M> action, ActionType actionType) {
        Metric metric = workItem.metric();
        if (HelidonMetric.isMarkedAsDeleted(metric)) {
            throw new IllegalStateException("Attempt to use previously-removed metric" + String.valueOf(workItem.metricID()));
        }
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, String.format("%s (%s) is accepting %s %s for processing on %s triggered by @%s", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), actionType, workItem.metric().getClass().getSimpleName(), workItem.metricID(), context.getMethod() != null ? context.getMethod() : context.getConstructor(), this.annotationType.getSimpleName()}));
        }
        action.accept((Metric)this.metricType.cast(metric));
    }

    abstract void preInvoke(M var1);

    static enum ActionType {
        PREINVOKE("preinvoke"),
        COMPLETE("complete");

        private final String label;

        private ActionType(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

