/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.MeterRegistry;
import io.helidon.metrics.api.SystemTagsManager;
import io.helidon.microprofile.metrics.AbstractMetric;
import io.helidon.microprofile.metrics.HelidonMetric;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Tag;

abstract class MetricImpl<M extends Meter>
extends AbstractMetric<M>
implements HelidonMetric<M> {
    static final double[] DEFAULT_PERCENTILES = new double[]{0.5, 0.75, 0.95, 0.98, 0.99, 0.999};
    static final int DEFAULT_PERCENTILE_PRECISION = 3;

    MetricImpl(String registryType, Metadata metadata) {
        super(registryType, metadata);
    }

    @Override
    public String getName() {
        return this.metadata().getName();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{registryType='" + this.registryType() + "', metadata=" + String.valueOf(this.metadata()) + this.toStringDetails() + "}";
    }

    @Override
    public boolean isDeleted() {
        return super.isDeleted();
    }

    protected String toStringDetails() {
        return "";
    }

    @Override
    public boolean removeViaDelegate(MeterRegistry meterRegistry) {
        return this.delegate() != null && meterRegistry.remove(this.delegate()).isPresent();
    }

    protected static Iterable<io.helidon.metrics.api.Tag> allTags(String scope, Tag[] tags) {
        return MetricImpl.toHelidonTags(SystemTagsManager.instance().withScopeTag(MetricImpl.iterableEntries(tags), scope));
    }

    static String resolvedScope(Meter delegate) {
        return SystemTagsManager.instance().effectiveScope(delegate.scope()).orElse("application");
    }

    private static Iterable<io.helidon.metrics.api.Tag> toHelidonTags(final Iterable<Map.Entry<String, String>> entriesIterable) {
        return () -> new Iterator<io.helidon.metrics.api.Tag>(){
            private final Iterator<Map.Entry<String, String>> entriesIterator;
            {
                this.entriesIterator = entriesIterable.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.entriesIterator.hasNext();
            }

            @Override
            public io.helidon.metrics.api.Tag next() {
                if (!this.entriesIterator.hasNext()) {
                    throw new NoSuchElementException();
                }
                Map.Entry<String, String> entry = this.entriesIterator.next();
                return io.helidon.metrics.api.Tag.create((String)entry.getKey(), (String)entry.getValue());
            }
        };
    }

    protected static String sanitizeUnit(String unit) {
        return unit != null && !unit.equals("none") ? unit : null;
    }

    private static Iterable<Map.Entry<String, String>> iterableEntries(final Tag ... tags) {
        return () -> new Iterator<Map.Entry<String, String>>(){
            private int next;

            @Override
            public boolean hasNext() {
                return tags != null && this.next < tags.length;
            }

            @Override
            public Map.Entry<String, String> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                AbstractMap.SimpleEntry<String, String> result = new AbstractMap.SimpleEntry<String, String>(tags[this.next].getTagName(), tags[this.next].getTagValue());
                ++this.next;
                return result;
            }
        };
    }
}

