/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.MeterRegistry;
import io.helidon.metrics.api.Metrics;
import io.helidon.microprofile.metrics.PeriodicExecutor;
import io.helidon.microprofile.metrics.Registry;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Timer;

public class RegistryFactory {
    static final Collection<Class<? extends Metric>> METRIC_TYPES = Set.of(Counter.class, Gauge.class, Histogram.class, Timer.class);
    private static final AtomicReference<RegistryFactory> REGISTRY_FACTORY = new AtomicReference();
    private static final System.Logger LOGGER = System.getLogger(RegistryFactory.class.getName());
    private final MeterRegistry meterRegistry;
    private final Map<String, Registry> registries = new HashMap<String, Registry>();
    private final Lock metricsSettingsAccess = new ReentrantLock(true);

    private RegistryFactory(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
        meterRegistry.onMeterAdded(this::registerMetricForExistingMeter).onMeterRemoved(this::removeMetricForMeter);
    }

    static RegistryFactory create(MeterRegistry meterRegistry) {
        return new RegistryFactory(meterRegistry);
    }

    static RegistryFactory getInstance(MeterRegistry meterRegistry) {
        return REGISTRY_FACTORY.updateAndGet(rf -> rf != null && rf.meterRegistry == meterRegistry ? rf : RegistryFactory.create(meterRegistry));
    }

    public static RegistryFactory getInstance() {
        RegistryFactory result = REGISTRY_FACTORY.get();
        if (result == null) {
            LOGGER.log(System.Logger.Level.WARNING, "Attempt to retrieve current " + RegistryFactory.class.getName() + " before it has been initialized; using default Helidon meter registry and continuing");
            result = new RegistryFactory(Metrics.globalRegistry());
            REGISTRY_FACTORY.set(result);
        }
        return result;
    }

    static void closeAll() {
        RegistryFactory rf = REGISTRY_FACTORY.get();
        if (rf != null) {
            rf.close();
            REGISTRY_FACTORY.set(null);
        }
    }

    public MetricRegistry getRegistry(String scope) {
        return this.registry(scope);
    }

    public Set<String> scopes() {
        return Collections.unmodifiableSet(this.registries.keySet());
    }

    Registry registry(String scope) {
        return this.accessMetricsSettings(() -> this.registries.computeIfAbsent(scope, s -> Registry.create(s, this.meterRegistry)));
    }

    void start() {
        PeriodicExecutor.start();
    }

    void close() {
        List.copyOf(this.registries.values()).forEach(Registry::clear);
        this.registries.clear();
        PeriodicExecutor.stop();
    }

    private <T> T accessMetricsSettings(Callable<T> callable) {
        this.metricsSettingsAccess.lock();
        try {
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.metricsSettingsAccess.unlock();
        }
    }

    private void registerMetricForExistingMeter(Meter delegate) {
        String scope = delegate.scope().orElse(null);
        if (scope == null) {
            LOGGER.log(System.Logger.Level.WARNING, "Attempt to register an existing meter with no scope: " + String.valueOf(delegate));
        }
        this.registry(scope).onMeterAdded(delegate);
    }

    private void removeMetricForMeter(Meter meter) {
        String scope = meter.scope().orElse(null);
        if (scope == null) {
            LOGGER.log(System.Logger.Level.WARNING, "Attempt to register an existing meter with no scope: " + String.valueOf(meter));
        }
        this.registry(scope).onMeterRemoved(meter);
    }
}

