/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;

class TypeFilteredIterable {
    private TypeFilteredIterable() {
    }

    public static <S> Iterable<S> create(final Iterable<? super S> original, final Class<S> sClass) {
        return new Iterable<S>(){

            @Override
            public Iterator<S> iterator() {
                return new Iterator<S>(){
                    private final Iterator<? super S> it;
                    private S next;
                    {
                        this.it = original.iterator();
                        this.next = this.findNext();
                    }

                    private S findNext() {
                        while (this.it.hasNext()) {
                            Object nextOriginal = this.it.next();
                            if (!sClass.isInstance(nextOriginal)) continue;
                            return sClass.cast(nextOriginal);
                        }
                        return null;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public S next() {
                        if (this.next == null) {
                            throw new NoSuchElementException();
                        }
                        Object result = this.next;
                        this.next = this.findNext();
                        return result;
                    }

                    @Override
                    public void forEachRemaining(Consumer<? super S> action) {
                        Iterator.super.forEachRemaining((? super E t) -> {
                            if (sClass.isInstance(t)) {
                                action.accept((Object)t);
                            }
                        });
                    }
                };
            }

            @Override
            public void forEach(Consumer<? super S> action) {
                Iterable.super.forEach((? super T t) -> {
                    if (sClass.isInstance(t)) {
                        action.accept((Object)t);
                    }
                });
            }
        };
    }
}

