/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.openapi;

import io.helidon.microprofile.openapi.OpenApiHelper;
import io.helidon.microprofile.openapi.OpenApiParser;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import jakarta.json.Json;
import jakarta.json.JsonNumber;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.representer.Representer;

class JsonpAnnotationScannerExtension
implements AnnotationScannerExtension {
    private static final System.Logger LOGGER = System.getLogger(JsonpAnnotationScannerExtension.class.getName());
    private static final JsonReaderFactory JSON_READER_FACTORY = Json.createReaderFactory(Collections.emptyMap());
    private static final Representer MISSING_FIELD_TOLERANT_REPRESENTER = new Representer(new DumperOptions());

    JsonpAnnotationScannerExtension() {
    }

    public Object parseExtension(String key, String value) {
        try {
            return this.parseValue(value);
        }
        catch (Exception ex) {
            LOGGER.log(System.Logger.Level.ERROR, String.format("Error parsing extension key: %s, value: %s", key, value), (Throwable)ex);
            return null;
        }
    }

    public Object parseValue(String value) {
        if (value == null || value.isBlank()) {
            return null;
        }
        if ("true".equalsIgnoreCase(value = value.trim()) || "false".equalsIgnoreCase(value)) {
            return Boolean.valueOf(value);
        }
        switch (value.charAt(0)) {
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case '[': 
            case '{': {
                try {
                    JsonReader reader = JSON_READER_FACTORY.createReader((Reader)new StringReader(value));
                    JsonValue jsonValue = reader.readValue();
                    if (jsonValue.getValueType().equals((Object)JsonValue.ValueType.NUMBER) && value.length() != jsonValue.toString().length()) {
                        return value;
                    }
                    return JsonpAnnotationScannerExtension.convertJsonValue(jsonValue);
                }
                catch (Exception ex) {
                    LOGGER.log(System.Logger.Level.ERROR, String.format("Error parsing JSON value: %s", value), (Throwable)ex);
                    throw ex;
                }
            }
        }
        return value;
    }

    public Schema parseSchema(String jsonSchema) {
        return OpenApiParser.parse(OpenApiHelper.types(), Schema.class, new StringReader(jsonSchema), MISSING_FIELD_TOLERANT_REPRESENTER);
    }

    private static Object convertJsonValue(JsonValue jsonValue) {
        return switch (jsonValue.getValueType()) {
            default -> throw new MatchException(null, null);
            case JsonValue.ValueType.ARRAY -> jsonValue.asJsonArray().stream().map(JsonpAnnotationScannerExtension::convertJsonValue).toList();
            case JsonValue.ValueType.FALSE -> Boolean.FALSE;
            case JsonValue.ValueType.TRUE -> Boolean.TRUE;
            case JsonValue.ValueType.NULL -> null;
            case JsonValue.ValueType.STRING -> ((JsonString)jsonValue).getString();
            case JsonValue.ValueType.NUMBER -> ((JsonNumber)jsonValue).numberValue();
            case JsonValue.ValueType.OBJECT -> jsonValue.asJsonObject().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> JsonpAnnotationScannerExtension.convertJsonValue((JsonValue)entry.getValue())));
        };
    }

    static {
        MISSING_FIELD_TOLERANT_REPRESENTER.getPropertyUtils().setSkipMissingProperties(true);
    }
}

