/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.restclientmetrics;

import io.helidon.microprofile.restclientmetrics.RestClientMetricsFilter;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.WithAnnotations;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.client.ClientRequestContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.runtime.SwitchBootstraps;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Timed;

public class RestClientMetricsCdiExtension
implements Extension {
    private static final System.Logger LOGGER = System.getLogger(RestClientMetricsCdiExtension.class.getName());
    private static final String SAVED_START_TIME_PROPERTY_NAME = RestClientMetricsFilter.class.getName() + ".startTime";
    private static final List<Class<?>> REST_METHOD_ANNOTATIONS = List.of(OPTIONS.class, HEAD.class, GET.class, POST.class, PUT.class, DELETE.class);
    private final Set<Class<?>> candidateRestClientTypes = new HashSet();
    private final Map<Method, List<MetricsUpdateWork>> metricsUpdateWorkByMethod = new HashMap<Method, List<MetricsUpdateWork>>();
    private final Map<Class<?>, Map<Method, Set<Registration>>> registrations = new HashMap();
    private final Collection<Class<?>> deferredRestClients = new ConcurrentLinkedQueue();
    private MetricRegistry metricRegistry;

    void recordRestClientTypes(@Observes @WithAnnotations(value={OPTIONS.class, HEAD.class, GET.class, POST.class, PUT.class, DELETE.class, PATCH.class}) ProcessAnnotatedType<?> pat) {
        if (pat.getAnnotatedType().getJavaClass().isInterface()) {
            Class javaType = pat.getAnnotatedType().getJavaClass();
            this.candidateRestClientTypes.add(javaType);
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                LOGGER.log(System.Logger.Level.TRACE, "Recording " + javaType.getCanonicalName() + " for REST client processing");
            }
        }
    }

    void prepareMetricRegistrations(@Observes AfterBeanDiscovery abd) {
        this.candidateRestClientTypes.forEach(type -> {
            LOGGER.log(System.Logger.Level.DEBUG, "Analyzing candidate REST client interface " + type.getCanonicalName());
            Set typeLevelMetricAnnotationsOverTypeClosure = StreamSupport.stream(abd.getAnnotatedTypes(type).spliterator(), false).flatMap(at -> at.getTypeClosure().stream()).filter(t -> t instanceof Class).map(t -> (Class)t).filter(this.candidateRestClientTypes::contains).flatMap(t -> StreamSupport.stream(abd.getAnnotatedTypes(t).spliterator(), false)).flatMap(at -> Stream.of(Timed.class, Counted.class).map(arg_0 -> ((AnnotatedType)at).getAnnotation(arg_0)).filter(Objects::nonNull)).collect(Collectors.toSet());
            HashMap registrationsByMethodForType = new HashMap();
            StreamSupport.stream(abd.getAnnotatedTypes(type).spliterator(), false).flatMap(at -> at.getTypeClosure().stream()).filter(t -> t instanceof Class).map(t -> (Class)t).filter(this.candidateRestClientTypes::contains).forEach(typeInClosure -> StreamSupport.stream(abd.getAnnotatedTypes(typeInClosure).spliterator(), false).forEach(annotatedTypeInClosure -> {
                LOGGER.log(System.Logger.Level.DEBUG, "Examining type " + annotatedTypeInClosure.getJavaClass().getCanonicalName());
                annotatedTypeInClosure.getMethods().stream().filter(RestClientMetricsCdiExtension::hasRestAnnotation).forEach(annotatedMethod -> {
                    Set registrationsForMethod = registrationsByMethodForType.computeIfAbsent(annotatedMethod.getJavaMember(), k -> new HashSet());
                    Set registrationsFromMethod = Stream.of(Timed.class, Counted.class).map(arg_0 -> ((AnnotatedMethod)annotatedMethod).getAnnotation(arg_0)).filter(Objects::nonNull).map(anno -> Registration.create(annotatedTypeInClosure.getJavaClass(), annotatedMethod, anno, false)).collect(Collectors.toSet());
                    registrationsForMethod.addAll(registrationsFromMethod);
                    LOGGER.log(System.Logger.Level.DEBUG, "Adding metric registrations for annotations on method " + annotatedMethod.getJavaMember().getDeclaringClass().getCanonicalName() + "." + annotatedMethod.getJavaMember().getName() + ":" + String.valueOf(registrationsFromMethod));
                    Set registrationsFromTypeLevelAnnotations = typeLevelMetricAnnotationsOverTypeClosure.stream().map(anno -> Registration.create(annotatedTypeInClosure.getJavaClass(), annotatedMethod, anno, true)).collect(Collectors.toSet());
                    registrationsForMethod.addAll(registrationsFromTypeLevelAnnotations);
                    LOGGER.log(System.Logger.Level.DEBUG, "Adding metric registrations for type-level annotations " + String.valueOf(registrationsFromTypeLevelAnnotations));
                });
                this.registrations.put((Class<?>)type, registrationsByMethodForType);
            }));
        });
    }

    void ready(@Observes @Initialized(value=ApplicationScoped.class) Object event, MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
        this.deferredRestClients.forEach(this::registerMetricsForRestClient);
        this.deferredRestClients.clear();
    }

    void registerMetricsForRestClient(Class<?> restClient) {
        if (this.metricRegistry == null) {
            this.deferredRestClients.add(restClient);
            return;
        }
        this.registrations.get(restClient).forEach((method, regs) -> {
            ArrayList metricsRegisteredForRestClient = LOGGER.isLoggable(System.Logger.Level.DEBUG) ? new ArrayList() : null;
            regs.forEach(registration -> {
                Metric metric = registration.registrationOp.apply(this.metricRegistry);
                if (metricsRegisteredForRestClient != null) {
                    metricsRegisteredForRestClient.add(metric);
                    LOGGER.log(System.Logger.Level.DEBUG, String.format("For REST client method %s#%s registering metric using %s", restClient.getCanonicalName(), method.getName(), registration));
                }
                this.metricsUpdateWorkByMethod.computeIfAbsent((Method)method, k -> new ArrayList()).add(MetricsUpdateWork.create(metric));
                if (metricsRegisteredForRestClient != null && metricsRegisteredForRestClient.isEmpty()) {
                    LOGGER.log(System.Logger.Level.DEBUG, "No metrics registered for REST client " + restClient.getCanonicalName());
                }
            });
        });
    }

    void doPreWork(Method method, ClientRequestContext context) {
        List<MetricsUpdateWork> workItems = this.metricsUpdateWorkByMethod.get(method);
        if (workItems != null) {
            workItems.forEach(workItem -> workItem.preWork(context));
        }
    }

    void doPostWork(Method method, ClientRequestContext context) {
        List<MetricsUpdateWork> workItems = this.metricsUpdateWorkByMethod.get(method);
        if (workItems != null) {
            workItems.forEach(workItem -> workItem.postWork(context));
        }
    }

    Map<Method, List<MetricsUpdateWork>> metricsUpdateWorkByMethod() {
        return this.metricsUpdateWorkByMethod;
    }

    private static Tag[] tags(Annotation metricAnnotation) {
        Annotation annotation = metricAnnotation;
        Objects.requireNonNull(annotation);
        Annotation annotation2 = annotation;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Counted.class, Timed.class}, (Object)annotation2, n)) {
            case 0 -> {
                Counted counted = (Counted)annotation2;
                yield RestClientMetricsCdiExtension.tags(counted.tags());
            }
            case 1 -> {
                Timed timed = (Timed)annotation2;
                yield RestClientMetricsCdiExtension.tags(timed.tags());
            }
            default -> null;
        };
    }

    private static Tag[] tags(String[] tagExprs) {
        return (Tag[])Stream.of(tagExprs).map(tagExpr -> {
            int eq = tagExpr.indexOf("=");
            if (eq <= 0 || eq == tagExpr.length() - 1) {
                throw new IllegalArgumentException("Tag expression " + tagExpr + " in annotation has missing or misplaced = sign.");
            }
            return new Tag(tagExpr.substring(0, eq).trim(), tagExpr.substring(eq).trim());
        }).toArray(Tag[]::new);
    }

    private static boolean hasRestAnnotation(AnnotatedMethod<?> am) {
        return am.getAnnotations().stream().anyMatch(anno -> REST_METHOD_ANNOTATIONS.contains(anno.annotationType()));
    }

    private static String chooseMetricName(Class<?> type, AnnotatedMethod<?> method, Annotation metricAnnotation, boolean isTypeLevel) {
        Annotation annotation = metricAnnotation;
        Objects.requireNonNull(annotation);
        Annotation annotation2 = annotation;
        int n = 0;
        boolean isAbsolute = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Timed.class, Counted.class}, (Object)annotation2, n)) {
            case 0 -> {
                Timed timed = (Timed)annotation2;
                yield timed.absolute();
            }
            case 1 -> {
                Counted counted = (Counted)annotation2;
                yield counted.absolute();
            }
            default -> false;
        };
        Annotation annotation3 = metricAnnotation;
        Objects.requireNonNull(annotation3);
        Annotation annotation4 = annotation3;
        int n2 = 0;
        String specifiedName = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Timed.class, Counted.class}, (Object)annotation4, n2)) {
            case 0 -> {
                Timed timed = (Timed)annotation4;
                yield timed.name();
            }
            case 1 -> {
                Counted counted = (Counted)annotation4;
                yield counted.name();
            }
            default -> "";
        };
        AnnotatedType declaringType = method.getDeclaringType();
        return !isTypeLevel ? (isAbsolute ? (specifiedName.isEmpty() ? method.getJavaMember().getName() : specifiedName) : declaringType.getJavaClass().getCanonicalName() + "." + (specifiedName.isEmpty() ? method.getJavaMember().getName() : specifiedName)) : (String)(isAbsolute ? (specifiedName.isEmpty() ? type.getSimpleName() : specifiedName) : (specifiedName.isEmpty() ? declaringType.getJavaClass().getCanonicalName() : declaringType.getJavaClass().getPackageName() + "." + specifiedName)) + "." + method.getJavaMember().getName();
    }

    record MetricsUpdateWork(Consumer<ClientRequestContext> preWork, Consumer<ClientRequestContext> postWork) {
        static MetricsUpdateWork create(Metric metric) {
            Metric metric2 = metric;
            Objects.requireNonNull(metric2);
            Metric metric3 = metric2;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Timer.class, Counter.class}, (Object)metric3, n)) {
                case 0 -> {
                    Timer timer = (Timer)metric3;
                    yield MetricsUpdateWork.create(cctx -> cctx.setProperty(SAVED_START_TIME_PROPERTY_NAME, (Object)System.nanoTime()), cctx -> {
                        long startTime = (Long)cctx.getProperty(SAVED_START_TIME_PROPERTY_NAME);
                        timer.update(Duration.ofNanos(System.nanoTime() - startTime));
                    });
                }
                case 1 -> {
                    Counter counter = (Counter)metric3;
                    yield MetricsUpdateWork.create((ClientRequestContext cctx) -> counter.inc());
                }
                default -> null;
            };
        }

        void preWork(ClientRequestContext requestContext) {
            if (this.preWork != null) {
                this.preWork.accept(requestContext);
            }
        }

        void postWork(ClientRequestContext requestContext) {
            if (this.postWork != null) {
                this.postWork.accept(requestContext);
            }
        }

        private static MetricsUpdateWork create(Consumer<ClientRequestContext> preWork, Consumer<ClientRequestContext> postWork) {
            return new MetricsUpdateWork(preWork, postWork);
        }

        private static MetricsUpdateWork create(Consumer<ClientRequestContext> preWork) {
            return new MetricsUpdateWork(preWork, null);
        }
    }

    private record Registration(String metricName, Tag[] tags, Metadata metadata, Annotation metricAnnotation, Function<MetricRegistry, ? extends Metric> registrationOp) {
        static Registration create(Class<?> declaringType, AnnotatedMethod<?> method, Annotation metricAnnotation, boolean isTypeLevel) {
            Metadata metadata = Metadata.builder().withName(RestClientMetricsCdiExtension.chooseMetricName(declaringType, method, metricAnnotation, isTypeLevel)).withDescription("REST client " + (metricAnnotation.annotationType().isAssignableFrom(Timed.class) ? "timer" : "counter") + declaringType.getSimpleName() + "." + method.getJavaMember().getName()).build();
            Tag[] tagsFromAnnotation = RestClientMetricsCdiExtension.tags(metricAnnotation);
            Annotation annotation = metricAnnotation;
            Objects.requireNonNull(annotation);
            Annotation annotation2 = annotation;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Timed.class, Counted.class}, (Object)annotation2, n)) {
                case 0 -> {
                    Timed timed = (Timed)annotation2;
                    yield new Registration(metadata.getName(), tagsFromAnnotation, metadata, (Annotation)timed, mr -> mr.timer(metadata, tagsFromAnnotation));
                }
                case 1 -> {
                    Counted counted = (Counted)annotation2;
                    yield new Registration(metadata.getName(), tagsFromAnnotation, metadata, (Annotation)counted, mr -> mr.counter(metadata, tagsFromAnnotation));
                }
                default -> null;
            };
        }

        @Override
        public String toString() {
            return new StringJoiner(", ", Registration.class.getSimpleName() + "[", "]").add("metadata=" + String.valueOf(this.metadata)).add("tags=" + Arrays.toString(this.tags)).add("metricAnnotation=" + String.valueOf(this.metricAnnotation)).toString();
        }
    }
}

