/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.restclientmetrics;

import io.helidon.microprofile.restclientmetrics.RestClientMetricsCdiExtension;
import jakarta.annotation.Priority;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.ext.Provider;
import java.lang.reflect.Method;

@Priority(value=4900)
@Provider
class RestClientMetricsFilter
implements ClientRequestFilter,
ClientResponseFilter {
    static final String REST_CLIENT_METRICS_CONFIG_KEY = "rest-client.metrics";
    private static final String INVOKED_METHOD = "org.eclipse.microprofile.rest.client.invokedMethod";
    private final RestClientMetricsCdiExtension ext = (RestClientMetricsCdiExtension)CDI.current().getBeanManager().getExtension(RestClientMetricsCdiExtension.class);

    private RestClientMetricsFilter() {
    }

    static RestClientMetricsFilter create() {
        return new RestClientMetricsFilter();
    }

    public void filter(ClientRequestContext requestContext) {
        Method javaMethod = (Method)requestContext.getProperty(INVOKED_METHOD);
        if (javaMethod != null) {
            this.ext.doPreWork(javaMethod, requestContext);
        }
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) {
        Method javaMethod = (Method)requestContext.getProperty(INVOKED_METHOD);
        if (javaMethod != null) {
            this.ext.doPostWork(javaMethod, requestContext);
        }
    }
}

