/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.server;

import io.helidon.config.Config;
import io.helidon.microprofile.server.JaxRsApplication;
import io.helidon.microprofile.server.JaxRsService;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessManagedBean;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.microprofile.config.ConfigProvider;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.server.ResourceConfig;

public class JaxRsCdiExtension
implements Extension {
    private static final System.Logger LOGGER = System.getLogger(JaxRsCdiExtension.class.getName());
    private final List<JaxRsApplication> applicationMetas = new LinkedList<JaxRsApplication>();
    private final Set<Class<? extends Application>> applications = new LinkedHashSet<Class<? extends Application>>();
    private final Set<Class<?>> resources = new HashSet();
    private final Set<Class<?>> providers = new HashSet();
    private final AtomicBoolean setInStone = new AtomicBoolean(false);

    private void collectApplications(@Observes ProcessManagedBean<? extends Application> processManagedBean) {
        this.applications.add(processManagedBean.getAnnotatedBeanClass().getJavaClass());
    }

    private void collectResourceClasses(@Observes ProcessManagedBean<?> processManagedBean) {
        Class resourceClass = processManagedBean.getAnnotatedBeanClass().getJavaClass();
        if (JaxRsCdiExtension.hasAnnotation(resourceClass, Path.class)) {
            if (resourceClass.isInterface()) {
                return;
            }
            LOGGER.log(System.Logger.Level.TRACE, () -> "Discovered resource class " + resourceClass.getName());
            this.resources.add(resourceClass);
        }
    }

    private void collectProviderClasses(@Observes ProcessManagedBean<?> processManagedBean) {
        if (processManagedBean.getAnnotated().isAnnotationPresent(Provider.class)) {
            Class providerClass = processManagedBean.getAnnotatedBeanClass().getJavaClass();
            if (providerClass.isInterface()) {
                LOGGER.log(System.Logger.Level.TRACE, () -> "Discovered @Provider interface " + providerClass.getName() + ", ignored as we only support classes");
                return;
            }
            LOGGER.log(System.Logger.Level.TRACE, () -> "Discovered @Provider class " + providerClass.getName());
            this.providers.add(providerClass);
        }
    }

    void fixApps(@Observes @Priority(value=0) @Initialized(value=ApplicationScoped.class) Object event) {
        this.setInStone.set(true);
    }

    public List<JaxRsApplication> applicationsToRun() throws IllegalStateException {
        if (!this.setInStone.get()) {
            throw new IllegalStateException("Applications are not yet fixed. This method is only available in @Initialized(ApplicationScoped.class) event, before server is started");
        }
        HashSet allClasses = new HashSet();
        allClasses.addAll(this.resources);
        allClasses.addAll(this.providers);
        if (this.applications.isEmpty() && this.applicationMetas.isEmpty() && !this.resources.isEmpty()) {
            this.addSyntheticApp(allClasses);
        }
        this.applicationMetas.addAll(this.applications.stream().map(appClass -> JaxRsApplication.builder().applicationClass((Class<? extends Application>)appClass).config(ResourceConfig.forApplicationClass((Class)appClass, (Set)allClasses)).build()).toList());
        this.applications.clear();
        this.resources.clear();
        return this.applicationMetas;
    }

    public void removeApplications() throws IllegalStateException {
        this.mutateApps();
        this.applications.clear();
    }

    public void removeResourceClasses() throws IllegalStateException {
        this.mutateApps();
        this.resources.clear();
    }

    public void addResourceClasses(List<Class<?>> resourceClasses) throws IllegalStateException {
        this.mutateApps();
        this.resources.addAll(resourceClasses);
    }

    public void addApplications(List<JaxRsApplication> applications) throws IllegalStateException {
        this.mutateApps();
        this.applicationMetas.addAll(applications);
    }

    public void addApplication(Application application) throws IllegalStateException {
        this.mutateApps();
        this.applicationMetas.add(JaxRsApplication.create(application));
    }

    public void addApplication(String contextRoot, Application application) throws IllegalStateException {
        this.mutateApps();
        this.applicationMetas.add(JaxRsApplication.builder().application(application).contextRoot(contextRoot).build());
    }

    public String serviceName() {
        org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
        return config.getOptionalValue("service.name", String.class).or(() -> config.getOptionalValue("tracing.service", String.class)).or(this::guessServiceName).orElse("helidon-mp");
    }

    private Optional<String> guessServiceName() {
        if (this.applicationMetas.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.applicationMetas.get(0).appName());
    }

    public void addSyntheticApplication(List<Class<?>> resourceClasses) throws IllegalStateException {
        this.mutateApps();
        this.addSyntheticApp(resourceClasses);
    }

    private void addSyntheticApp(Collection<Class<?>> resourceClasses) {
        final Set<Class<?>> classes = Set.copyOf(resourceClasses);
        this.applicationMetas.add(JaxRsApplication.builder().synthetic(true).applicationClass(Application.class).config(ResourceConfig.forApplication((Application)new Application(this){

            public Set<Class<?>> getClasses() {
                return classes;
            }
        })).appName("HelidonMP").build());
    }

    JaxRsService toJerseySupport(JaxRsApplication jaxRsApplication, InjectionManager injectionManager) {
        ResourceConfig resourceConfig = jaxRsApplication.resourceConfig();
        return JaxRsService.create(resourceConfig, injectionManager);
    }

    Optional<String> findContextRoot(Config config, JaxRsApplication jaxRsApplication) {
        return config.get(jaxRsApplication.appClassName() + ".routing-path.path").asString().or(jaxRsApplication::contextRoot).map(path -> path.startsWith("/") ? path : "/" + path);
    }

    Optional<String> findNamedRouting(Config config, JaxRsApplication jaxRsApplication) {
        return config.get(jaxRsApplication.appClassName() + ".routing-name.name").asString().or(jaxRsApplication::routingName).flatMap(it -> "@default".equals(it) ? Optional.empty() : Optional.of(it));
    }

    boolean isNamedRoutingRequired(Config config, JaxRsApplication jaxRsApplication) {
        return (Boolean)config.get(jaxRsApplication.appClassName() + ".routing-name.required").asBoolean().orElseGet(jaxRsApplication::routingNameRequired);
    }

    private void mutateApps() {
        if (this.setInStone.get()) {
            throw new IllegalStateException("You are attempting to modify applications in JAX-RS after they were registered with the server");
        }
    }

    private static boolean hasAnnotation(Class<?> clazz, Class<? extends Annotation> annotation) {
        if (clazz == null || clazz == Object.class) {
            return false;
        }
        if (clazz.isAnnotationPresent(annotation) || JaxRsCdiExtension.hasAnnotation(clazz.getSuperclass(), annotation)) {
            return true;
        }
        for (Class<?> type : clazz.getInterfaces()) {
            if (!JaxRsCdiExtension.hasAnnotation(type, annotation)) continue;
            return true;
        }
        return false;
    }
}

