/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.server;

import io.helidon.webserver.http.ServerRequest;
import jakarta.annotation.Priority;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;

@Provider
@Priority(value=5000)
public class CatchAllExceptionMapper
implements ExceptionMapper<Exception> {
    private static final System.Logger LOGGER = System.getLogger(CatchAllExceptionMapper.class.getName());
    @Context
    private ServerRequest serverRequest;

    public Response toResponse(Exception exception) {
        this.serverRequest.context().register((Object)"unmappedException", (Object)exception);
        if (exception instanceof WebApplicationException) {
            WebApplicationException wae = (WebApplicationException)exception;
            return wae.getResponse();
        }
        LOGGER.log(System.Logger.Level.WARNING, () -> "Internal server error", (Throwable)exception);
        return Response.serverError().build();
    }
}

