/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.server;

import io.helidon.config.Config;
import io.helidon.microprofile.server.RoutingBuildersImpl;
import io.helidon.microprofile.server.ServerCdiExtension;
import io.helidon.webserver.http.HttpRouting;
import jakarta.enterprise.inject.spi.CDI;
import org.eclipse.microprofile.config.ConfigProvider;

public interface RoutingBuilders {
    public HttpRouting.Builder defaultRoutingBuilder();

    public HttpRouting.Builder routingBuilder();

    public static RoutingBuilders create(String componentName) {
        return RoutingBuilders.create(((Config)ConfigProvider.getConfig()).get(componentName));
    }

    public static RoutingBuilders create(Config componentConfig) {
        return RoutingBuilders.createFromRoutingName((String)componentConfig.get("routing").asString().orElse(null));
    }

    public static RoutingBuilders createFromRoutingName(String routingName) {
        ServerCdiExtension extension = (ServerCdiExtension)CDI.current().getBeanManager().getExtension(ServerCdiExtension.class);
        HttpRouting.Builder defaultRoutingBuilder = extension.serverRoutingBuilder();
        HttpRouting.Builder serviceRoutingBuilder = routingName == null || routingName.isBlank() || "@default".equals(routingName) ? defaultRoutingBuilder : extension.serverNamedRoutingBuilder(routingName);
        return new RoutingBuildersImpl(defaultRoutingBuilder, serviceRoutingBuilder);
    }
}

